/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.dataquality;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipeStatusComputer;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.ExtractFailedRowsRecipeService;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;

public class ExtractFailedRowsRecipeCreator
extends SISORecipeCreator {
    private ExtractFailedRowsRecipeService service = new ExtractFailedRowsRecipeService();

    public ExtractFailedRowsRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
        SpringUtils.getInstance().autowire((Object)this.service);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        ExtractFailedRowsRecipeCreationSettings settings = (ExtractFailedRowsRecipeCreationSettings)JSON.parse((JsonElement)data, ExtractFailedRowsRecipeCreationSettings.class);
        ExtractFailedRowsRecipePayloadParams params = new ExtractFailedRowsRecipePayloadParams();
        if (settings.params != null) {
            params.explicitColumnSelection = settings.params.explicitColumnSelection;
            params.columnRules = settings.params.columnRules;
        }
        List<DataQualityRule> rules = inputDataset.getModel().getDataQualityRuleSet().getRules();
        if (params.columnRules.isEmpty() && !rules.isEmpty()) {
            List<ExtractFailedRowsRecipePayloadParams.UIColumnRuleDesc> consolidateColumnRules = ExtractFailedRowsRecipeStatusComputer.consolidateColumnRules(params, inputDataset, null, null, false);
            consolidateColumnRules.forEach(uiColumnRuleDesc -> {
                ExtractFailedRowsRecipePayloadParams.ColumnRuleDesc columnRuleDesc = new ExtractFailedRowsRecipePayloadParams.ColumnRuleDesc();
                columnRuleDesc.ruleId = uiColumnRuleDesc.ruleId;
                columnRuleDesc.ruleColumn = uiColumnRuleDesc.ruleColumn;
                columnRuleDesc.isSelected = uiColumnRuleDesc.isSelected;
                params.columnRules.add(columnRuleDesc);
            });
        }
        RecipeCreationUtils.setupAllEnginesCreationParams(this.authCtx, recipe.projectKey, params.engineParams);
        RecipeCreationUtils.switchToHiveserverForHiveDataset(inputDataset, params.engineParams);
        params.engineParams.lowerCaseSchemaIfEngineRequiresIt = true;
        return JSON.json((Object)params);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        Dataset inputDataset = this.getInputDataset(recipe);
        ExtractFailedRowsRecipePayloadParams params = this.service.loadParams(payload, recipe);
        Schema outputSchema = this.service.getOutputSchemaAfterOverride(inputDataset, params, false, null);
        outputDataset.setSchema(outputSchema);
    }

    public static class ExtractFailedRowsRecipeCreationSettings
    extends SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings {
        public ExtractFailedRowsRecipePayloadParams params;
    }
}

