/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.download;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.GeneratorEvaluator;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.download.DownloadRecipeParams;
import com.dataiku.dip.recipes.download.DownloadRecipeSource;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.KernelsDownloadRecipeService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Maps;
import java.util.HashMap;

public class DownloadRecipeGeneratorEvaluator
implements GeneratorEvaluator {
    private final SerializedRecipe serializedRecipe;

    DownloadRecipeGeneratorEvaluator(SerializedRecipe serializedRecipe) {
        this.serializedRecipe = serializedRecipe;
    }

    @Override
    public boolean isExecutionNeeded(FlowComputable targetComputable, Partition targetPartition) throws Exception {
        String partitionPrefix;
        KernelsDownloadRecipeService kernelsDownloadRecipeService = (KernelsDownloadRecipeService)SpringUtils.getBean(KernelsDownloadRecipeService.class);
        JobAuthCtxService jobAuthCtxService = (JobAuthCtxService)SpringUtils.getBean(JobAuthCtxService.class);
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        ManagedFolder managedFolder = ((FlowManagedFolder)targetComputable).getManagedFolder();
        AuthCtx authCtx = jobAuthCtxService.getAuthCtx();
        DownloadRecipeParams params = (DownloadRecipeParams)JSON.deepCopy((Object)((DownloadRecipeParams)this.serializedRecipe.params));
        String contextProjectKey = this.serializedRecipe.projectKey;
        HashMap allVariables = Maps.newHashMap();
        allVariables.putAll(variablesService.getForProject(contextProjectKey).getAllVariables());
        if (managedFolder.getPartitioningSchema().isPartitioned()) {
            if (!FilePartitioner.isSchemeRepresentableAsFolder(managedFolder.getPartitioningSchema())) {
                throw new Exception("The partitioning scheme of the target cannot be represented as folders");
            }
            partitionPrefix = FilePartitioner.computePartitionRelPathAsFolder(targetPartition, managedFolder.getPartitioningSchema());
            FlowVariables.addVariablesForDstDataset(authCtx, allVariables, managedFolder, targetPartition, "DKU_DST_");
        } else {
            partitionPrefix = "";
        }
        for (DownloadRecipeSource source : params.sources) {
            source.setPath(FlowVariables.substitute(allVariables, source.getPath()));
        }
        return !kernelsDownloadRecipeService.copyFromSourcesToFolder(managedFolder, partitionPrefix, contextProjectKey, authCtx, params, true, Maps.newHashMap()).isEmpty();
    }
}

