/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.download;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class DownloadRecipeSource {
    public boolean useGlobalProxy;
    public String providerType;
    public JsonObject params;

    public String getConnection() {
        if (this.params == null) {
            return null;
        }
        if (this.params.get("connection") == null || this.params.get("connection").isJsonNull()) {
            return null;
        }
        return this.params.get("connection").getAsString();
    }

    public void setConnection(String connection) {
        if (this.params != null) {
            this.params.addProperty("connection", connection);
        }
    }

    public String getPath() {
        if (this.params == null) {
            return null;
        }
        if (this.params.get("path") == null || this.params.get("path").isJsonNull()) {
            return null;
        }
        return this.params.get("path").getAsString();
    }

    public void setPath(String path) {
        if (this.params != null) {
            this.params.addProperty("path", path);
        }
    }

    public AbstractFSDatasetHandler.AbstractFSConfig getParams(AuthCtx authCtx, ConnectionsDAO connectionsDAO) throws IOException, DKUSecurityException {
        if (this.params == null) {
            return null;
        }
        if (StringUtils.isNotBlank((String)this.providerType)) {
            if (DatasetHandlerFactory.hasParamsClass(this.providerType)) {
                return (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((JsonElement)this.params, DatasetHandlerFactory.getParamsClass(this.providerType));
            }
            return (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((JsonElement)this.params, URLConfig.class);
        }
        JsonElement connectionElt = this.params.get("connection");
        if (connectionElt.isJsonNull() || StringUtils.isBlank((String)connectionElt.getAsString())) {
            return null;
        }
        DSSConnection connection = connectionsDAO.getMandatoryConnectionUnsafeUnexpanded(authCtx, connectionElt.getAsString());
        String providerType = connection.getType();
        return (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((JsonElement)this.params, DatasetHandlerFactory.getParamsClass(providerType));
    }

    public void setParams(AbstractFSDatasetHandler.AbstractFSConfig params) {
        this.params = params == null ? null : JSON.toJsonObject((Object)params, (String[])new String[0]);
    }

    public static class URLConfig
    extends AbstractFSDatasetHandler.AbstractFSConfig {
        private static final long serialVersionUID = -1L;
        public boolean consider404AsEmpty = true;
        public boolean fallbackHeadToGet = true;
        public boolean trustAnySSLCertificate = false;
    }
}

