/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum PCARecipeOutputRole {
    PROJECTIONS("main"),
    EIGENVECTORS("eigenvectors"),
    EIGENVALUES("eigenvalues");

    public final String name;

    private PCARecipeOutputRole(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static PCARecipeOutputRole from(String name) {
        for (PCARecipeOutputRole role2 : PCARecipeOutputRole.values()) {
            if (!role2.name.equals(name)) continue;
            return role2;
        }
        String validNames = Arrays.stream(PCARecipeOutputRole.values()).map(role -> role.name).collect(Collectors.joining(", "));
        throw new IllegalArgumentException(String.format("Invalid PCA recipe output role name: %s. Valid options are: %s", name, validNames));
    }
}

