/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.eda.worksheets.models.SplitBySpec;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import com.dataiku.dip.recipes.eda.stats.Chi2IndependenceTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.NSampleLeveneTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.NSampleMoodTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.OneSampleShapiroTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.OneSampleSignTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.OneSampleTTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.OneWayAnovaTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.PairwiseLeveneTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.PairwiseMoodTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.PairwiseTTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.TwoSampleKSTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.TwoSampleLeveneTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.TwoSampleMoodTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.TwoSampleTTestRecipePayloadParams;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@PolyJSON(value={@Mapping(value=OneSampleTTestRecipePayloadParams.class, type="recipe_one-sample-t-test"), @Mapping(value=OneSampleSignTestRecipePayloadParams.class, type="recipe_one-sample-sign-test"), @Mapping(value=OneSampleShapiroTestRecipePayloadParams.class, type="recipe_one-sample-shapiro-test"), @Mapping(value=TwoSampleTTestRecipePayloadParams.class, type="recipe_two-sample-t-test"), @Mapping(value=TwoSampleMoodTestRecipePayloadParams.class, type="recipe_two-sample-mood-test"), @Mapping(value=TwoSampleLeveneTestRecipePayloadParams.class, type="recipe_two-sample-levene-test"), @Mapping(value=TwoSampleKSTestRecipePayloadParams.class, type="recipe_two-sample-ks-test"), @Mapping(value=OneWayAnovaTestRecipePayloadParams.class, type="recipe_one-way-anova-test"), @Mapping(value=NSampleMoodTestRecipePayloadParams.class, type="recipe_n-sample-mood-test"), @Mapping(value=NSampleLeveneTestRecipePayloadParams.class, type="recipe_n-sample-levene-test"), @Mapping(value=PairwiseTTestRecipePayloadParams.class, type="recipe_pairwise-t-test"), @Mapping(value=PairwiseMoodTestRecipePayloadParams.class, type="recipe_pairwise-mood-test"), @Mapping(value=PairwiseLeveneTestRecipePayloadParams.class, type="recipe_pairwise-levene-test"), @Mapping(value=Chi2IndependenceTestRecipePayloadParams.class, type="recipe_chi2-independence-test")})
@UIModel
public abstract class StatsTestRecipePayloadParams<T extends AbstractTestStat>
extends RecipePayloadParams {
    public boolean addComputationTimestamp = false;
    public List<T> stats = new ArrayList<T>();
    public double confidenceLevel = 0.95;
    @Nullable
    public SplitBySpec splitBy = null;

    protected StatsTestRecipePayloadParams(T stat, double confidenceLevel, @Nullable SplitBySpec splitBy) {
        this.stats = new ArrayList<T>();
        this.stats.add(stat);
        this.confidenceLevel = confidenceLevel;
        this.splitBy = splitBy;
    }

    protected StatsTestRecipePayloadParams() {
    }

    public <U extends StatsTestRecipePayloadParams<?>> U as(Class<U> clazz) {
        if (clazz.isInstance(this)) {
            return (U)((StatsTestRecipePayloadParams)clazz.cast(this));
        }
        throw new RuntimeException("Expected " + clazz.getName() + " but was " + this.getClass().getName());
    }

    @Override
    public void validate() {
        if (this.confidenceLevel < 0.0) {
            throw ErrorContext.iae((String)"The confidence level must be positive");
        }
        if (this.confidenceLevel > 1.0) {
            throw ErrorContext.iae((String)"The confidence level must be less than 1");
        }
    }

    public abstract List<SchemaColumn> getSchemaColumns();

    public double significanceLevel() {
        BigDecimal cl = BigDecimal.valueOf(this.confidenceLevel);
        BigDecimal sl = BigDecimal.ONE.subtract(cl);
        return sl.doubleValue();
    }

    public abstract String getType();
}

