/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.stats.AlternativeHypothesis;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@UIModel
public interface StatsTestRecipePayloadParamsWithAlternativeHypothesis {
    public AlternativeHypothesis[] getAlternatives();

    default public List<AlternativeComputationResult> buildResultsForAlternatives(ComputationResult result) {
        if (!result.isAvailable()) {
            return Arrays.stream(this.getAlternatives()).map(alt -> new AlternativeComputationResult((AlternativeHypothesis)((Object)alt), result)).collect(Collectors.toList());
        }
        AlternativeHypothesis[] alternatives = this.getAlternatives();
        MultiComputation.MultiComputationResult testMcr = result.asMulti();
        if (testMcr.size() != alternatives.length) {
            throw new IllegalArgumentException(String.format("Expected exactly test results for %d alternatives, got %d", alternatives.length, testMcr.size()));
        }
        ArrayList<AlternativeComputationResult> alternativeComputationResults = new ArrayList<AlternativeComputationResult>();
        int alternativeIndex = 0;
        for (ComputationResult tr : testMcr) {
            AlternativeHypothesis alternative = alternatives[alternativeIndex];
            alternativeComputationResults.add(new AlternativeComputationResult(alternative, tr));
            ++alternativeIndex;
        }
        return alternativeComputationResults;
    }

    public static class AlternativeComputationResult {
        public AlternativeHypothesis alternative;
        public ComputationResult result;

        AlternativeComputationResult(AlternativeHypothesis alternative, ComputationResult result) {
            this.alternative = alternative;
            this.result = result;
        }
    }
}

