/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParamsWithAlternativeHypothesis;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class StatsTestRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    private StatsTestRecipePayloadParams<?> payloadParams;

    public StatsTestRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.payloadParams = (StatsTestRecipePayloadParams)JSON.parse((String)payload, StatsTestRecipePayloadParams.class);
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        if (!"main".equals(role)) {
            throw new IllegalArgumentException(String.format("Only the role '%s' is supported, got '%s'", "main", role));
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
        }
        return Collections.singletonList(this.getOutputSchema());
    }

    public Schema getOutputSchema() {
        ArrayList<SchemaColumn> columns = new ArrayList<SchemaColumn>();
        columns.add(new SchemaColumn("test", Type.STRING));
        if (this.payloadParams instanceof StatsTestRecipePayloadParamsWithAlternativeHypothesis) {
            columns.add(new SchemaColumn("alternative_hypothesis", Type.STRING));
            columns.add(new SchemaColumn("alternative_hypothesis_explanation", Type.STRING));
        }
        columns.add(new SchemaColumn("split_mode", Type.STRING));
        columns.add(new SchemaColumn("split_by", Type.STRING));
        columns.add(new SchemaColumn("split_value", Type.STRING));
        columns.addAll(this.payloadParams.getSchemaColumns());
        columns.add(new SchemaColumn("warnings", Type.STRING));
        columns.add(new SchemaColumn("errors", Type.STRING));
        if (this.payloadParams.addComputationTimestamp) {
            SchemaColumn sc = new SchemaColumn("computation_timestamp", Type.DATE);
            columns.add(sc);
        }
        return new Schema(columns, false);
    }
}

