/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.grouping.AnumGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.recipes.eda.EDASchemaColumns;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractMultiSampleTestStat;
import com.dataiku.dip.recipes.eda.stats.PopulationBoxPlot;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class AbstractTwoSampleTestStat
extends AbstractMultiSampleTestStat {
    @Nullable
    public String[] groupValues1 = null;
    @Nullable
    public String[] groupValues2 = null;

    protected AbstractTwoSampleTestStat(String testColumn, String groupByColumn, @Nullable String[] groupValues1, @Nullable String[] groupValues2) {
        super(testColumn, groupByColumn);
        this.groupValues1 = groupValues1;
        this.groupValues2 = groupValues2;
    }

    protected AbstractTwoSampleTestStat() {
    }

    @Override
    protected Grouping getPopulationGrouping() {
        if (this.groupValues1 == null && this.groupValues2 == null) {
            return new AnumGrouping(this.groupByColumn, 2, false);
        }
        Objects.requireNonNull(this.groupValues1, "groupValues1 must not be null when groupValues2 is not");
        Objects.requireNonNull(this.groupValues2, "groupValues2 must not be null when groupValues1 is not");
        AnumFilter filter1 = new AnumFilter(this.groupByColumn, Sets.newHashSet((Object[])this.groupValues1));
        AnumFilter filter2 = new AnumFilter(this.groupByColumn, Sets.newHashSet((Object[])this.groupValues2));
        return new UnionGrouping(new SubsetGrouping(filter1), new SubsetGrouping(filter2));
    }

    protected void fillPopulations(List<PopulationBoxPlot> populationBoxPlots, @Nullable BoxPlotFragment mergedBoxPlot, Row row, ColumnFactory cf) {
        if (populationBoxPlots.size() > 2) {
            throw new IllegalArgumentException(String.format("Expected at most two populations, got %d", populationBoxPlots.size()));
        }
        for (int i = 0; i < populationBoxPlots.size(); ++i) {
            PopulationBoxPlot pbp = populationBoxPlots.get(i);
            row.put(cf.column(EDASchemaColumns.population(i + 1)), JSON.json(pbp.values));
            row.put(cf.column(EDASchemaColumns.sampleStatistics(i + 1)), JSON.json((Object)((Object)pbp.boxPlot)));
        }
        if (mergedBoxPlot != null) {
            row.put(cf.column("sample_statistics_both_populations"), JSON.json((Object)((Object)mergedBoxPlot)));
        }
    }

    protected abstract void fillTestResult(AvailableResult var1, double var2, ColumnFactory var4, Row var5);

    @Override
    protected List<Row> extractTestRows(ComputationResult testResult, StatsTestRecipePayloadParams<?> payloadParams, List<PopulationBoxPlot> populationBoxPlots, @Nullable BoxPlotFragment mergedBoxPlot, Collection<String> boxPlotWarnings, Collection<String> boxPlotErrors, ColumnFactory cf, RowFactory rf) {
        LinkedHashSet<String> warnings = new LinkedHashSet<String>(testResult.collectWarnings());
        warnings.addAll(boxPlotWarnings);
        LinkedHashSet<String> errors = new LinkedHashSet<String>(testResult.collectErrors());
        errors.addAll(boxPlotErrors);
        double significanceLevel = payloadParams.significanceLevel();
        Row row = this.rowBase(significanceLevel, warnings, errors, cf, rf);
        this.fillPopulations(populationBoxPlots, mergedBoxPlot, row, cf);
        if (testResult.isAvailable()) {
            this.fillTestResult(testResult.asAvailable(), significanceLevel, cf, row);
        }
        return Collections.singletonList(row);
    }
}

