/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.univariate;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.recipes.eda.UnivariateRecipePayloadParams;
import com.dataiku.dip.recipes.eda.univariate.UnivariateAnalysis;
import com.dataiku.dip.recipes.eda.univariate.UnivariateAnalysisFrequencyTable;
import com.dataiku.dip.recipes.eda.univariate.UnivariateAnalysisQuantileTable;
import com.dataiku.dip.recipes.eda.univariate.UnivariateAnalysisSummaryStats;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;

public class UnivariateAnalysisWrapper
extends UnivariateAnalysis {
    public UnivariateAnalysisSummaryStats summaryStats;
    public UnivariateAnalysisFrequencyTable frequencyTable;
    public UnivariateAnalysisQuantileTable quantileTable;

    public UnivariateAnalysisWrapper(Variable column) {
        this.column = column;
        this.summaryStats = new UnivariateAnalysisSummaryStats(column);
        this.frequencyTable = new UnivariateAnalysisFrequencyTable(column);
        this.quantileTable = new UnivariateAnalysisQuantileTable(column);
    }

    private UnivariateAnalysisWrapper() {
    }

    @Override
    public Computation getComputationPlan(UnivariateRecipePayloadParams payloadParams) {
        ArrayList<Computation> computations = new ArrayList<Computation>();
        if (payloadParams.withSummaryStats) {
            computations.add(this.summaryStats.getComputationPlan(payloadParams));
        }
        if (this.column.isCategorical() && payloadParams.withFrequencyTable) {
            computations.add(this.frequencyTable.getComputationPlan(payloadParams));
        }
        if (this.column.isContinuous() && payloadParams.withQuantileTable) {
            computations.add(this.quantileTable.getComputationPlan(payloadParams));
        }
        return new MultiComputation(computations);
    }

    @Override
    public List<Row> extractRows(ComputationResult result, UnivariateRecipePayloadParams payloadParams, ColumnFactory cf, RowFactory rf) {
        ArrayList<Row> rows = new ArrayList<Row>();
        MultiComputation.MultiComputationResult mcr = result.asMulti();
        if (payloadParams.withConfidenceIntervals) {
            Row row = rf.row();
            row.put(cf.column("variable"), this.column.name);
            row.put(cf.column("origin"), "SETTINGS");
            row.put(cf.column("statistic_type"), "CONFIDENCE_LEVEL");
            row.put(cf.column("value"), payloadParams.confidenceLevel);
            rows.add(row);
        }
        int i = 0;
        if (payloadParams.withSummaryStats) {
            ComputationResult summaryStatsResult = mcr.get(i++);
            rows.addAll(this.summaryStats.extractRows(summaryStatsResult, payloadParams, cf, rf));
        }
        if (this.column.isCategorical() && payloadParams.withFrequencyTable) {
            ComputationResult frequencyTableResult = mcr.get(i);
            rows.addAll(this.frequencyTable.extractRows(frequencyTableResult, payloadParams, cf, rf));
        }
        if (this.column.isContinuous() && payloadParams.withQuantileTable) {
            ComputationResult quantileTableResult = mcr.get(i);
            rows.addAll(this.quantileTable.extractRows(quantileTableResult, payloadParams, cf, rf));
        }
        return rows;
    }

    @Override
    public void validate(UnivariateRecipePayloadParams payloadParams) {
        if (payloadParams.withSummaryStats) {
            if (!this.summaryStats.column.equals((Object)this.column)) {
                throw ErrorContext.iae((String)String.format("Summary stats variable (%s, %s) does not match parent analysis variable (%s, %s)", this.column.name, this.column.type.name(), this.summaryStats.column.name, this.summaryStats.column.type.name()));
            }
            this.summaryStats.validate(payloadParams);
        }
        if (payloadParams.withFrequencyTable) {
            if (!this.frequencyTable.column.equals((Object)this.column)) {
                throw ErrorContext.iae((String)String.format("Frequency table variable (%s, %s) does not match parent analysis variable (%s, %s)", this.column.name, this.column.type.name(), this.frequencyTable.column.name, this.frequencyTable.column.type.name()));
            }
            if (this.column.isCategorical()) {
                this.frequencyTable.validate(payloadParams);
            }
        }
        if (payloadParams.withQuantileTable) {
            if (!this.quantileTable.column.equals((Object)this.column)) {
                throw ErrorContext.iae((String)String.format("Quantile table variable (%s, %s) does not match parent analysis variable (%s, %s)", this.column.name, this.column.type.name(), this.quantileTable.column.name, this.quantileTable.column.type.name()));
            }
            if (this.column.isContinuous()) {
                this.quantileTable.validate(payloadParams);
            }
        }
    }
}

