/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.utils.GsonNullableJsonElementTypeAdapterFactory;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.gson.JsonObject;
import com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@RoutinelyUsedInExtensionCode
public class LLMCompletionSettings {
    public Double temperature;
    public Integer topK;
    public Double topP;
    public Integer maxOutputTokens;
    public List<String> stopSequences = new ArrayList<String>();
    public Double frequencyPenalty;
    public Double presencePenalty;
    public Map<Integer, Double> logitBias;
    public Boolean logProbs;
    public Integer topLogProbs;
    public ResponseFormat responseFormat;
    public LLMClient.ReasoningEffort reasoningEffort;
    public String customReasoningEffort;
    public LLMClient.ToolChoice toolChoice;
    public List<LLMClient.AbstractTool> tools;
    public Boolean outputTrajectory;

    public LLMClient.CompletionSettings toFullSettings() {
        LLMClient.CompletionSettings completionSettings = new LLMClient.CompletionSettings();
        completionSettings.temperature = this.temperature;
        completionSettings.topP = this.topP;
        completionSettings.topK = this.topK;
        completionSettings.maxOutputTokens = this.maxOutputTokens;
        completionSettings.stopSequences.addAll(this.stopSequences);
        completionSettings.frequencyPenalty = this.frequencyPenalty;
        completionSettings.presencePenalty = this.presencePenalty;
        completionSettings.logitBias = this.logitBias;
        completionSettings.logProbs = this.logProbs;
        completionSettings.topLogProbs = this.topLogProbs;
        if (this.responseFormat != null) {
            completionSettings.responseFormat = this.responseFormat.toFullResponseFormat();
        }
        completionSettings.toolChoice = this.toolChoice;
        completionSettings.tools = this.tools;
        completionSettings.reasoningEffort = this.reasoningEffort;
        completionSettings.customReasoningEffort = this.customReasoningEffort;
        return completionSettings;
    }

    public static LLMCompletionSettings defaultLLMEvalSettings() {
        LLMCompletionSettings settings = new LLMCompletionSettings();
        settings.temperature = 0.0;
        return settings;
    }

    @PolyJSON(value={@Mapping(type="text", value=ResponseFormatText.class), @Mapping(type="json", value=ResponseFormatJson.class)})
    public static abstract class ResponseFormat {
        public abstract LLMClient.ResponseFormat toFullResponseFormat();
    }

    public static class ResponseFormatJson
    extends ResponseFormat {
        @JsonAdapter(value=GsonNullableJsonElementTypeAdapterFactory.class)
        @Nullable
        public JsonObject schema;
        @Nullable
        public Boolean strict;
        @Nullable
        public Boolean compatible;

        @Override
        public LLMClient.ResponseFormat toFullResponseFormat() {
            LLMClient.ResponseFormatJson responseFormat = new LLMClient.ResponseFormatJson();
            responseFormat.schema = this.schema;
            responseFormat.strict = this.strict;
            responseFormat.compatible = this.compatible;
            return responseFormat;
        }
    }

    public static class ResponseFormatText
    extends ResponseFormat {
        @Override
        public LLMClient.ResponseFormat toFullResponseFormat() {
            return new LLMClient.ResponseFormatText();
        }
    }
}

