/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.nlp.common.LLMRecipePayloadParams;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class LLMRecipeMeta<P extends LLMRecipePayloadParams>
extends RecipeMeta {
    protected final Class<P> paramsClass;

    protected LLMRecipeMeta(Class<P> paramsClass) {
        this.paramsClass = paramsClass;
    }

    protected P loadPayload(String payload) {
        return (P)((LLMRecipePayloadParams)JSON.parse((String)payload, this.paramsClass));
    }

    @Override
    public Set<String> underlyingConnectionNames(SerializedRecipe serializedRecipe, String payload) {
        P params = this.loadPayload(payload);
        if (((LLMRecipePayloadParams)params).llmId == null) {
            return Collections.emptySet();
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(((LLMRecipePayloadParams)params).llmId);
        if (ref.connection == null || ref.connection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> ret = new HashSet<String>();
        ret.add(ref.connection);
        return ret;
    }

    @Override
    public RecipePayloadParams remapConnections(SerializedRecipe serializedRecipe, String payload, Map<String, String> replacements) {
        P params = this.loadPayload(payload);
        if (((LLMRecipePayloadParams)params).llmId == null) {
            return params;
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(((LLMRecipePayloadParams)params).llmId);
        if (ref.connection == null) {
            return params;
        }
        String newValue = replacements.get(ref.connection);
        if (newValue == null) {
            throw ErrorContext.iaef((String)"Did not find connection to remap in recipe: %s", (Object)ref.connection, (Object[])new Object[0]);
        }
        ref.setConnection(newValue);
        ((LLMRecipePayloadParams)params).llmId = ref.encodeToId();
        return params;
    }
}

