/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common.doc_extraction;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRecipesParams;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRule;
import com.dataiku.dip.recipes.nlp.extract_content.ExtractContentRecipePayloadParams;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class DocExtractionRecipesMetaBase
extends RecipeMeta {
    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public Set<String> underlyingConnectionNames(SerializedRecipe serializedRecipe, String payload) {
        HashSet<String> usedConnections = new HashSet<String>();
        DocExtractionRecipesParams params = serializedRecipe.getParamsAs(DocExtractionRecipesParams.class);
        String defaultVLLMId = params.getDefaultVLMSelection();
        DocExtractionRecipesMetaBase.addToUnderlyingConnections(defaultVLLMId, usedConnections);
        for (DocExtractionRule customRule : params.getAllCustomRules()) {
            if (customRule.actionToPerform != DocExtractionRule.ActionToPerform.VLM || customRule.vlmSettings == null) continue;
            DocExtractionRecipesMetaBase.addToUnderlyingConnections(customRule.vlmSettings.llmId, usedConnections);
        }
        return usedConnections;
    }

    private static void addToUnderlyingConnections(String llmId, Set<String> usedConnections) {
        if (StringUtils.isEmpty((String)llmId) || llmId.equals("DSS_NO_SELECTION")) {
            return;
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(llmId);
        if (!Strings.isNullOrEmpty((String)ref.connection)) {
            usedConnections.add(ref.connection);
        }
    }

    @Override
    public RecipePayloadParams remapConnections(SerializedRecipe serializedRecipe, String payload, Map<String, String> replacements) {
        ExtractContentRecipePayloadParams payloadParams = (ExtractContentRecipePayloadParams)JSON.parse((String)payload, ExtractContentRecipePayloadParams.class);
        DocExtractionRecipesParams params = serializedRecipe.getParamsAs(DocExtractionRecipesParams.class);
        String defaultVLLMId = params.getDefaultVLMSelection();
        DocExtractionRecipesMetaBase.getNewLLMId(serializedRecipe, replacements, defaultVLLMId).ifPresent(params::setDefaultVLMSelection);
        for (DocExtractionRule customRule : params.getAllCustomRules()) {
            if (customRule.actionToPerform != DocExtractionRule.ActionToPerform.VLM || customRule.vlmSettings == null) continue;
            DocExtractionRecipesMetaBase.getNewLLMId(serializedRecipe, replacements, customRule.vlmSettings.llmId).ifPresent(llmId -> {
                customRule.vlmSettings.llmId = llmId;
            });
        }
        return payloadParams;
    }

    private static Optional<String> getNewLLMId(SerializedRecipe serializedRecipe, Map<String, String> replacements, String llmId) {
        if (StringUtils.isEmpty((String)llmId)) {
            return Optional.empty();
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(llmId);
        if (!Strings.isNullOrEmpty((String)ref.connection) && replacements.containsKey(ref.connection)) {
            String newValue = replacements.get(ref.connection);
            if (newValue == null) {
                throw ErrorContext.iaef((String)"Did not find connection to remap in recipe %s : %s", (Object)serializedRecipe.name, (Object[])new Object[]{ref.connection});
            }
            ref.setConnection(newValue);
            return Optional.of(ref.encodeToId());
        }
        return Optional.empty();
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withNlp();
    }
}

