/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common.doc_extraction;

import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.recipes.nlp.common.EmbeddingRecipePayloadBaseParams;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionIndexer;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class IndexerComputationResult {
    long indexTime;
    private boolean isDone = false;
    Set<InputRefs.ManagedFolderDocumentRefWithMetadata> newDocs = new HashSet<InputRefs.ManagedFolderDocumentRefWithMetadata>();
    Set<InputRefs.ManagedFolderDocumentRefWithMetadata> knownDocs;
    Set<InputRefs.ManagedFolderDocumentRefWithMetadata> knownToReprocessDocs = new HashSet<InputRefs.ManagedFolderDocumentRefWithMetadata>();
    Set<InputRefs.ManagedFolderDocumentRefWithMetadata> knownToKeepDocs = new HashSet<InputRefs.ManagedFolderDocumentRefWithMetadata>();
    Set<InputRefs.ManagedFolderDocumentRefWithMetadata> knownRemovedOrModifiedDocs;
    EmbeddingRecipePayloadBaseParams.VectorStoreUpdateMethod updateMethod;
    public boolean shouldDeduplicate;

    public IndexerComputationResult(EmbeddingRecipePayloadBaseParams.VectorStoreUpdateMethod updateMethod, Set<InputRefs.ManagedFolderDocumentRefWithMetadata> knownDocs) {
        this.indexTime = System.currentTimeMillis();
        this.knownDocs = knownDocs;
        this.knownRemovedOrModifiedDocs = new HashSet<InputRefs.ManagedFolderDocumentRefWithMetadata>(knownDocs);
        this.shouldDeduplicate = updateMethod.isSmart;
        this.updateMethod = updateMethod;
    }

    public synchronized void markAsDone() {
        this.isDone = true;
    }

    public synchronized boolean isMarkedAsDone() {
        return this.isDone;
    }

    public void addIndexedDocument(DocExtractionIndexer.SingleDocumentIndexerResult documentIndexerResult, InputRefs.ManagedFolderDocumentRefWithMetadata inputDocument) {
        if (documentIndexerResult.equals((Object)DocExtractionIndexer.SingleDocumentIndexerResult.IS_NEW)) {
            this.newDocs.add(inputDocument);
        }
        if (documentIndexerResult.equals((Object)DocExtractionIndexer.SingleDocumentIndexerResult.IS_KNOWN_TO_REPROCESS)) {
            this.knownToReprocessDocs.add(inputDocument);
            this.knownRemovedOrModifiedDocs.remove(inputDocument);
        }
        if (documentIndexerResult.equals((Object)DocExtractionIndexer.SingleDocumentIndexerResult.IS_KNOWN_TO_KEEP)) {
            this.knownToKeepDocs.add(inputDocument);
            this.knownRemovedOrModifiedDocs.remove(inputDocument);
        }
    }

    public Set<InputRefs.ManagedFolderDocumentRefWithMetadata> getDocumentsToProcess() {
        if (!this.isMarkedAsDone()) {
            throw new IllegalStateException("Indexer is not done yet, wait until all documents have been indexed");
        }
        HashSet<InputRefs.ManagedFolderDocumentRefWithMetadata> documentsToProcess = new HashSet<InputRefs.ManagedFolderDocumentRefWithMetadata>();
        documentsToProcess.addAll(this.newDocs);
        documentsToProcess.addAll(this.knownToReprocessDocs);
        return documentsToProcess;
    }

    public int getNbKnownDocuments() {
        if (!this.isMarkedAsDone()) {
            throw new IllegalStateException("Indexer is not done yet, wait until all documents have been indexed");
        }
        return this.knownDocs.size();
    }

    public Set<InputRefs.ManagedFolderDocumentRefWithMetadata> getDocumentsToDelete() {
        if (!this.isMarkedAsDone()) {
            throw new IllegalStateException("Indexer is not done yet, wait until all documents have been indexed");
        }
        HashSet<InputRefs.ManagedFolderDocumentRefWithMetadata> documentsToDelete = new HashSet<InputRefs.ManagedFolderDocumentRefWithMetadata>();
        if (this.updateMethod.equals((Object)EmbeddingRecipePayloadBaseParams.VectorStoreUpdateMethod.OVERWRITE)) {
            documentsToDelete.addAll(this.knownDocs);
        } else if (this.updateMethod.equals((Object)EmbeddingRecipePayloadBaseParams.VectorStoreUpdateMethod.SMART_OVERWRITE)) {
            documentsToDelete.addAll(this.knownRemovedOrModifiedDocs);
        }
        if (this.updateMethod.isSmart) {
            documentsToDelete.addAll(this.knownToReprocessDocs);
            if (this.updateMethod.equals((Object)EmbeddingRecipePayloadBaseParams.VectorStoreUpdateMethod.SMART_APPEND)) {
                Set knownKeptPaths = this.knownToReprocessDocs.stream().map(doc -> doc.documentRef.filePath).collect(Collectors.toSet());
                knownKeptPaths.addAll(this.knownToKeepDocs.stream().map(doc -> doc.documentRef.filePath).collect(Collectors.toSet()));
                HashSet<InputRefs.ManagedFolderDocumentRefWithMetadata> removedOrModifiedDocs = new HashSet<InputRefs.ManagedFolderDocumentRefWithMetadata>(this.knownRemovedOrModifiedDocs);
                Set oldModifiedVersions = removedOrModifiedDocs.stream().filter(doc -> knownKeptPaths.contains(doc.documentRef.filePath)).collect(Collectors.toSet());
                documentsToDelete.addAll(oldModifiedVersions);
            }
        }
        return documentsToDelete;
    }
}

