/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.summarization;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.recipes.nlp.summarization.SummarizationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.summarization.SummarizationRecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class SummarizationRecipeCreator
extends SISORecipeCreator {
    public SummarizationRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        ManagedDatasetsHelper.copySchema(this.authCtx, this.getInputDataset(recipe).getSchema(), outputDataset);
        Schema schema = outputDataset.getSchema();
        for (SummarizationRecipeSchemaComputer.SummarizationRecipeColumn column : SummarizationRecipeSchemaComputer.SummarizationRecipeColumn.values()) {
            schema.withColumn(column.name, column.type);
        }
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data, Dataset outputDataset) throws Exception {
        return this.makeInitialPayload(data);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        return this.makeInitialPayload(data);
    }

    private String makeInitialPayload(JsonObject data) {
        JsonElement initialPayload = data.get("initialPayload");
        if (initialPayload != null) {
            return JSON.pretty((Object)initialPayload);
        }
        return JSON.pretty((Object)new SummarizationRecipePayloadParams());
    }
}

