/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.summarization;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.nlp.summarization.SummarizationRecipePayloadParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SummarizationRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    private SummarizationRecipePayloadParams desc;

    public SummarizationRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (SummarizationRecipePayloadParams)JSON.parse((String)payload, SummarizationRecipePayloadParams.class);
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
        Schema schema = new Schema();
        if (!this.recipe.getInputsUnsafe().get((Object)role).items.isEmpty()) {
            schema = this.getInputSchemaCopy();
        }
        for (SummarizationRecipeColumn column : SummarizationRecipeColumn.values()) {
            schema.withColumn(column.name, column.type);
        }
        return Collections.singletonList(schema);
    }

    private Schema getInputSchemaCopy() throws Exception {
        Dataset inputDataset;
        try (Transaction t = this.transactionService.beginRead();){
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            AnyLoc inputDatasetLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.getProjectKey());
            inputDataset = this.datasetAccessService.getMandatoryUnsafe(inputDatasetLoc);
        }
        return inputDataset.getSchema().getCopy();
    }

    public static enum SummarizationRecipeColumn {
        SUMMARIZED_TEXT("summary", Type.STRING),
        LLM_ERROR_MSG("llm_error_message", Type.STRING);

        final String name;
        final Type type;

        private SummarizationRecipeColumn(String name, Type type) {
            this.name = name;
            this.type = type;
        }
    }
}

