/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.services;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PDepsFixuper {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.partitioning.fixup");

    public PDepsFixuper() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    private boolean neverNeedsOutput(SerializedRecipe.SDep pdep) {
        return Lists.newArrayList((Object[])new String[]{"values", "all_available", "latest_available", "custom_python"}).contains(pdep.func);
    }

    private boolean mayWorkWithoutOutput(SerializedRecipe.SDep pdep) {
        return pdep.func.equals("time_range");
    }

    public boolean fixupInPlace(SerializedRecipe recipe) throws IOException {
        SerializedRecipe stateBefore = (SerializedRecipe)JSON.deepCopy((Object)recipe);
        logger.info((Object)("Pdep fixup start, inputs=" + JSON.log(recipe.getInputsUnsafe()) + "outputs=" + JSON.log(recipe.getOutputsUnsafe())));
        ArrayList<ODim> outputDimensions = new ArrayList<ODim>();
        for (SerializedRecipe.RecipeOutput output : recipe.getFlatOutputs()) {
            SavedModel sm;
            ManagedFolder mf;
            AnyLoc loc = AnyLoc.resolveSmart(recipe.projectKey, output.ref);
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNull(loc);
            if (sd != null && sd.isPartitioned()) {
                for (Object dimName : sd.partitioning.getDimensionNames()) {
                    Dimension dim = sd.partitioning.getDimension((String)dimName);
                    outputDimensions.add(new ODim(output.ref, dim.getName()));
                }
            }
            if ((mf = (ManagedFolder)this.managedFolderDAO.getOrNull(loc)) != null && mf.isPartitioned()) {
                Object dimName;
                dimName = mf.partitioning.getDimensionNames().iterator();
                while (dimName.hasNext()) {
                    Iterator dimName2 = (String)dimName.next();
                    Dimension dimension = mf.partitioning.getDimension(dimName2);
                    outputDimensions.add(new ODim(output.ref, dimension.getName()));
                }
            }
            if ((sm = (SavedModel)this.savedModelDAO.getOrNull(loc)) == null || !sm.isPartitioned()) continue;
            for (String string : sm.partitioning.getDimensionNames()) {
                Dimension dim = sm.partitioning.getDimension(string);
                outputDimensions.add(new ODim(output.ref, dim.getName()));
            }
        }
        logger.info((Object)("odims: " + JSON.log(outputDimensions)));
        if (outputDimensions.isEmpty()) {
            recipe.redispatchPartitioning = false;
        }
        for (SerializedRecipe.RecipeInput input : recipe.getFlatInputs()) {
            ArrayList<SerializedRecipe.SDep> newDeps = new ArrayList<SerializedRecipe.SDep>();
            for (SerializedRecipe.SDep dep : input.deps) {
                if (this.neverNeedsOutput(dep)) {
                    dep.odim = null;
                    dep.out = null;
                    newDeps.add(dep);
                    continue;
                }
                boolean found = false;
                for (ODim oDim : outputDimensions) {
                    if (!oDim.odim.equals(dep.odim) || !oDim.out.equals(dep.out)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    newDeps.add(dep);
                    continue;
                }
                logger.info((Object)("No matching output found for dep: " + JSON.log((Object)dep)));
                if (this.mayWorkWithoutOutput(dep)) {
                    logger.info((Object)"But it can be without output so keep it");
                    newDeps.add(dep);
                    continue;
                }
                logger.info((Object)"Better remove it");
            }
            input.deps = newDeps;
        }
        logger.info((Object)("After removal-of-bad-outputs phase: " + JSON.log(recipe.getInputsUnsafe())));
        for (SerializedRecipe.RecipeInput input : recipe.getFlatInputs()) {
            PartitioningScheme partitioningSchema = this.getPartitioningScheme(recipe.projectKey, input.ref);
            if (partitioningSchema == null) {
                input.deps.clear();
                continue;
            }
            ListIterator<SerializedRecipe.SDep> it = input.deps.listIterator();
            while (it.hasNext()) {
                SerializedRecipe.SDep dep;
                dep = it.next();
                if (dep.idim == null || partitioningSchema.getDimension(dep.idim) != null) continue;
                logger.infoV("Removing dead pdep on input=%s dim=%s", new Object[]{input.getLoc(recipe.projectKey).getFullName(), dep.idim});
                it.remove();
            }
        }
        logger.info((Object)("After removal-of-bad-inputs phase: " + JSON.log(recipe.getInputsUnsafe())));
        for (SerializedRecipe.RecipeInput input : recipe.getFlatInputs()) {
            PartitioningScheme inputPartitioning = this.getPartitioningScheme(recipe.projectKey, input.ref);
            if (inputPartitioning == null) continue;
            for (String dimName : inputPartitioning.getDimensionNames()) {
                Dimension dim = inputPartitioning.getDimension(dimName);
                logger.info((Object)("Checking if we have a pdep setting " + dim.getName() + " of " + input.getLoc(recipe.projectKey).getFullName()));
                boolean found = false;
                for (SerializedRecipe.SDep dep : input.deps) {
                    if (dep.idim == null || !dep.idim.equals(dim.getName())) continue;
                    logger.info((Object)"OK found it");
                    found = true;
                    break;
                }
                if (found) continue;
                logger.info((Object)("Not found, will add pdep to set " + dim.getName() + " of " + input.getLoc(recipe.projectKey).getFullName()));
                SerializedRecipe.SDep sDep = new SerializedRecipe.SDep();
                if (recipe.getFlatOutputs().size() > 0) {
                    SerializedRecipe.RecipeOutput firstOutput = recipe.getFlatOutputs().get(0);
                    PartitioningScheme outputPartitioning = this.getPartitioningScheme(recipe.projectKey, firstOutput.ref);
                    if (outputPartitioning != null) {
                        for (String odimName : outputPartitioning.getDimensionNames()) {
                            Dimension odim = outputPartitioning.getDimension(odimName);
                            if (!odim.getName().equals(dim.getName())) continue;
                            logger.info((Object)("Adding equals to " + firstOutput.ref + " / " + dim.getName()));
                            sDep.func = "equals";
                            sDep.idim = dim.getName();
                            sDep.out = firstOutput.ref;
                            sDep.odim = dim.getName();
                        }
                    }
                }
                if (sDep.func == null) {
                    logger.info((Object)"No odim with same name found, adding all_available");
                    sDep.idim = dim.getName();
                    sDep.func = "all_available";
                }
                input.deps.add(sDep);
            }
        }
        return !JSON.jsonEquals((Object)stateBefore, (Object)recipe);
    }

    @Nullable
    private PartitioningScheme getPartitioningScheme(String projectKey, String name) throws IOException {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, name);
        SerializedDataset serializedDataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(loc);
        if (serializedDataset != null && serializedDataset.isPartitioned()) {
            return serializedDataset.partitioning;
        }
        ManagedFolder managedFolder = (ManagedFolder)this.managedFolderDAO.getOrNullUnsafe(loc);
        if (managedFolder != null && managedFolder.isPartitioned()) {
            return managedFolder.partitioning;
        }
        SavedModel savedModel = (SavedModel)this.savedModelDAO.getOrNullUnsafe(loc);
        if (savedModel != null && savedModel.isPartitioned()) {
            return savedModel.partitioning;
        }
        return null;
    }

    public void handleRecipeCopy(SerializedRecipe recipe, SerializedRecipe copy) {
        HashMap copyOutputs = Maps.newHashMap();
        for (SerializedRecipe.RecipeOutput recipeOutput : copy.getFlatOutputs()) {
            copyOutputs.put(recipeOutput.ref, recipeOutput);
        }
        for (SerializedRecipe.RecipeInput recipeInput : copy.getFlatInputs()) {
            for (SerializedRecipe.SDep dep : recipeInput.deps) {
                if (this.neverNeedsOutput(dep) || !StringUtils.isNotBlank((String)dep.out) || copyOutputs.containsKey(dep.out)) continue;
                String oldRole = null;
                int indexInOldRole = 0;
                for (Map.Entry<String, SerializedRecipe.OutputRole> outputRole : recipe.getOutputsUnsafe().entrySet()) {
                    for (int i = 0; i < outputRole.getValue().items.size(); ++i) {
                        SerializedRecipe.RecipeOutput recipeOutput = outputRole.getValue().items.get(i);
                        if (!recipeOutput.ref.equals(dep.out)) continue;
                        oldRole = outputRole.getKey();
                        indexInOldRole = i;
                    }
                }
                if (oldRole != null) {
                    List<SerializedRecipe.RecipeOutput> recipeOutputs = copy.getOutputsForRole(oldRole);
                    if (recipeOutputs != null && !recipeOutputs.isEmpty()) {
                        SerializedRecipe.RecipeOutput newOutput = indexInOldRole < recipeOutputs.size() ? recipeOutputs.get(indexInOldRole) : recipeOutputs.get(0);
                        logger.info((Object)("Translate partition dependency on " + dep.out + ", to " + newOutput.ref));
                        dep.out = newOutput.ref;
                        continue;
                    }
                    logger.warn((Object)("Could not translate partition dependency on " + dep.out + ", because could not locate output role " + oldRole + " in new recipe or it's empty"));
                    continue;
                }
                logger.warn((Object)("Could not translate partition dependency on " + dep.out + ", because could not locate output ref in original recipe"));
            }
        }
    }

    static class ODim {
        String out;
        String odim;

        ODim(String out, String odim) {
            this.out = out;
            this.odim = odim;
        }
    }
}

