/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.ProcessorWithResolvedParams;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.ProcessorWithSubProcess;
import com.dataiku.dip.SingleCopyAdditionalInputsLoader;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.cde.ContainerizedStreamEngineExecutor;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.exec.PeriodicObserver;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.WithAdditionalRunnables;
import com.dataiku.dip.dataflow.exec.WithFactories;
import com.dataiku.dip.dataflow.exec.WithPullInputs;
import com.dataiku.dip.dataflow.exec.WithPushOutputs;
import com.dataiku.dip.dataflow.exec.stream.ParallelStreamControlRunnable;
import com.dataiku.dip.dataflow.exec.stream.ParallelStreamSlaveRunnable;
import com.dataiku.dip.dataflow.exec.stream.PartitionMappingStreamer;
import com.dataiku.dip.dataflow.exec.stream.RowStreamSplitRunnable;
import com.dataiku.dip.dataflow.exec.stream.SingleThreadFSLikeDatasetRunnable;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.exec.stream.UnsplittedDatasetRunnable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.utils.GraphUtils;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.ProcessorWithFactories;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.SRPAdapter;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.SingleOutputRowProcessor;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.stream.ParallelStreamer;
import com.dataiku.dip.input.stream.StreamOrientedDatasetHandler;
import com.dataiku.dip.input.stream.UnsplittedStreamDatasetHandler;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.shaker.AdditionalInputsHelper;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.server.AdditionalInputAccessor;
import com.dataiku.dip.shaker.server.StreamedAdditionalInputAccessor;
import com.dataiku.dip.shaker.streamimpl.StreamPipelineFactory;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ShakerRecipeRunner
implements WithAdditionalRunnables,
RecipeRunner,
PeriodicObserver,
RecipeRunnerWithPayload,
ContainerizedDSSEngineAble {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private FlowRecipe recipe;
    private JobActivity activity;
    private RecipeRunnableSubgraph subgraph;
    private SerializedShakerScript rawShakerScript;
    private SerializedShakerScript expandedView;
    private SerializedJobActivityStatus.SerializedTargetDS targetStatus;
    private AdditionalInputAccessor additionalInputsAccessor;
    private List<SingleCopyAdditionalInputsLoader> additionalInputLoaders = new ArrayList<SingleCopyAdditionalInputsLoader>();
    private List<FlowRunnable> runnables = new ArrayList<FlowRunnable>();
    private SerializedJobActivityStatus.SerializedSourceDS mainSourceStatus;
    private List<InputSplitProgressListener> streamListeners = new ArrayList<InputSplitProgressListener>();
    private List<InputSplitProgressListener> otherListeners = new ArrayList<InputSplitProgressListener>();
    private List<ToDatasetStreamer> writers = new ArrayList<ToDatasetStreamer>();
    private ShakerRecipeParams params;
    private DatasetHandler datasetHandler;
    private boolean isRunningInContainer;
    private String payload;
    private static final DKULogger logger;

    public ShakerRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        activity.initStatus();
    }

    @Override
    public void setPayload(String payload) {
        logger.info((Object)("SET PAYLOAD " + payload));
        this.payload = payload;
        this.rawShakerScript = (SerializedShakerScript)JSON.parse((String)payload, SerializedShakerScript.class);
        assert (this.rawShakerScript != null);
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void init() throws Exception {
        SerializedRecipe.SerializedRecipeAndPayload srp = new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        if (srp != null && srp.payload != null) {
            this.setPayload(srp.payload);
        }
        this.expandedView = this.rawShakerScript.expandedDeepCopy(this.variablesService.getForProject(this.recipe.getProjectKey()));
        ShakerUtils.warnDeprecatedPythonVersion(this.activity.warnContext, this.recipe.getProjectKey(), this.expandedView.steps);
        FlowDataset mainFlowDataset = this.subgraph.getSingleSourceDatasetForRole("main");
        Dataset mainDataset = mainFlowDataset.getMandatory(this.datasetsDAO);
        FlowDataset outputFDS = GraphUtils.getSingleTarget(this.subgraph.getRecipe());
        Dataset outputDataset = outputFDS.getMandatory(this.datasetsDAO);
        SerializedRecipe.RecipeOutput recipeOutput = this.subgraph.getRecipe().getModel().getSingleOutput("main");
        this.params = RecipeRegistry.getParamsAs(this.activity, ShakerRecipeParams.class);
        this.datasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), mainDataset);
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), this.payload);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            ContainerizedStreamEngineExecutor runnable = new ContainerizedStreamEngineExecutor(this.recipe, this.activity, containerConfig);
            this.runnables.add(runnable);
        } else {
            logger.info((Object)"Run locally");
            logger.info((Object)("Shaker recipe, from " + mainDataset.getName() + " of type " + mainDataset.getType()));
            this.activity.fillSourceTotalSizes(this.datasetsDAO);
            this.targetStatus = this.activity.getTargetStatus(outputFDS.getFullName());
            Output.WriteMode writeMode = recipeOutput.getWriteMode();
            try (DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), outputDataset);){
                if (this.activity.getSubgraph().isAllTargetPartitions()) {
                    if (writeMode == Output.WriteMode.OVERWRITE) {
                        outputDatasetHandler.clearAllData();
                    }
                } else if (writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                    if (outputDatasetHandler.getMeta().handlesClearForOverwriteMode()) {
                        outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{this.activity.getSubgraph().getTargetPartition(outputFDS)}));
                    }
                    writeMode = Output.WriteMode.APPEND;
                }
            }
            this.additionalInputsAccessor = new StreamedAdditionalInputAccessor(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), this.datasetsDAO);
            this.additionalInputLoaders = AdditionalInputsHelper.getLoadersForAllProcessors(this.additionalInputsAccessor, this.expandedView.steps, null);
            StreamRowFactory rf = new StreamRowFactory();
            StreamColumnFactory cf = new StreamColumnFactory();
            if (this.activity.getSubgraph().isAllTargetPartitions()) {
                logger.info((Object)"Doing a ALL-PARTITIONS prepare");
                this.mainSourceStatus = this.activity.getSourceStatus(mainDataset.getFullName());
                SplitRunner runner = new SplitRunner();
                UnsplittedDatasetRunnable runnable = new UnsplittedDatasetRunnable(this.authCtxService.getAuthCtx(), mainDataset, this.activity.warnContext);
                PartitionMappingStreamer streamer = new PartitionMappingStreamer(this.authCtxService.getAuthCtx(), outputDataset, (ColumnFactory)cf, this.activity.warnContext);
                this.otherListeners.add(runnable.listener);
                SingleInputRowProcessor sirp = runner.getInputHandler("main");
                runnable.setOutput("main", (ProcessorOutput)new ProcessorOutputToSIP(sirp));
                ProcessorOutput outputHandler = streamer.getAsOutput();
                runner.setOutput("main", outputHandler);
                runnable.setFactories((ColumnFactory)cf, (RowFactory)rf);
                runner.init();
                this.runnables.add(runnable);
            } else if (this.datasetHandler instanceof StreamOrientedDatasetHandler) {
                this.mainSourceStatus = this.activity.getSourceStatus(mainDataset.getFullName());
                this.mainSourceStatus.statsType = SerializedJobActivityStatus.SourceStatsType.FILES_WITH_GLOBAL_PROGRESS;
                StreamableDatasetSelection selection = StreamableDatasetSelection.full();
                selection.withSelectedPartitions(this.subgraph.getSourcePartitions(mainFlowDataset));
                try (DatasetHandler outputDSHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), outputDataset);){
                    boolean inputIsRepeatingFS = this.datasetHandler.getMeta().isFS() && this.datasetHandler.getDataset().getParams() instanceof AbstractFSDatasetHandler.AbstractFSConfig && this.datasetHandler.getDataset().getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).variablesExpansionLoopConfig.isEnabled();
                    logger.info((Object)("Input is repeatingFS: " + inputIsRepeatingFS));
                    if (this.datasetHandler.getMeta().isFS() && !inputIsRepeatingFS && outputDSHandler.isParallelWritable() && this.datasetHandler.isParallelReadable() && (!this.datasetHandler.getMeta().supportsOrderPreservation() || !mainDataset.getModel().readWriteOptions.preserveOrder)) {
                        InputFilter ifilter = new InputFilter();
                        ifilter.withSelectedPartitions(this.subgraph.getSourcePartitions(mainFlowDataset));
                        AbstractFSDatasetHandler fdh = (AbstractFSDatasetHandler)this.datasetHandler;
                        FilePartitioner.ResolvedFilesFilterResult partitionResult = fdh.getRequiredFiles(ifilter);
                        if (partitionResult.getAllPaths().size() == 0) {
                            logger.warn((Object)"No file to process, bailing out");
                            DatasetUtils.performWriteOfZeroRows(outputDSHandler, this.subgraph.getTargetPartition(outputFDS), this.activity.warnContext, writeMode);
                        }
                        logger.info((Object)"Using parallel runner");
                        int maxThreads = partitionResult.getAllPaths().size();
                        if (this.params.engineParams.maxThreads > 0 && this.params.engineParams.maxThreads < maxThreads) {
                            maxThreads = this.params.engineParams.maxThreads;
                        }
                        ParallelStreamer ps2 = new ParallelStreamer(fdh, partitionResult.matchingFilePartitions, maxThreads);
                        ParallelStreamControlRunnable control = new ParallelStreamControlRunnable(ps2);
                        for (int i = 0; i < maxThreads; ++i) {
                            SplitRunner runner = new SplitRunner();
                            ParallelStreamSlaveRunnable pssr = new ParallelStreamSlaveRunnable(this.authCtxService.getAuthCtx(), mainDataset, ps2.getRunner(i), this.activity.warnContext);
                            this.streamListeners.add(pssr.listener);
                            ToDatasetStreamer toSplit = ToDatasetStreamer.newToSpecificSplit(this.authCtxService.getAuthCtx(), outputDataset, this.subgraph.getTargetPartition(outputFDS), i, (ColumnFactory)cf, this.activity.warnContext, writeMode);
                            this.writers.add(toSplit);
                            SingleInputRowProcessor sirp = runner.getInputHandler("main");
                            pssr.setOutput("main", (ProcessorOutput)new ProcessorOutputToSIP(sirp));
                            ProcessorOutput outputHandler = toSplit.getAsOutput();
                            runner.setOutput("main", outputHandler);
                            pssr.setFactories((ColumnFactory)cf, (RowFactory)rf);
                            runner.init();
                            this.runnables.add(pssr);
                        }
                        this.runnables.add(control);
                    }
                    SplitRunner runner = new SplitRunner();
                    SingleThreadFSLikeDatasetRunnable runnable = new SingleThreadFSLikeDatasetRunnable(this.authCtxService.getAuthCtx(), mainDataset, selection, this.activity.warnContext);
                    ToDatasetStreamer toSplit = ToDatasetStreamer.newWithAutoBucketing(this.authCtxService.getAuthCtx(), outputDataset, this.subgraph.getTargetPartition(outputFDS), (ColumnFactory)cf, this.activity.warnContext, writeMode);
                    this.streamListeners.add(runnable.listener);
                    this.writers.add(toSplit);
                    SingleInputRowProcessor sirp = runner.getInputHandler("main");
                    runnable.setOutput("main", (ProcessorOutput)new ProcessorOutputToSIP(sirp));
                    ProcessorOutput outputHandler = toSplit.getAsOutput();
                    runner.setOutput("main", outputHandler);
                    runnable.setFactories((ColumnFactory)cf, (RowFactory)rf);
                    runner.init();
                    this.runnables.add(runnable);
                }
            } else if (this.datasetHandler instanceof UnsplittedStreamDatasetHandler) {
                SplitRunner runner = new SplitRunner();
                UnsplittedDatasetRunnable runnable = new UnsplittedDatasetRunnable(this.authCtxService.getAuthCtx(), mainDataset, this.activity.warnContext);
                ToDatasetStreamer toSplit = ToDatasetStreamer.newWithAutoBucketing(this.authCtxService.getAuthCtx(), outputDataset, this.subgraph.getTargetPartition(outputFDS), (ColumnFactory)cf, this.activity.warnContext, writeMode);
                this.otherListeners.add(runnable.listener);
                this.writers.add(toSplit);
                SingleInputRowProcessor sirp = runner.getInputHandler("main");
                runnable.setOutput("main", (ProcessorOutput)new ProcessorOutputToSIP(sirp));
                ProcessorOutput outputHandler = toSplit.getAsOutput();
                runner.setOutput("main", outputHandler);
                runnable.setFactories((ColumnFactory)cf, (RowFactory)rf);
                runner.init();
                this.runnables.add(runnable);
            } else if (this.datasetHandler instanceof RowOrientedDatasetHandler) {
                SplitRunner runner = new SplitRunner();
                this.mainSourceStatus = this.activity.getSourceStatus(mainDataset.getFullName());
                RowOrientedDatasetHandler rdh = (RowOrientedDatasetHandler)this.datasetHandler;
                InputFilter filter = new InputFilter().withSelectedPartitions(this.subgraph.getSourcePartitions(mainFlowDataset));
                RowStreamSplitRunnable rssr = new RowStreamSplitRunnable(rdh, filter, this.activity.warnContext);
                this.otherListeners.add(rssr.listener);
                ToDatasetStreamer toSplit = ToDatasetStreamer.newWithAutoBucketing(this.authCtxService.getAuthCtx(), outputDataset, this.subgraph.getTargetPartition(outputFDS), (ColumnFactory)cf, this.activity.warnContext, writeMode);
                this.writers.add(toSplit);
                SingleInputRowProcessor sirp = runner.getInputHandler("main");
                rssr.setOutput("main", (ProcessorOutput)new ProcessorOutputToSIP(sirp));
                ProcessorOutput outputHandler = toSplit.getAsOutput();
                runner.setOutput("main", outputHandler);
                rssr.setFactories((ColumnFactory)cf, (RowFactory)rf);
                runner.init();
                this.runnables.add(rssr);
            }
        }
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        logger.info((Object)("Shaker recipe generated, " + this.runnables.size() + " runnables"));
        return this.runnables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterval() throws IOException {
        JobActivity jobActivity = this.activity;
        synchronized (jobActivity) {
            if (this.mainSourceStatus != null) {
                InputSplitProgressListener inputSplitProgressListener;
                InputSplitProgressListener listener;
                this.mainSourceStatus.totalReadBytes = 0L;
                this.mainSourceStatus.totalReadRecords = 0L;
                Iterator<Object> iterator = this.streamListeners.iterator();
                while (iterator.hasNext()) {
                    inputSplitProgressListener = listener = iterator.next();
                    synchronized (inputSplitProgressListener) {
                        this.mainSourceStatus.totalReadBytes += listener.getCompressedBytes();
                        this.mainSourceStatus.totalReadRecords += listener.getReadRecords();
                    }
                }
                iterator = this.otherListeners.iterator();
                while (iterator.hasNext()) {
                    inputSplitProgressListener = listener = (InputSplitProgressListener)iterator.next();
                    synchronized (inputSplitProgressListener) {
                        this.mainSourceStatus.totalReadRecords += listener.getReadRecords();
                    }
                }
            }
            if (this.targetStatus != null) {
                this.targetStatus.partition.writtenBytes = 0L;
                this.targetStatus.partition.writtenRecords = 0L;
                for (ToDatasetStreamer writer : this.writers) {
                    this.targetStatus.partition.writtenBytes += writer.getWrittenBytes();
                    this.targetStatus.partition.writtenRecords += writer.writtenRows;
                }
            }
        }
    }

    @Override
    public void onEnd(boolean isSuccess) throws IOException {
        this.onInterval();
        if (this.datasetHandler != null) {
            try {
                this.datasetHandler.close();
            }
            finally {
                this.datasetHandler = null;
            }
        }
    }

    static {
        ScriptStep.loadClass();
        logger = DKULogger.getLogger((String)"dku.flow.shaker");
    }

    class SplitRunner
    implements WithPullInputs,
    WithPushOutputs,
    Initializable {
        ColumnFactory cf;
        RowFactory rf;
        private StreamPipelineFactory.StreamPipeline streamPipeline;
        private SingleInputRowProcessor headProcessor;
        private ProcessorOutput out;

        SplitRunner() {
        }

        @Override
        public void init() throws Exception {
            this.streamPipeline = StreamPipelineFactory.build(ShakerRecipeRunner.this.expandedView.steps, BaseProcessorsFactory.PipelineContext.sharedPipelineContext(), true);
            this.headProcessor = (SingleInputRowProcessor)this.streamPipeline.allProcessors.get(0);
            Object last = this.streamPipeline.allProcessors.get(this.streamPipeline.allProcessors.size() - 1);
            if (!(last instanceof SingleOutputRowProcessor)) {
                throw ErrorContext.iae((String)"Could not plug output, no end of pipe");
            }
            ((SingleOutputRowProcessor)last).setProcessorOutput(this.out);
            for (Object o : this.streamPipeline.allProcessors) {
                Object rproc;
                if (o instanceof ProcessorWithResourceFiles) {
                    rproc = (ProcessorWithResourceFiles)o;
                    rproc.setRequiredFiles(rproc.gatherRequirements());
                }
                if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithResourceFiles) {
                    rproc = (ProcessorWithResourceFiles)((SRPAdapter)o).getProcessor();
                    rproc.setRequiredFiles(rproc.gatherRequirements());
                }
                if (o instanceof ProcessorWithResolvedParams) {
                    rproc = (ProcessorWithResolvedParams)o;
                    rproc.resolve(ShakerRecipeRunner.this.authCtxService.getAuthCtx(), ShakerRecipeRunner.this.recipe.getProjectKey());
                }
                if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithResolvedParams) {
                    rproc = (ProcessorWithResolvedParams)((SRPAdapter)o).getProcessor();
                    rproc.resolve(ShakerRecipeRunner.this.authCtxService.getAuthCtx(), ShakerRecipeRunner.this.recipe.getProjectKey());
                }
                if (o instanceof ProcessorWithSubProcess) {
                    rproc = (ProcessorWithSubProcess)o;
                    rproc.spawn(ShakerRecipeRunner.this.authCtxService.getAuthCtx(), ShakerRecipeRunner.this.recipe.getProjectKey(), true, null);
                }
                if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithSubProcess) {
                    rproc = (ProcessorWithSubProcess)((SRPAdapter)o).getProcessor();
                    rproc.spawn(ShakerRecipeRunner.this.authCtxService.getAuthCtx(), ShakerRecipeRunner.this.recipe.getProjectKey(), true, null);
                }
                if (o instanceof SingleInputSingleOutputRowProcessor) {
                    ((SingleInputSingleOutputRowProcessor)o).setFactories(this.cf, this.rf);
                    ((SingleInputSingleOutputRowProcessor)o).setWarningsContext(ShakerRecipeRunner.this.activity.warnContext);
                    ((SingleInputSingleOutputRowProcessor)o).init();
                    continue;
                }
                if (!(o instanceof ProcessorWithFactories)) continue;
                ((ProcessorWithFactories)o).setFactories(this.cf, this.rf);
            }
            AdditionalInputsHelper.setAdditionalInputsOnProcessors(ShakerRecipeRunner.this.additionalInputsAccessor, ShakerRecipeRunner.this.additionalInputLoaders, this.streamPipeline.allProcessors);
        }

        public SingleInputRowProcessor getInputHandler(String name) {
            return new MainInputHandler();
        }

        @Override
        public void setInputStream(String name, RowInputStream stream) {
        }

        @Override
        public void setOutput(String name, ProcessorOutput out) {
            this.out = out;
        }

        class MainInputHandler
        implements SingleInputRowProcessor,
        WithFactories {
            MainInputHandler() {
            }

            public void processRow(Row row) throws Exception {
                SplitRunner.this.headProcessor.processRow(row);
            }

            public void postProcess() throws Exception {
                SplitRunner.this.headProcessor.postProcess();
            }

            @Override
            public void setFactories(ColumnFactory cf, RowFactory rf) {
                SplitRunner.this.cf = cf;
                SplitRunner.this.rf = rf;
                assert (SplitRunner.this.out != null);
                if (SplitRunner.this.out instanceof ProcessorOutputToSIP) {
                    SingleInputRowProcessor singleInputRowProcessor = ((ProcessorOutputToSIP)SplitRunner.this.out).getTarget();
                }
            }

            public void cancel() throws Exception {
                SplitRunner.this.headProcessor.cancel();
            }
        }
    }
}

