/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.recipes.shaker.ShakerSparkRecipeDefBuilder;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.shaker.sparkimpl.ShakerSparkRecipeDef;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.util.List;

public class ShakerSparkRecipeRunner
extends AbstractSparkBasedRecipeRunner {
    private final ShakerRecipeParams recipeParams;
    private final JobActivity activity;
    private final ResourcesGatherer gatherer = new ResourcesGatherer();
    private ShakerSparkRecipeDef recipeDef;

    public ShakerSparkRecipeRunner(JobActivity activity, ShakerRecipeParams recipeParams) {
        super(activity);
        this.activity = activity;
        this.recipeParams = recipeParams;
    }

    @Override
    public void init() throws Exception {
        SpringUtils.getInstance().autowire((Object)this.gatherer);
        new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        ShakerSparkRecipeDefBuilder builder = new ShakerSparkRecipeDefBuilder(this.activity, this.gatherer);
        this.activity.initStatus();
        this.recipeDef = builder.build();
        this.gatherer.computeMapping();
        this.recipeDef.resourceMapping = this.gatherer.getResourceMapping();
        ShakerUtils.warnDeprecatedPythonVersion(this.activity.warnContext, this.projectKey, this.recipeDef.expandedSteps);
    }

    @Override
    public void run() throws Exception {
        this.runSpark("Spark", this.recipeParams.engineParams.spark.executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                File serializedFile = new File(runDir, "spark-shaker-desc.json");
                JSON.prettyToFile((Object)ShakerSparkRecipeRunner.this.recipeDef, (File)serializedFile);
                T job = helper.makeClassJobWithNonSecretGlobalFiles("DSS (VPrep): " + ShakerSparkRecipeRunner.this.activity.id(), effectiveConf, ShakerSparkRecipeRunner.this.gatherer.getResourceFiles(), false, "com.dataiku.dip.shaker.sparkimpl.ShakerSparkEntryPoint", serializedFile.getAbsolutePath());
                ((SparkJob)job).secretDriverFiles.add(serializedFile.getAbsolutePath());
                return job;
            }

            @Override
            public SparkOverrideConfig getRecipeOverrideConf() {
                return ShakerSparkRecipeRunner.this.recipeParams.engineParams.spark.sparkConfig;
            }
        }, null);
    }

    static {
        ScriptStep.loadClass();
    }
}

