/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.ksql;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRESTClient;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRecipePreprocessor;
import com.dataiku.dip.recipes.streaming.ksql.KsqlSynchronizer;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class KsqlContinuousRecipeRunner
implements FlowRunnable,
Initializable,
AbortableRecipeRunner {
    @Autowired
    private JobAuthCtxService authCtxService;
    private final ContinuousActivity activity;
    private KsqlRecipePreprocessor preprocessor;
    private List<String> queryIds = Lists.newArrayList();
    private KafkaConnection.KsqlConnectionParams ksqlConnectionParams;
    private SerializedRecipe sr;
    private static Logger logger = Logger.getLogger((String)"dip.flow.ksql");

    public KsqlContinuousRecipeRunner(ContinuousActivity activity, SerializedRecipe sr) {
        this.activity = activity;
        this.sr = sr;
    }

    public synchronized void addQueryId(String queryId) {
        this.queryIds.add(queryId);
    }

    public synchronized List<String> getQueryIds() {
        return Lists.newArrayList(this.queryIds);
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void run() throws Exception {
        block40: {
            KsqlContinuousRecipeState recipeState = new KsqlContinuousRecipeState();
            File recipeStateFile = ApplicationConfigurator.getFile((String[])new String[]{"streaming-logs", this.activity.projectKey, this.activity.recipeId, "state.json"});
            if (recipeStateFile.exists() && recipeStateFile.isFile()) {
                try {
                    recipeState = (KsqlContinuousRecipeState)JSON.parseFile((File)recipeStateFile, KsqlContinuousRecipeState.class);
                }
                catch (Exception e) {
                    logger.warn((Object)"Incorrect previous state, assuming none", (Throwable)e);
                }
            }
            this.preprocessor = new KsqlRecipePreprocessor(this.authCtxService.getAuthCtx(), this.activity, this.sr);
            this.preprocessor.prepare_T();
            this.ksqlConnectionParams = this.preprocessor.getEffectiveKsqlConnectionParams();
            KsqlRecipePreprocessor.KsqlScriptAnalysis script = this.preprocessor.analyse();
            logger.info((Object)("script=" + JSON.prettyLog((Object)script)));
            List<StreamingEndpoint> outputs = this.preprocessor.getOutputs();
            if (outputs.size() == 0) {
                throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "KSQL recipe without streaming endpoint output");
            }
            if (outputs.size() > 1 && script.countByType.getOrDefault((Object)KsqlRecipePreprocessor.KsqlScriptStatementType.SELECT, 0) > 0) {
                throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_KSQL_AMBIGUOUS_STATEMENT, "The script contains a SELECT statement but there are multiple outputs. Use INSERT INTO instead.");
            }
            if (outputs.size() == 1) {
                for (KsqlRecipePreprocessor.KsqlScriptStatement statement : script.statements) {
                    if (statement.type != KsqlRecipePreprocessor.KsqlScriptStatementType.SELECT) continue;
                    statement.streamName = outputs.get((int)0).id;
                }
            }
            if (this.preprocessor.getRecipe().versionTag == null || recipeState.recipeVersionTag == null) {
                logger.info((Object)"Empty version tags, not using state");
                recipeState.queries.clear();
            } else if (this.preprocessor.getRecipe().versionTag.versionNumber != recipeState.recipeVersionTag.versionNumber) {
                logger.info((Object)"Different version tags, not using state");
                recipeState.queries.clear();
            }
            recipeState.recipeVersionTag = this.preprocessor.getRecipe().versionTag;
            try (KsqlRESTClient client = new KsqlRESTClient(this.ksqlConnectionParams);){
                HashSet previousQueries = Sets.newHashSet();
                try {
                    KsqlRESTClient.StatementRequest listRequest = new KsqlRESTClient.StatementRequest();
                    listRequest.ksql = "list queries;";
                    KsqlRESTClient.StatementResponses listResponses = client.post("/ksql", JSON.toJsonObject((Object)listRequest, (String[])new String[0]), KsqlRESTClient.StatementResponses.class, new String[0]);
                    if (listResponses.size() != 1) {
                        throw new IOException("Listing queries didn't return a single response but " + listResponses.size());
                    }
                    KsqlRESTClient.StatementResponse listResponse = (KsqlRESTClient.StatementResponse)listResponses.get(0);
                    for (KsqlRESTClient.StatementResponseQuery statementResponseQuery : listResponse.queries) {
                        previousQueries.add(statementResponseQuery.id);
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Error during query waiting", (Throwable)e);
                }
                this.preprocessor.synchronizeInputOutputs(client, script);
                try {
                    for (String statement : this.preprocessor.getPreprocessedStatements(client, script)) {
                        logger.info((Object)("Running statement:\n" + statement));
                        if (recipeState.queries.containsKey(statement) && previousQueries.contains(recipeState.queries.get(statement))) {
                            logger.info((Object)"Statement already launched, and query is still running, skip");
                            this.addQueryId(recipeState.queries.get(statement));
                            continue;
                        }
                        KsqlRESTClient.StatementRequest request = new KsqlRESTClient.StatementRequest();
                        request.ksql = statement + "\n;";
                        KsqlRESTClient.StatementResponses responses = client.post("/ksql", JSON.toJsonObject((Object)request, (String[])new String[0]), KsqlRESTClient.StatementResponses.class, new String[0]);
                        if (responses.size() == 0) {
                            throw new IOException("KSQL code did not run");
                        }
                        for (KsqlRESTClient.StatementResponse response : responses) {
                            KsqlRESTClient.KsqlCommandStatus status = response.commandStatus;
                            if (status == null || !status.status.finished()) {
                                if (StringUtils.isBlank((String)response.commandId)) {
                                    throw new IOException("Unfinished drop command, but no command id");
                                }
                                status = client.waitForFinalStatus(response.commandId);
                            }
                            if (status == null || status.status != KsqlRESTClient.KsqlCommandState.SUCCESS) {
                                throw new Exception("Failed to run statement, status=" + String.valueOf((Object)status.status) + " message=" + status.message + " in : " + response.statementText);
                            }
                            String queryCreationPrefix = "Created query with ID ";
                            if (status.message != null && status.message.startsWith(queryCreationPrefix)) {
                                String queryId = status.message.substring(queryCreationPrefix.length());
                                recipeState.queries.put(statement, queryId);
                                this.addQueryId(queryId);
                                continue;
                            }
                            recipeState.queries.remove(statement);
                        }
                    }
                }
                catch (IOException e) {
                    this.cleanupQueriesStarted(client, this.queryIds);
                    throw e;
                }
                JSON.prettyToFile((Object)recipeState, (File)recipeStateFile);
                List<String> queryIds = this.getQueryIds();
                if (queryIds.isEmpty()) {
                    logger.warn((Object)"No query launched");
                    break block40;
                }
                logger.info((Object)("Spawned queries : " + Joiner.on((String)", ").join(queryIds)));
                try {
                    Sets.SetView stopped;
                    ArrayList runningQueryIds = Lists.newArrayList(queryIds);
                    while (runningQueryIds.size() == queryIds.size()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            logger.warn((Object)"Query waiting interrupted", (Throwable)e);
                            break;
                        }
                        try {
                            KsqlRESTClient.StatementRequest listRequest = new KsqlRESTClient.StatementRequest();
                            listRequest.ksql = "list queries;";
                            KsqlRESTClient.StatementResponses listResponses = client.post("/ksql", JSON.toJsonObject((Object)listRequest, (String[])new String[0]), KsqlRESTClient.StatementResponses.class, new String[0]);
                            if (listResponses.size() != 1) {
                                throw new IOException("Listing queries didn't return a single response but " + listResponses.size());
                            }
                            KsqlRESTClient.StatementResponse statementResponse = (KsqlRESTClient.StatementResponse)listResponses.get(0);
                            runningQueryIds.clear();
                            for (KsqlRESTClient.StatementResponseQuery query : statementResponse.queries) {
                                if (!queryIds.contains(query.id)) continue;
                                runningQueryIds.add(query.id);
                            }
                        }
                        catch (IOException e) {
                            logger.warn((Object)"Error during query waiting", (Throwable)e);
                        }
                    }
                    if (!(stopped = Sets.difference((Set)Sets.newHashSet(queryIds), (Set)Sets.newHashSet((Iterable)runningQueryIds))).isEmpty()) {
                        throw new Exception("Exited the query waiting loop because queries where stopped : " + Joiner.on((String)", ").join((Iterable)stopped));
                    }
                }
                catch (Exception e) {
                    this.cleanupQueriesStarted(client, queryIds);
                    throw e;
                }
            }
        }
    }

    private void cleanupQueriesStarted(KsqlRESTClient client, List<String> queryIds) throws IOException {
        logger.info((Object)"Stopping queries");
        KsqlSynchronizer synchronizer = new KsqlSynchronizer(client);
        for (String queryId : queryIds) {
            synchronizer.terminateQuery(queryId, true);
        }
    }

    @Override
    public void notifyBeforeAborting() {
        List<String> queryIds = this.getQueryIds();
        KafkaConnection.KsqlConnectionParams ksqlConnectionParams = this.ksqlConnectionParams;
        logger.info((Object)("Aborting continuous ksql queryIds=" + Joiner.on((String)", ").join(queryIds)));
        if (StringUtils.isNotBlank((String)ksqlConnectionParams.serverUrl)) {
            try (KsqlRESTClient client = new KsqlRESTClient(ksqlConnectionParams);){
                KsqlSynchronizer synchronizer = new KsqlSynchronizer(client);
                for (String queryId : queryIds) {
                    synchronizer.terminateQuery(queryId, true);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to cleanup queries", (Throwable)e);
            }
        }
    }

    public static class KsqlContinuousRecipeState {
        public VersionTag recipeVersionTag;
        public Map<String, String> queries = Maps.newHashMap();
    }
}

