/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.ksql;

import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dip.utils.SecretString;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.ConnectionReuseStrategy;
import com.dataiku.dss.shadelib.org.apache.http.auth.AuthScope;
import com.dataiku.dss.shadelib.org.apache.http.auth.Credentials;
import com.dataiku.dss.shadelib.org.apache.http.client.ClientProtocolException;
import com.dataiku.dss.shadelib.org.apache.http.client.CredentialsProvider;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.config.Registry;
import com.dataiku.dss.shadelib.org.apache.http.config.RegistryBuilder;
import com.dataiku.dss.shadelib.org.apache.http.conn.HttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.NoopHostnameVerifier;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.TrustAllStrategy;
import com.dataiku.dss.shadelib.org.apache.http.impl.NoConnectionReuseStrategy;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.BasicCredentialsProvider;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.ssl.SSLContextBuilder;
import com.dataiku.dss.shadelib.org.apache.http.ssl.SSLContexts;
import com.dataiku.dss.shadelib.org.apache.http.ssl.TrustStrategy;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;

public class KsqlRESTClient
implements AutoCloseable {
    private final String serverUrl;
    private final CloseableHttpClient httpClient;
    private final PoolingHttpClientConnectionManager connectionManager;
    private final String basicAuthenticationUserPassword;
    private String serverVersion;
    private Boolean oldStyleRowkeys;
    private Boolean oldStyleDescribe;
    private static final Logger logger = Logger.getLogger((String)"dip.ksql.rest.client");

    public KsqlRESTClient(KafkaConnection.KsqlConnectionParams connectionParams) {
        this.serverUrl = connectionParams.serverUrl;
        this.serverVersion = connectionParams.serverVersion;
        this.basicAuthenticationUserPassword = connectionParams.basicAuthentication ? String.format("%s:%s", connectionParams.basicAuthUser, connectionParams.basicAuthPassword) : null;
        try {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
            if (connectionParams.sslClientAuthEnabled) {
                String sslKeystorePassword = Optional.ofNullable(SecretString.getSecretOrNull((SecretString)connectionParams.sslKeystorePassword)).orElse("");
                String sslKeyPassword = Optional.ofNullable(SecretString.getSecretOrNull((SecretString)connectionParams.sslKeyPassword)).orElse("");
                sslContextBuilder.loadKeyMaterial(new File(connectionParams.sslKeystoreLocation), sslKeystorePassword.toCharArray(), sslKeyPassword.toCharArray());
            }
            SSLContext sslContext = sslContextBuilder.build();
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
            this.connectionManager = new PoolingHttpClientConnectionManager(registry);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to trust certificates", e);
        }
        this.connectionManager.setMaxTotal(50);
        this.connectionManager.setDefaultMaxPerRoute(50);
        Credentials credentials = new Credentials(){

            public String getPassword() {
                return null;
            }

            public Principal getUserPrincipal() {
                return null;
            }
        };
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, credentials);
        HttpClientBuilder builder = HttpClientBuilder.create().disableAutomaticRetries().evictExpiredConnections().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy()).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setUserAgent("dss").addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        this.httpClient = builder.build();
    }

    @Override
    public void close() throws Exception {
        try {
            this.connectionManager.shutdown();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to close REST connection manager", (Throwable)e);
        }
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to close REST client", (Throwable)e);
        }
    }

    private String buildUrl(String path, String ... parameters) throws MalformedURLException, IOException {
        String url;
        try {
            URIBuilder uriBuilder = new URIBuilder(new URI(this.serverUrl));
            uriBuilder = uriBuilder.setPath(path);
            int i = 0;
            while (i + 1 < parameters.length) {
                uriBuilder = uriBuilder.addParameter(parameters[i], parameters[i + 1]);
                i += 2;
            }
            url = uriBuilder.build().toURL().toString();
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not build Ksql url", e);
        }
        return url;
    }

    private CloseableHttpResponse executeOnClient(HttpRequestBase request) throws ClientProtocolException, IOException {
        return this.httpClient.execute((HttpUriRequest)request);
    }

    private <T> T doCall(HttpRequestBase request, Class<? extends T> clazz) throws IOException {
        try (CloseableHttpResponse resp = this.doCall(request);){
            if (clazz.equals(Void.class)) {
                T t = null;
                return t;
            }
            String data = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            Object object = JSON.parse((String)data, clazz);
            return (T)object;
        }
    }

    private CloseableHttpResponse doCall(HttpRequestBase request) throws IOException {
        CloseableHttpResponse resp;
        request.setHeader("Accept", "application/vnd.ksql.v1+json");
        request.setHeader("Content-Type", "application/vnd.ksql.v1+json");
        if (this.basicAuthenticationUserPassword != null) {
            request.setHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])this.basicAuthenticationUserPassword.getBytes(StandardCharsets.UTF_8)));
        }
        try {
            resp = this.executeOnClient(request);
        }
        catch (NullPointerException e) {
            boolean wasInBasicAuth = false;
            StackTraceElement[] st2 = e.getStackTrace();
            if (st2 != null) {
                for (StackTraceElement elm : st2) {
                    wasInBasicAuth |= elm.getClassName().contains("BasicScheme");
                }
            }
            if (wasInBasicAuth) {
                throw new IOException("KSQL server expects basic authentication");
            }
            throw e;
        }
        int code = resp.getStatusLine().getStatusCode();
        if (code == 204) {
            throw new IOException("Unexpected status code 204 for : " + request.getURI().getPath());
        }
        if (code == 401 || code == 403) {
            throw new IOException("Unauthorized access to : " + request.getURI().getPath() + " -> " + String.valueOf(resp.getStatusLine()));
        }
        if (code == 200 || code == 201) {
            return resp;
        }
        String data = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        try {
            String type;
            JsonObject parsed = (JsonObject)JSON.parse((String)data, JsonObject.class);
            String string = type = parsed.has("@type") && !parsed.get("@type").isJsonNull() ? parsed.get("@type").getAsString() : null;
            if ("statement_error".equals(type)) {
                int errorCode = parsed.get("error_code").getAsInt();
                String message = parsed.get("message").getAsString();
                throw new KsqlStatementException("Ksql call failed (HTTP status " + code + "): " + errorCode + " : " + message, parsed);
            }
            logger.warn((Object)"Ksql returned an error, but the body isn't an error");
            String reason = resp.getStatusLine().getReasonPhrase();
            throw new IOException("Ksql call failed (HTTP status " + code + ", reason " + reason + ", response:  " + data + ")");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)"Ksql returned an error without json response", (Throwable)e);
            String reason = resp.getStatusLine().getReasonPhrase();
            throw new IOException("Ksql call failed (HTTP status " + code + ", reason " + reason + ", response:  " + data + ")");
        }
    }

    public <T> T post(String path, JsonObject jsonRequest, Class<? extends T> clazz, String ... parameters) throws IOException {
        logger.info((Object)("Post '" + path + "' (parameters = " + JSON.log((Object)parameters) + ") on " + this.serverUrl));
        String url = this.buildUrl(path, parameters);
        HttpPost post = new HttpPost(url);
        post.setEntity(JSON.toHttpEntity((Object)jsonRequest));
        return this.doCall((HttpRequestBase)post, clazz);
    }

    public InputStream postToStream(String path, JsonObject jsonRequest, String ... parameters) throws IOException {
        logger.info((Object)("Post '" + path + "' (parameters = " + JSON.log((Object)parameters) + ") on " + this.serverUrl));
        String url = this.buildUrl(path, parameters);
        HttpPost post = new HttpPost(url);
        post.setEntity(JSON.toHttpEntity((Object)jsonRequest));
        return this.doCall((HttpRequestBase)post).getEntity().getContent();
    }

    public <T> T get(String path, Class<? extends T> clazz, String ... parameters) throws IOException {
        logger.info((Object)("Get '" + path + "' (parameters = " + JSON.log((Object)parameters) + ") on " + this.serverUrl));
        String url = this.buildUrl(path, parameters);
        HttpGet get = new HttpGet(url);
        return this.doCall((HttpRequestBase)get, clazz);
    }

    public void delete(String path, String ... parameters) throws IOException {
        logger.info((Object)("Delete '" + path + "' (parameters = " + JSON.log((Object)parameters) + ") on " + this.serverUrl));
        String url = this.buildUrl(path, parameters);
        HttpDelete delete = new HttpDelete(url);
        this.doCall((HttpRequestBase)delete, Void.class);
    }

    public StatementResponses runStatements(String code) throws IOException {
        StatementRequest request = new StatementRequest();
        request.ksql = code;
        return this.post("/ksql", JSON.toJsonObject((Object)request, (String[])new String[0]), StatementResponses.class, new String[0]);
    }

    public QueryResponses postToQuery(String path, JsonObject jsonRequest, String ... parameters) throws IOException {
        final InputStream is = this.postToStream(path, jsonRequest, parameters);
        Gson gson = JSON.gson();
        TypeAdapter queryResponseHeaderAdapter = gson.getAdapter(QueryResponseHeader.class);
        final TypeAdapter queryResponseItemAdapter = gson.getAdapter(QueryResponseItem.class);
        final JsonReader reader = new JsonReader((Reader)new InputStreamReader(is));
        reader.beginArray();
        final QueryResponseHeader header = (QueryResponseHeader)queryResponseHeaderAdapter.read(reader);
        return new QueryResponses(){

            @Override
            public QueryResponseHeader header() {
                return header;
            }

            @Override
            public QueryResponseItem next() throws IOException {
                if (reader.hasNext()) {
                    return (QueryResponseItem)queryResponseItemAdapter.read(reader);
                }
                reader.endArray();
                return null;
            }

            @Override
            public void close() throws Exception {
                reader.close();
                is.close();
            }
        };
    }

    public boolean runFullySingleStatement(String code, boolean silent, String action) throws IOException {
        try {
            StatementRequest request = new StatementRequest();
            request.ksql = code;
            logger.info((Object)("Running script:\n" + request.ksql));
            StatementResponses responses = this.post("/ksql", JSON.toJsonObject((Object)request, (String[])new String[0]), StatementResponses.class, new String[0]);
            if (responses.size() != 1) {
                throw new IOException("Unable to " + action + ", no response from ksql");
            }
            StatementResponse response = (StatementResponse)responses.get(0);
            KsqlCommandStatus status = response.commandStatus;
            if (status == null || !status.status.finished()) {
                if (StringUtils.isBlank((String)response.commandId)) {
                    throw new IOException("Unfinished " + action + ", but no command id");
                }
                status = this.waitForFinalStatus(response.commandId);
            }
            if (status == null || status.status != KsqlCommandState.SUCCESS) {
                String errorMessage = "Unable to " + action + ", command status is " + (String)(status == null ? "null" : String.valueOf((Object)status.status) + " : " + status.message);
                if (silent) {
                    logger.warn((Object)errorMessage);
                    return false;
                }
                throw new IOException(errorMessage);
            }
            return true;
        }
        catch (KsqlStatementException e) {
            String errorMessage = "Unable to " + action + ", command failed : " + e.data.get("message").getAsString();
            if (silent) {
                logger.warn((Object)errorMessage);
                return false;
            }
            throw new IOException(errorMessage);
        }
    }

    public KsqlCommandStatus getCommandStatus(String commandId) throws IOException {
        return this.get("/status/" + commandId, KsqlCommandStatus.class, new String[0]);
    }

    public KsqlCommandStatus waitForFinalStatus(String commandId) throws IOException {
        KsqlCommandStatus status = null;
        while (true) {
            status = this.getCommandStatus(commandId);
            if (status.status.finished()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while waiting for command status", e);
            }
        }
        return status;
    }

    public String getServerVersion() {
        if (StringUtils.isNotBlank((String)this.serverVersion)) {
            return this.serverVersion;
        }
        try {
            JsonObject info = this.get("/info", JsonObject.class, new String[0]);
            this.serverVersion = JsonUtils.getOrNullStr(info, "KsqlServerInfo", "version");
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to get info", (Throwable)e);
        }
        return StringUtils.defaultIfBlank((String)this.serverVersion, (String)"0.1.0");
    }

    public boolean usesOldStyleRowkeys() {
        if (this.oldStyleRowkeys == null) {
            this.oldStyleRowkeys = KsqlRESTClient.usesPre0_10Rowkeys(this.getServerVersion());
        }
        return this.oldStyleRowkeys;
    }

    public static boolean usesPre0_10Rowkeys(String version) {
        if (StringUtils.isBlank((String)version)) {
            return true;
        }
        if (Pattern.matches("^4\\.1\\..*$", version) || Pattern.matches("^5\\.[0-5]\\..*$", version)) {
            return true;
        }
        return Pattern.matches("^0\\.[1-9]\\..*$", version);
    }

    public boolean useOldStyleDescribe() {
        if (this.oldStyleDescribe == null) {
            this.oldStyleDescribe = KsqlRESTClient.usesPre0_16Describe(this.getServerVersion());
        }
        return this.oldStyleDescribe;
    }

    public static boolean usesPre0_16Describe(String version) {
        if (StringUtils.isBlank((String)version)) {
            return true;
        }
        if (Pattern.matches("^[1-5]\\..*$", version) || Pattern.matches("^6\\.[0-1]\\..*$", version)) {
            return true;
        }
        if (Pattern.matches("^0\\.[1-9]\\..*$", version)) {
            return true;
        }
        return Pattern.matches("^0\\.1[0-5]\\..*$", version);
    }

    public static class KsqlStatementException
    extends IOException {
        private static final long serialVersionUID = 1L;
        public final JsonObject data;

        public KsqlStatementException(String message, JsonObject data) {
            super(message);
            this.data = data;
        }
    }

    public static class StatementRequest {
        public String ksql;
        public Map<String, String> streamsProperties;
        public Long commandSequenceNumber;
    }

    public static class StatementResponses
    extends ArrayList<StatementResponse> {
        private static final long serialVersionUID = -4095904646985301787L;
    }

    public static class QueryResponseHeader {
        public QueryResponseHeaderRow header;
    }

    public static class QueryResponseItem {
        public QueryResponseRow row;
        public String finalMessage;
        public String errorMessage;
    }

    public static class StatementResponse {
        public String statementText;
        public List<StatementResponseWarning> warnings = Lists.newArrayList();
        public String commandId;
        public KsqlCommandStatus commandStatus;
        public Long commandSequenceNumber;
        public List<StatementResponseStream> streams;
        public List<StatementResponseTable> tables;
        public List<StatementResponseQuery> queries;
        public Map<String, String> properties;
        public StatementResponseDescribe sourceDescription;
        public StatementResponseExplain queryDescription;
    }

    public static class KsqlCommandStatus {
        public KsqlCommandState status;
        public String message;
    }

    public static enum KsqlCommandState {
        QUEUED(false),
        PARSING(false),
        EXECUTING(false),
        TERMINATED(true),
        SUCCESS(true),
        ERROR(true);

        private final boolean finished;

        private KsqlCommandState(boolean finished) {
            this.finished = finished;
        }

        public boolean finished() {
            return this.finished;
        }
    }

    public static class StatementResponseExplain {
        public String statementText;
        public List<String> sources;
        public List<String> sinks;
        public List<KsqlField> fields;
        public String executionPlan;
        public String topology;
        public String windowType;
        public Map<String, String> overriddenProperties;
    }

    public static class StatementResponseDescribe {
        public String name;
        public List<StatementResponseQuery> readQueries;
        public List<StatementResponseQuery> writeQueries;
        public List<KsqlField> fields;
        public KsqlObjectType type;
        public String key;
        public String timestamp;
        public String keyFormat;
        public String valueFormat;
        public String topic;
        public boolean extended;
        public String statistics;
        public String errorStats;
        public int replication;
        public int partitions;
        public String windowType;
    }

    public static class StatementResponseQuery {
        public String queryString;
        public List<String> sinks;
        public String id;
    }

    public static class StatementResponseTable {
        public String name;
        public String topic;
        public String format;
        public String type;
        public boolean isWindowed;
    }

    public static class StatementResponseStream {
        public String name;
        public String topic;
        public String format;
        public String type;
    }

    public static class StatementResponseWarning {
        public String message;
    }

    public static interface QueryResponses
    extends AutoCloseable {
        public QueryResponseHeader header();

        public QueryResponseItem next() throws IOException;
    }

    public static class QueryResponseRow {
        public List<Object> columns = Lists.newArrayList();
    }

    public static class QueryResponseHeaderRow {
        public String queryId;
        public String schema;
    }

    public static class QueryRequest {
        public String ksql;
        public Map<String, String> streamsProperties;
    }

    public static class KsqlField {
        public String name;
        public KsqlFieldSchema schema;
        public String type;

        public KsqlField() {
        }

        public KsqlField(String name, KsqlFieldType fieldType) {
            this.name = name;
            this.schema = new KsqlFieldSchema();
            this.schema.type = fieldType;
        }

        public KsqlField withKey() {
            this.type = "KEY";
            return this;
        }
    }

    public static class KsqlFieldSchema {
        public KsqlFieldType type;
        public KsqlFieldSchema memberSchema;
        public List<KsqlField> fields;
    }

    public static enum KsqlObjectType {
        STREAM,
        TABLE;

    }

    public static enum KsqlFieldType {
        INTEGER,
        BIGINT,
        BOOLEAN,
        DOUBLE,
        STRING,
        MAP,
        ARRAY,
        STRUCT,
        DECIMAL,
        TIMESTAMP,
        DATE;

    }
}

