/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.ksql;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.streaming.ksql.KsqlExplainer;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRESTClient;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRecipePreprocessor;
import com.dataiku.dip.recipes.streaming.ksql.KsqlSchemaHandler;
import com.dataiku.dip.recipes.streaming.ksql.KsqlSynchronizer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class KsqlRecipeStatusComputer
extends RecipeStatusComputer {
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected GenericRecipesValidationService validationService;
    private static Logger logger = Logger.getLogger((String)"dip.ksql.status");

    public KsqlRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public KsqlRecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        KsqlRecipeStatus ret = null;
        ContinuousActivity activity = new ContinuousActivity();
        activity.projectKey = this.recipe.projectKey;
        activity.recipeId = this.recipe.name;
        KsqlRecipePreprocessor preprocessor = new KsqlRecipePreprocessor(authCtx, activity, this.recipe);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx.failIfNoSafeCode("validate a Ksql recipe");
            ret = this.fastStatusIgnorePartitions(authCtx);
            if (ret.topLevelMessages.error) {
                KsqlRecipeStatus ksqlRecipeStatus = ret;
                return ksqlRecipeStatus;
            }
            RecipeVariablesHelper helper = new RecipeVariablesHelper();
            RecipeVariablesHelper.RecipeSubstitutionVariablesResult vres = helper.getRecipeVariablesNoPartition(authCtx, this.recipe.projectKey, null);
            ret.substitutionVariables = vres.substitutionVariables;
            preprocessor.prepare_T(this.recipe, this.payload);
        }
        KsqlRecipePreprocessor.KsqlScriptAnalysis script = preprocessor.analyse();
        logger.info((Object)("script=" + JSON.prettyLog((Object)script)));
        if (script.countByType.getOrDefault((Object)KsqlRecipePreprocessor.KsqlScriptStatementType.SELECT, 0) == 0 && script.countByType.getOrDefault((Object)KsqlRecipePreprocessor.KsqlScriptStatementType.INSERT_INTO, 0) == 0) {
            ret.topLevelMessages.withWarning((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY, "No select or insert into statement found, cannot check output schemas");
        }
        List<StreamingEndpoint> inputs = preprocessor.getInputs();
        List<StreamingEndpoint> outputs = preprocessor.getOutputs();
        if (outputs.size() == 0) {
            ret.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "KSQL recipe without streaming endpoint output");
        } else if (outputs.size() > 1 && script.countByType.getOrDefault((Object)KsqlRecipePreprocessor.KsqlScriptStatementType.SELECT, 0) > 0) {
            ret.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_KSQL_AMBIGUOUS_STATEMENT, "The script contains a SELECT statement but there are multiple outputs. Use INSERT INTO instead.");
        } else if (outputs.size() == 1) {
            for (KsqlRecipePreprocessor.KsqlScriptStatement ksqlScriptStatement : script.statements) {
                if (ksqlScriptStatement.type != KsqlRecipePreprocessor.KsqlScriptStatementType.SELECT) continue;
                ksqlScriptStatement.streamName = outputs.get((int)0).id;
            }
        }
        HashMap outputsById = Maps.newHashMap();
        for (StreamingEndpoint output : outputs) {
            outputsById.put(output.id, output);
        }
        ret.schemaResult = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        try (KsqlRESTClient ksqlRESTClient = new KsqlRESTClient(preprocessor.getEffectiveKsqlConnectionParams());){
            KsqlSchemaHandler schemaHandler = new KsqlSchemaHandler();
            KsqlSynchronizer synchronizer = new KsqlSynchronizer(ksqlRESTClient);
            for (StreamingEndpoint input : inputs) {
                KsqlSynchronizer.CompatibilityAndReason compatibility = preprocessor.getCompatibility(synchronizer, input);
                logger.info((Object)("Compatibility for " + input.id + " is " + JSON.log((Object)compatibility)));
                if (compatibility.compatibility == KsqlSynchronizer.Compatibility.DOES_NOT_EXIST) {
                    ret.inputsToSynchronize.add(new DatasetLocUtils.DatasetLoc(input.projectKey, input.id));
                    continue;
                }
                if (compatibility.compatibility == KsqlSynchronizer.Compatibility.INCOMPATIBLE_SCHEMA) {
                    ret.inputsToResynchronize.add(new DatasetLocUtils.DatasetLoc(input.projectKey, input.id));
                    continue;
                }
                if (compatibility.compatibility == KsqlSynchronizer.Compatibility.INCOMPATIBLE_FORMAT) {
                    ret.inputsToResynchronize.add(new DatasetLocUtils.DatasetLoc(input.projectKey, input.id));
                    continue;
                }
                if (compatibility.compatibility != KsqlSynchronizer.Compatibility.NOT_SYNCHRONIZABLE) continue;
                ret.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_KSQL_INCOMPATIBLE_ENDPOINT, "Cannot synchronize input " + input.id + " : " + compatibility.reason);
            }
            for (KsqlRecipePreprocessor.KsqlScriptStatement statement : script.statements) {
                StreamingEndpoint se = (StreamingEndpoint)outputsById.get(statement.streamName);
                if (se == null) {
                    logger.warn((Object)("Ksql recipe writes to a stream that doesn't belong to the recipe outputs: " + statement.streamName));
                    continue;
                }
                KsqlSynchronizer.CompatibilityAndReason synchronizability = synchronizer.checkSynchronizability(se);
                if (synchronizability != null && synchronizability.compatibility == KsqlSynchronizer.Compatibility.NOT_SYNCHRONIZABLE) {
                    ret.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_KSQL_INCOMPATIBLE_ENDPOINT, "Cannot synchronize output " + se.id + " : " + synchronizability.reason);
                    continue;
                }
                logger.info((Object)("Running explain query for " + se.id));
                try {
                    RecipeSchemaService.ComputableSchemaAutoupdateResult updateResult;
                    KsqlExplainer.ExplainPlanData explanation = new KsqlExplainer(ksqlRESTClient).explain(statement.select, statement.type == KsqlRecipePreprocessor.KsqlScriptStatementType.SELECT);
                    KsqlSynchronizer.CompatibilityAndReason compatibility = synchronizer.checkCompatibilityWithExplained(se, explanation.fields);
                    if (compatibility.compatibility == KsqlSynchronizer.Compatibility.INCOMPATIBLE_SCHEMA) {
                        RecipeSchemaService.ComputableSchemaAutoupdateResult updateResult2 = RecipeSchemaService.ComputableSchemaAutoupdateResult.forStreamingEnpdoint();
                        updateResult2.type = FlowComputable.FCType.STREAMING_ENDPOINT;
                        updateResult2.id = se.id;
                        updateResult2.previousSchemaWasEmpty = se.schema.getColumns().isEmpty();
                        updateResult2.incompatibilities = Lists.newArrayList((Object[])new String[]{compatibility.reason});
                        synchronizer.fillUpdateResult(updateResult2, se, explanation.fields);
                        ret.schemaResult.computables.add(updateResult2);
                        ++ret.schemaResult.totalIncompatibilities;
                    }
                    KafkaStreamingEndpointParams kafkaParams = se.getParamsAs(KafkaStreamingEndpointParams.class);
                    if (explanation.isTable && kafkaParams.ksqlParams.syncAs != KafkaStreamingEndpointParams.KsqlSyncType.TABLE) {
                        updateResult = this.makeUpdateResultForBadSyncType(se, KafkaStreamingEndpointParams.KsqlSyncType.TABLE);
                        ret.schemaResult.computables.add(updateResult);
                        ++ret.schemaResult.totalIncompatibilities;
                    } else if (!explanation.isTable && kafkaParams.ksqlParams.syncAs != KafkaStreamingEndpointParams.KsqlSyncType.STREAM) {
                        updateResult = this.makeUpdateResultForBadSyncType(se, KafkaStreamingEndpointParams.KsqlSyncType.STREAM);
                        ret.schemaResult.computables.add(updateResult);
                        ++ret.schemaResult.totalIncompatibilities;
                    }
                    if (StringUtils.isNotBlank((String)explanation.windowType) && !explanation.windowType.equalsIgnoreCase(kafkaParams.ksqlParams.windowType.name())) {
                        updateResult = this.makeUpdateResultForBadWindowType(se, explanation.windowType);
                        ret.schemaResult.computables.add(updateResult);
                        ++ret.schemaResult.totalIncompatibilities;
                        continue;
                    }
                    if (!StringUtils.isBlank((String)explanation.windowType) || kafkaParams.ksqlParams.windowType == KafkaStreamingEndpointParams.KsqlWindowType.NONE) continue;
                    updateResult = this.makeUpdateResultForBadWindowType(se, null);
                    ret.schemaResult.computables.add(updateResult);
                    ++ret.schemaResult.totalIncompatibilities;
                }
                catch (KsqlRESTClient.KsqlStatementException e) {
                    logger.info((Object)("Unable to run explain of query to " + statement.streamName));
                    ret.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, e.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            logger.error((Object)"Unable to check statements schemas", (Throwable)iOException);
            ret.topLevelMessages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_KSQL_REST_ERROR, "Failed to check statements schemas: " + ExceptionUtils.getMessageWithCauses((Throwable)iOException));
        }
        return ret;
    }

    private RecipeSchemaService.ComputableSchemaAutoupdateResult makeUpdateResultForBadSyncType(StreamingEndpoint se, KafkaStreamingEndpointParams.KsqlSyncType syncType) {
        RecipeSchemaService.ComputableSchemaAutoupdateResult updateResult = RecipeSchemaService.ComputableSchemaAutoupdateResult.forStreamingEnpdoint();
        updateResult.type = FlowComputable.FCType.STREAMING_ENDPOINT;
        updateResult.id = se.id;
        updateResult.previousSchemaWasEmpty = false;
        updateResult.incompatibilities = syncType == KafkaStreamingEndpointParams.KsqlSyncType.STREAM ? Lists.newArrayList((Object[])new String[]{"Statement produces a kstream, endpoint is a ktable"}) : Lists.newArrayList((Object[])new String[]{"Statement produces a ktable, endpoint is a kstream"});
        updateResult.getKsqlParams().syncAs = syncType;
        return updateResult;
    }

    private RecipeSchemaService.ComputableSchemaAutoupdateResult makeUpdateResultForBadWindowType(StreamingEndpoint se, String windowType) {
        RecipeSchemaService.ComputableSchemaAutoupdateResult updateResult = RecipeSchemaService.ComputableSchemaAutoupdateResult.forStreamingEnpdoint();
        updateResult.type = FlowComputable.FCType.STREAMING_ENDPOINT;
        updateResult.id = se.id;
        updateResult.previousSchemaWasEmpty = false;
        if (StringUtils.isNotBlank((String)windowType)) {
            updateResult.incompatibilities = Lists.newArrayList((Object[])new String[]{"Statement is windowed (" + windowType + "), but the output endpoint is not"});
            updateResult.getKsqlParams().windowType = KafkaStreamingEndpointParams.KsqlWindowType.valueOf(windowType);
        } else {
            updateResult.incompatibilities = Lists.newArrayList((Object[])new String[]{"Statement is not windowed, but the output endpoint is"});
            updateResult.getKsqlParams().windowType = KafkaStreamingEndpointParams.KsqlWindowType.NONE;
        }
        return updateResult;
    }

    @Override
    public KsqlRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        KsqlRecipeStatus ret = new KsqlRecipeStatus();
        this.performBasicStructureChecks(ret, authCtx);
        ret.addSingleEngine("USER_CODE", "User code", "PYTHON", "Ksql", "Ksql (user code)");
        return ret;
    }

    public static class KsqlRecipeStatus
    extends CodeBasedRecipeStatus {
        public RecipeSchemaService.RecipeSchemaAutoupdateResult schemaResult;
        public List<DatasetLocUtils.DatasetLoc> inputsToSynchronize = Lists.newArrayList();
        public List<DatasetLocUtils.DatasetLoc> inputsToResynchronize = Lists.newArrayList();

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            return ret;
        }
    }
}

