/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.python;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.recipes.streaming.python.FunctionCheckpoint;
import com.dataiku.dip.recipes.streaming.python.RowsPullingHandler;
import com.dataiku.dip.recipes.streaming.python.RowsSplittingHandler;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ContinuousPythonFunctionRunnerThread
extends Thread {
    private final SecretProtectedKernelLink link;
    private final RowsSplittingHandler rowsSplittingHandler;
    private final String code;
    private final String projectKey;
    private final int nbReplicas;
    private final int replicaIndex;
    private final int restartCount;
    private final Runnable notifyError;
    private volatile boolean closed;
    private static final Logger logger = Logger.getLogger((String)"dip.streaming.function.rows.process");

    public ContinuousPythonFunctionRunnerThread(String projectKey, SecretProtectedKernelLink link, String code, RowsSplittingHandler rowsSplittingHandler, int nbReplicas, int replicaIndex, int restartCount, Runnable notifyError) {
        super("cpython-runner-thread");
        this.projectKey = projectKey;
        this.link = link;
        this.code = code;
        this.rowsSplittingHandler = rowsSplittingHandler;
        this.nbReplicas = nbReplicas;
        this.replicaIndex = replicaIndex;
        this.restartCount = restartCount;
        this.notifyError = notifyError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        RowsSplittingHandler.InputRowsBatch current;
        block29: {
            current = null;
            try {
                this.link.waitForProcess(300000);
                StartCommand startCommand = new StartCommand();
                startCommand.projectKey = this.projectKey;
                startCommand.code = this.code;
                startCommand.inputSchemas = this.rowsSplittingHandler.getInputSchemas();
                startCommand.windowDefinitions = this.rowsSplittingHandler.getWindowDefinitions();
                startCommand.nbReplicas = this.nbReplicas;
                startCommand.replicaIndex = this.replicaIndex;
                startCommand.restartCount = this.restartCount;
                this.link.sendRequest((Object)startCommand);
                StartResponse started = (StartResponse)this.link.receiveJsonResponse(StartResponse.class);
                if (!started.ok) {
                    throw new Exception("Kernel started didn't return ok status");
                }
                InitCommand initCommand = new InitCommand();
                InitResponse inited = null;
                try {
                    initCommand.doInit = this.rowsSplittingHandler.startInitIfNeeded();
                    this.link.sendRequest((Object)initCommand);
                    inited = (InitResponse)this.link.receiveJsonResponse(InitResponse.class);
                    if (!inited.ok) {
                        throw new Exception("Kernel init didn't return ok status");
                    }
                    if (initCommand.doInit) {
                        this.rowsSplittingHandler.notifyInit(inited != null && inited.ok);
                    }
                }
                catch (Throwable throwable) {
                    if (!initCommand.doInit) throw throwable;
                    this.rowsSplittingHandler.notifyInit(inited != null && inited.ok);
                    throw throwable;
                }
                this.rowsSplittingHandler.waitForAllPushThreadsStarted();
                InitDoneCommand initDoneCommand = new InitDoneCommand();
                initDoneCommand.outputSchemas = this.rowsSplittingHandler.getOutputSchemas();
                this.link.sendRequest((Object)initDoneCommand);
                InitDoneResponse initDoneResponse = (InitDoneResponse)this.link.receiveJsonResponse(InitDoneResponse.class);
                if (!initDoneResponse.ok) {
                    throw new Exception("Kernel init acknoledgment didn't return ok status");
                }
                while (true) {
                    JsonObject message;
                    String messageType;
                    String string = messageType = (message = (JsonObject)this.link.receiveJsonResponse(JsonObject.class)).has("type") && !message.get("type").isJsonNull() ? message.get("type").getAsString() : null;
                    if ("data".equals(messageType)) {
                        if (current != null) {
                            throw new IllegalStateException("Previous chunk wasn't processed");
                        }
                        MoreWorkResponse workResponse = new MoreWorkResponse();
                        current = this.rowsSplittingHandler.getChunk();
                        if (current == null) {
                            workResponse.isPing = true;
                        } else if (current.checkpoint == null) {
                            workResponse.done = true;
                        } else {
                            workResponse.inputs = current.inputs;
                            workResponse.checkpoint = current.checkpoint;
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("  > " + current.inputs.entrySet().stream().map(e -> (String)e.getKey() + ":" + ((RowsSplittingHandler.InputRowsElement)e.getValue()).rows.size()).collect(Collectors.joining(", "))));
                            }
                        }
                        this.link.sendRequest((Object)workResponse);
                        if (!workResponse.done) continue;
                        if (current == null) break block29;
                        break;
                    }
                    if ("processed".equals(messageType)) {
                        if (current == null) {
                            throw new IllegalStateException("Current chunk hasn't been initialized");
                        }
                        WorkDoneRequest workDone = (WorkDoneRequest)JSON.parse((JsonElement)message, WorkDoneRequest.class);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("  < " + workDone.outputRows.entrySet().stream().map(e -> (String)e.getKey() + ":" + ((List)e.getValue()).size()).collect(Collectors.joining(", "))));
                        }
                        RowsSplittingHandler.OutputRowsBatch outputBatch = new RowsSplittingHandler.OutputRowsBatch();
                        outputBatch.rows = workDone.outputRows;
                        outputBatch.split = current.split;
                        outputBatch.index = current.index;
                        this.rowsSplittingHandler.giveProcessed(outputBatch);
                        current = null;
                        this.link.sendRequest((Object)new JsonObject());
                        continue;
                    }
                    if (!"window".equals(messageType)) throw new Exception("Unhandled work request " + messageType);
                    MoreWorkRequest request = (MoreWorkRequest)JSON.parse((JsonElement)message, MoreWorkRequest.class);
                    MoreWorkResponse workResponse = new MoreWorkResponse();
                    workResponse.windows = this.rowsSplittingHandler.getWindowForRanges(request.windows);
                    this.link.sendRequest((Object)workResponse);
                }
            }
            catch (Exception e3) {
                logger.error((Object)"Failed to communicate with sub-process", (Throwable)e3);
                if (this.notifyError == null) return;
                this.notifyError.run();
                return;
            }
            try {
                this.rowsSplittingHandler.returnChunk(current);
            }
            catch (InterruptedException e2) {
                logger.error((Object)"Failed to return last chunk", (Throwable)e2);
                throw new RuntimeException("Failed to return last chunk", e2);
            }
        }
        this.stopHandling();
        return;
        finally {
            if (current != null) {
                try {
                    this.rowsSplittingHandler.returnChunk(current);
                }
                catch (InterruptedException e4) {
                    logger.error((Object)"Failed to return last chunk", (Throwable)e4);
                    throw new RuntimeException("Failed to return last chunk", e4);
                }
            }
            this.stopHandling();
        }
    }

    public void stopHandling() {
        logger.info((Object)("Stop handling closed=" + this.closed + " on " + String.valueOf(this)));
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.link.close();
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to close link to sub-process", (Throwable)e);
        }
    }

    public static class StartCommand {
        public int nbReplicas;
        public int replicaIndex;
        public int restartCount;
        public String projectKey;
        public String code;
        public Map<String, Schema> inputSchemas = Maps.newHashMap();
        public Map<String, Long> windowDefinitions = Maps.newHashMap();
    }

    public static class StartResponse {
        public boolean ok;
    }

    public static class InitCommand {
        public boolean doInit;
    }

    public static class InitResponse {
        public boolean ok;
    }

    public static class InitDoneCommand {
        public Map<String, Schema> outputSchemas = Maps.newHashMap();
    }

    public static class InitDoneResponse {
        public boolean ok;
    }

    public static class MoreWorkResponse {
        public boolean isPing;
        public boolean done;
        public Map<String, RowsSplittingHandler.InputRowsElement> inputs;
        public Map<String, RowsSplittingHandler.InputWindowElement> windows;
        public FunctionCheckpoint checkpoint;
    }

    public static class WorkDoneRequest {
        public Map<String, List<List<Object>>> outputRows = Maps.newHashMap();
    }

    public static class MoreWorkRequest {
        public String type;
        public Map<String, RowsPullingHandler.IndexRange> windows;
    }
}

