/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.resourceusage;

import com.dataiku.dip.dataflow.JobTicketUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;

public class ComputeResourceUsageTicketUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.cru.ticket");

    public static ComputeResourceUsageContext buildCRUContextFromAuthCtxUsage(HttpServletRequest req, AuthCtxUsage authCtxUsage) {
        if (authCtxUsage.getPayload() != null && authCtxUsage.getPayload() instanceof APITicketService.Ticket) {
            APITicketService.Ticket ticket = (APITicketService.Ticket)authCtxUsage.getPayload();
            String activityId = req.getHeader("X-DKU-JobActivityId");
            logger.infoV("Ticket has cruContext: %s isJobTicket: %s activityId: %s", new Object[]{ticket.cruContext != null, JobTicketUtils.isJobTicket(ticket), activityId});
            if (ticket.cruContext != null) {
                logger.info((Object)("Ticket has a CRU context attached: " + JSON.log((Object)ticket.cruContext)));
                return ticket.cruContext;
            }
            if (JobTicketUtils.isJobTicket(ticket) && activityId != null) {
                logger.info((Object)("Building job activity CRU context from ticket metadata: " + JSON.log((Object)ticket.metadata) + " and activity " + activityId));
                ComputeResourceUsageContext cruContext = JobTicketUtils.makeJobActivityCRUContextFromTicket(authCtxUsage.getAuthCtx(), ticket, activityId);
                return cruContext;
            }
            return null;
        }
        return null;
    }

    public static void setCRUContextInThreadFromAuthCtxUsage(HttpServletRequest req, AuthCtxUsage authCtxUsage) {
        ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, authCtxUsage, null);
    }

    public static void setCRUContextInThreadFromAuthCtxUsageWithFallback(HttpServletRequest req, AuthCtxUsage authCtxUsage, Function<AuthCtx, ComputeResourceUsageContext> fallback) {
        ComputeResourceUsageContext cruContext = ComputeResourceUsageTicketUtils.buildCRUContextFromAuthCtxUsage(req, authCtxUsage);
        if (cruContext == null && fallback != null) {
            cruContext = fallback.apply(authCtxUsage.getAuthCtx());
        }
        if (cruContext != null) {
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
        }
    }
}

