/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.git.IProjectCommitModeService;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.DSSVersionInfo;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.html.HtmlEscapers;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitDetector
implements SanityCheckDetectorBase {
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsJGitService projectsJGitService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.gitdetector");

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        List<SerializedProject> projects;
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (exclusionList.containsAll(Arrays.stream(Codes.values()).map(InfoMessage.MessageCode::getCode).toList())) {
            return messages;
        }
        try (Transaction t = this.transactionService.beginRead();){
            projects = this.projectsDAO.listAllUnsafe();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to fetch all projects", (Throwable)e);
            messages.addMessage(this.createFatalMessage(e));
            return messages;
        }
        int maxProjectsToDisplay = DKUApp.getParams().getIntParam("dku.sanitycheck.projects.maxNbOfProjectsToDisplay", Integer.valueOf(25));
        this.checkUncommittedChanges(projects, exclusionList, messages, maxProjectsToDisplay);
        this.checkUnmigratedLocalBranches(projects, exclusionList, messages, maxProjectsToDisplay);
        this.checkGitExcludesFile(projects, exclusionList, messages, maxProjectsToDisplay);
        return messages;
    }

    private void checkUncommittedChanges(List<SerializedProject> projects, Set<String> exclusionList, SanityCheckInfoMessages messages, int maxDisplay) {
        if (exclusionList.contains(Codes.WARN_GIT_NO_UNCOMMITTED_CHANGES.getCode())) {
            return;
        }
        ArrayList<Object> projectsWithChanges = new ArrayList<Object>();
        int size = projects.size();
        for (int i = 0; i < size && projectsWithChanges.size() < maxDisplay; ++i) {
            SerializedProject project = projects.get(i);
            if (project.settings.gitCommitMode != IProjectCommitModeService.ProjectCommitMode.AUTO) continue;
            try {
                TaggableObjectsService.TaggableObjectRef projectRef = new TaggableObjectsService.TaggableObjectRef(project.projectKey, ITaggingService.TaggableType.PROJECT, project.projectKey);
                DSSGitModel.ObjectDiff diff = this.projectsJGitService.prepareObjectCommit(projectRef);
                if (diff.diffEntries.isEmpty()) continue;
                projectsWithChanges.add(project.projectKey);
                if (projectsWithChanges.size() < maxDisplay) continue;
                int skipped = size - (i + 1);
                logger.info((Object)("Too many projects with uncommitted changes. Stopping check. Skipped " + skipped));
                projectsWithChanges.add("... (" + skipped + " more)");
                continue;
            }
            catch (IOException e) {
                logger.error((Object)("Error while analyzing uncommitted changes for project '" + project.projectKey + "'"), (Throwable)e);
                messages.addMessage(this.createFatalMessage(e));
            }
        }
        if (!projectsWithChanges.isEmpty()) {
            messages.withHTMLAndExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_GIT_NO_UNCOMMITTED_CHANGES, "<p>Some projects have uncommitted changes. Please commit or discard them to ensure consistency.</p>", "Projects with uncommitted changes", String.format("<pre>%s</pre>", HtmlEscapers.htmlEscaper().escape(String.join((CharSequence)"\n", projectsWithChanges))));
        }
    }

    private void checkUnmigratedLocalBranches(List<SerializedProject> projects, Set<String> exclusionList, SanityCheckInfoMessages messages, int maxDisplay) {
        if (exclusionList.contains(Codes.WARN_GIT_PROJECT_NOT_MIGRATED.getCode())) {
            return;
        }
        LinkedHashMap unmigratedBranches = new LinkedHashMap();
        int size = projects.size();
        for (int i = 0; i < size && unmigratedBranches.size() < maxDisplay; ++i) {
            SerializedProject project = projects.get(i);
            try {
                GitModel.GitBranches branches = this.projectsJGitService.listBranches_NT(project.projectKey);
                for (String localBranch : branches.local) {
                    DSSVersionInfo versionInfo = this.projectsJGitService.getDSSVersionInfo(project.projectKey, localBranch);
                    if (DKUApp.getDSSVersion().product_version.equals(versionInfo.version())) continue;
                    unmigratedBranches.computeIfAbsent(project.projectKey, k -> new ArrayList()).add(localBranch + " (last migrated with DSS " + versionInfo.version() + ")");
                }
                if (unmigratedBranches.size() < maxDisplay) continue;
                int skipped = size - (i + 1);
                logger.info((Object)("Too many projects with unmigrated branches. Stopping check. Skipped " + skipped));
                unmigratedBranches.put("... (" + skipped + " more)", Collections.emptyList());
                continue;
            }
            catch (IOException | GitAPIException e) {
                logger.error((Object)("Error while analyzing local branches for project '" + project.projectKey + "'"), e);
                messages.addMessage(this.createFatalMessage(e));
            }
        }
        if (!unmigratedBranches.isEmpty()) {
            List<String> formattedOutput = unmigratedBranches.entrySet().stream().map(entry -> ((List)entry.getValue()).isEmpty() ? (String)entry.getKey() : (String)entry.getKey() + ":\n  - " + String.join((CharSequence)"\n  - ", (Iterable)entry.getValue())).toList();
            messages.withHTMLAndExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_GIT_PROJECT_NOT_MIGRATED, "<p>Some projects contain local Git branches that were last migrated with an earlier DSS version. Please check out each branch and migrate it from the Version Control page.</p>", "Projects with unmigrated branches", String.format("<pre>%s</pre>", HtmlEscapers.htmlEscaper().escape(String.join((CharSequence)"\n", formattedOutput))));
        }
    }

    private void checkGitExcludesFile(List<SerializedProject> projects, Set<String> exclusionList, SanityCheckInfoMessages messages, int maxDisplay) {
        if (exclusionList.contains(Codes.WARN_GIT_EXCLUDES_FILE_NOT_SET.getCode())) {
            return;
        }
        File baseFolder = DKUApp.getBaseFolderF();
        String expectedExcludesFilePath = DKUFileUtils.getWithin((File)baseFolder, (String[])new String[]{"config", ".dku-projects-gitignore"}).getAbsolutePath();
        ArrayList<Object> projectsWithInvalidExcludes = new ArrayList<Object>();
        int size = projects.size();
        for (int i = 0; i < size && projectsWithInvalidExcludes.size() < maxDisplay; ++i) {
            SerializedProject project = projects.get(i);
            try {
                File gitConfig = DKUFileUtils.getWithin((File)baseFolder, (String[])new String[]{"config", "projects", project.projectKey, ".git", "config"});
                if (!gitConfig.exists()) continue;
                FileBasedConfig config = new FileBasedConfig(gitConfig, FS.detect());
                config.load();
                String configuredPath = config.getString("core", null, "excludesFile");
                if (configuredPath != null && new File(configuredPath).getAbsolutePath().equals(expectedExcludesFilePath)) continue;
                projectsWithInvalidExcludes.add(project.projectKey);
                if (projectsWithInvalidExcludes.size() < maxDisplay) continue;
                int skipped = size - (i + 1);
                logger.info((Object)("Too many projects with incorrect excludesFile. Stopping check. Skipped " + skipped));
                projectsWithInvalidExcludes.add("... (" + skipped + " more)");
                continue;
            }
            catch (IOException | ConfigInvalidException e) {
                logger.error((Object)("Error reading Git config for project '" + project.projectKey + "'"), e);
                messages.addMessage(this.createFatalMessage(e));
            }
        }
        if (!projectsWithInvalidExcludes.isEmpty()) {
            messages.withHTMLAndExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_GIT_EXCLUDES_FILE_NOT_SET, "<p>Some projects have a misconfigured Git <code>excludesFile</code>. This may cause unwanted files to be tracked or committed.</p><p>Expected configuration:</p><pre>[core]\nexcludesFile = $DSS_HOME/config/.dku-projects-gitignore</pre>", "Projects with incorrect excludesFile", String.format("<pre>%s</pre>", HtmlEscapers.htmlEscaper().escape(String.join((CharSequence)"\n", projectsWithInvalidExcludes))));
        }
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_GIT_NO_UNCOMMITTED_CHANGES("GIT - Uncommitted changes detected", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_GIT_PROJECT_NOT_MIGRATED("GIT - Unmigrated project branches detected", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_GIT_EXCLUDES_FILE_NOT_SET("GIT - Missing or incorrect excludesFile setting", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

