/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ModelVersionDeletedEvent;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.LockablePythonLogsService;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StringTransmogrifier;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGenAISavedModelService {
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected SavedModelsDAO savedModelsDAO;
    @Autowired
    protected SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    protected PubSubService pubSub;
    @Autowired
    protected LockablePythonLogsService pythonLogsService;
    @Autowired
    private FlowZonesService flowZonesService;
    private static final String DEFAULT_QUICKTEST_QUERY = "{\n  \"messages\": [\n    {\n      \"role\": \"user\",\n      \"content\": \"Put your query here\"\n    }\n  ],\n  \"context\": {}\n}";

    public void setVersionActive(SavedModel sm, String versionId) throws Exception {
        boolean changed;
        boolean bl = changed = sm.activeVersion == null || !StringUtils.equals((String)sm.activeVersion, (String)versionId);
        if (changed) {
            if (StringUtils.isBlank((String)versionId)) {
                throw ErrorContext.iaef((String)"The new active version to set (%s) is not valid", (Object)versionId, (Object[])new Object[0]);
            }
            if (sm.getVersion(versionId).isEmpty()) {
                throw new IllegalArgumentException("Can't find model version: " + versionId);
            }
            sm.activeVersion = versionId;
            this.savedModelsCRUDService.save(sm, false, false);
        }
    }

    public void deleteVersion(SavedModel sm, String versionId) throws Exception {
        if (StringUtils.equals((String)sm.activeVersion, (String)versionId)) {
            throw new IllegalArgumentException("Cannot delete the active version");
        }
        int nbVersions = sm.inlineVersions.size();
        List<SavedModel.SavedModelInlineVersion> filteredVersions = sm.inlineVersions.stream().filter(version -> versionId != null && !versionId.equals(version.versionId)).toList();
        if (filteredVersions.size() == nbVersions) {
            throw new IllegalArgumentException("Can't find model version: " + versionId);
        }
        sm.inlineVersions = filteredVersions;
        this.savedModelsCRUDService.save(sm, false, false);
        this.pubSub.publishAfterTransaction((DSSEvent)new ModelVersionDeletedEvent(new FullModelId(sm.getProjectKey(), sm.getId(), versionId).toString()));
    }

    public FullModelId duplicateVersion(AuthCtx authCtx, SavedModel sm, String versionIdToCopy, String newVersionId) throws Exception {
        SavedModel.SavedModelInlineVersion targetVersion = sm.getVersion(versionIdToCopy).orElseThrow(() -> new IllegalArgumentException("Can't find model version: " + versionIdToCopy));
        newVersionId = this.generateUniqueVersionId(sm, newVersionId);
        SavedModel.SavedModelInlineVersion duplicatedVersion = new SavedModel.SavedModelInlineVersion(targetVersion);
        duplicatedVersion.versionId = newVersionId;
        duplicatedVersion.versionTag = duplicatedVersion.creationTag = new VersionTag(authCtx.getIdentifier());
        if (duplicatedVersion.quickTestQueryStr == null) {
            duplicatedVersion.quickTestQueryStr = DEFAULT_QUICKTEST_QUERY;
        }
        sm.inlineVersions.add(duplicatedVersion);
        this.savedModelsCRUDService.save(sm, true, false);
        return new FullModelId(sm.projectKey, sm.id, newVersionId);
    }

    public FullModelId createVersion(AuthCtx authCtx, SavedModel sm, String versionId, SavedModel.SavedModelInlineVersion smiv, String type) throws Exception {
        smiv.versionId = versionId = this.generateUniqueVersionId(sm, versionId);
        smiv.creationTag = new VersionTag(authCtx.getIdentifier());
        smiv.versionTag = new VersionTag(authCtx.getIdentifier());
        if (smiv.quickTestQueryStr == null || StringUtils.isBlank((String)smiv.quickTestQueryStr)) {
            smiv.quickTestQueryStr = DEFAULT_QUICKTEST_QUERY;
        }
        sm.inlineVersions.add(smiv);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) == null) {
                throw new IllegalArgumentException(String.format("%s %s does not exist", type, sm.id));
            }
            if (sm.inlineVersions.size() == 1) {
                sm.activeVersion = smiv.versionId;
            }
            this.savedModelsCRUDService.save(sm, false, false);
            t.commit(String.format("Added %s version: %s / %s", type, sm.id, smiv.versionId));
        }
        return new FullModelId(sm.projectKey, sm.id, smiv.versionId);
    }

    private String generateUniqueVersionId(SavedModel sm, String suggestedId) {
        StringTransmogrifier transmogrifier = new StringTransmogrifier("_");
        List<String> usedIds = sm.inlineVersions.stream().map(version -> version.versionId).toList();
        transmogrifier.addAllAlreadyTransmogrifiedAcceptDupes(usedIds);
        return transmogrifier.transmogrify(suggestedId);
    }

    protected SavedModel initialiseSavedModelNoVersion(AuthCtx authCtx, String projectKey, String name, SavedModel.SavedModelType type) throws Exception {
        SavedModel sm = new SavedModel();
        sm.projectKey = projectKey;
        sm.id = SecretKeyGenerator.generate((int)8);
        sm.name = name;
        sm.savedModelType = type;
        File targetSMFolder = MLPaths.savedModelBaseFolder(sm.projectKey, sm.id);
        DKUFileUtils.mkdirs((File)targetSMFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(targetSMFolder);
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, targetSMFolder);
        return sm;
    }

    protected SavedModel.SavedModelInlineVersion addFirstVersion(AuthCtx authCtx, SavedModel sm) {
        SavedModel.SavedModelInlineVersion smiv = new SavedModel.SavedModelInlineVersion();
        smiv.versionId = "v1";
        smiv.creationTag = new VersionTag(authCtx.getIdentifier());
        smiv.versionTag = new VersionTag(authCtx.getIdentifier());
        smiv.quickTestQueryStr = DEFAULT_QUICKTEST_QUERY;
        sm.inlineVersions.add(smiv);
        sm.activeVersion = smiv.versionId;
        return smiv;
    }

    protected void saveNewModel(AuthCtx authCtx, String projectKey, String name, String zoneId, SavedModel sm, String type) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) != null) {
                throw new IllegalArgumentException(String.format("%s %s already exists", type, sm.id));
            }
            this.savedModelsCRUDService.save(sm, true, false);
            if (StringUtils.isNotBlank((String)zoneId)) {
                this.flowZonesService.attachObjectToZone(zoneId, projectKey, sm, true);
            }
            t.commit(String.format("Created %s: %s: %s", type, name, sm.id));
        }
    }

    public List<LogsService.LogDesc> listLogs(String projectKey, String smId, String versionId) throws IOException {
        File logsDir = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs"});
        return this.pythonLogsService.listLogs(logsDir);
    }

    public SmartLogTail getLog(String projectKey, String smId, String versionId, String logName) throws IOException {
        File logFile = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs", logName});
        return this.pythonLogsService.getLog(logFile);
    }

    public void deleteLog(String projectKey, String smId, String versionId, String logName) throws IOException {
        File logFile = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs", logName});
        this.pythonLogsService.deleteLog(logFile);
    }

    public void clearLogs(String projectKey, String smId, String versionId) throws IOException {
        File logDir = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs"});
        this.pythonLogsService.clearLogs(logDir);
    }

    public void streamLog(String projectKey, String smId, String versionId, String logName, OutputStream os) throws IOException {
        File logFile = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs", logName});
        this.pythonLogsService.streamLog(logFile, os);
    }
}

