/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.llm.AgentDiagnosisService;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.savedmodels.AbstractGenAISavedModelService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SavedModelsAgentsService
extends AbstractGenAISavedModelService {
    @Autowired
    private DSSInternalCodeEnvsService dssInternalCodeEnvsService;
    @Autowired
    private AgentDiagnosisService agentDiagnosisService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private static final String TYPE = "Agent";
    static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.service");

    public SavedModel createAgent(AuthCtx authCtx, String projectKey, SavedModel.SavedModelType type, String name, String zoneId) throws Exception {
        SavedModel sm = this.initialiseSavedModelNoVersion(authCtx, projectKey, name, type);
        this.saveNewModel(authCtx, projectKey, name, zoneId, sm, TYPE);
        return sm;
    }

    public FullModelId createVersion(AuthCtx authCtx, SavedModel sm, String versionId, SavedModel.SavedModelInlineVersion smiv) throws Exception {
        this.checkSafeCodeForPythonBlocks(authCtx, sm);
        if (smiv != null && this.hasPythonCodeBlocks(smiv.toolsUsingAgentSettings)) {
            authCtx.failIfNoSafeCode("write Python code blocks in agents");
        }
        if (sm.savedModelType == SavedModel.SavedModelType.PLUGIN_AGENT) {
            throw new IllegalArgumentException("Plugin agents do not support versioning");
        }
        if (sm.savedModelType == SavedModel.SavedModelType.PYTHON_AGENT && smiv.pythonAgentSettings != null && smiv.pythonAgentSettings.codeEnvSelection != null && smiv.pythonAgentSettings.codeEnvSelection.envName == null) {
            String defaultEnvName = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.getDefaultRetrievableKnowledgeCodeEnv();
            if (!DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.RAG_CODE_ENV).equals(defaultEnvName) || this.dssInternalCodeEnvsService.getCodeEnv_NT(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.RAG_CODE_ENV).isPresent()) {
                smiv.pythonAgentSettings.codeEnvSelection = CodeEnvSelection.explicitEnv(defaultEnvName);
            }
        }
        return super.createVersion(authCtx, sm, versionId, smiv, TYPE);
    }

    public SavedModel createPluginAgentAndVersion(AuthCtx authCtx, String projectKey, String pluginAgentType, String name, String zoneId) throws Exception {
        SavedModel sm = this.initialiseSavedModelNoVersion(authCtx, projectKey, name, SavedModel.SavedModelType.PLUGIN_AGENT);
        SavedModel.SavedModelInlineVersion smiv = this.addFirstVersion(authCtx, sm);
        smiv.pluginAgentType = pluginAgentType;
        smiv.pluginAgentConfig = new JsonObject();
        this.saveNewModel(authCtx, projectKey, name, zoneId, sm, TYPE);
        return sm;
    }

    public SavedModel createToolsUsingAgentAndVersion(AuthCtx authCtx, String projectKey, String name, SavedModel.ToolsUsingAgentMode mode, String zoneId) throws Exception {
        GeneralSettingsDAO.GeneralSettings generalSettings;
        SavedModel sm = this.initialiseSavedModelNoVersion(authCtx, projectKey, name, SavedModel.SavedModelType.TOOLS_USING_AGENT);
        SavedModel.SavedModelInlineVersion smiv = this.addFirstVersion(authCtx, sm);
        smiv.toolsUsingAgentSettings.mode = mode;
        if (mode == SavedModel.ToolsUsingAgentMode.BLOCKS_GRAPH) {
            smiv.toolsUsingAgentSettings.shortTermMemoryEnabled = true;
        } else if (mode == SavedModel.ToolsUsingAgentMode.SIMPLE && (generalSettings = this.generalSettingsDAO.getUnsafeAutoTXN()) != null && generalSettings.generativeAISettings != null && generalSettings.generativeAISettings.agentDefaultLlmId != null) {
            smiv.toolsUsingAgentSettings.llmId = generalSettings.generativeAISettings.agentDefaultLlmId;
        }
        this.saveNewModel(authCtx, projectKey, name, zoneId, sm, TYPE);
        return sm;
    }

    public SavedModel save(AuthCtx authCtx, SavedModel sm, @Nullable String versionId) throws Exception {
        this.checkSafeCodeForPythonBlocks(authCtx, sm);
        if (versionId != null) {
            SavedModel preExisting = (SavedModel)this.savedModelsDAO.getMandatory(sm.projectKey, sm.id);
            SavedModel.SavedModelInlineVersion preExistingInlineVersion = preExisting.getVersion(versionId).orElseThrow(() -> new IllegalArgumentException("Agent version " + versionId + " does not exist."));
            SavedModel.SavedModelInlineVersion currentInlineVersion = sm.getVersion(versionId).orElseThrow(() -> new IllegalArgumentException("Agent version " + versionId + " does not exist."));
            currentInlineVersion.versionTag = VersionTag.increment(preExistingInlineVersion.versionTag, authCtx.getIdentifier());
            currentInlineVersion.creationTag = (VersionTag)JSON.deepCopy((Object)preExistingInlineVersion.creationTag);
        }
        return this.savedModelsCRUDService.save(sm, false, false);
    }

    @Override
    public FullModelId duplicateVersion(AuthCtx authCtx, SavedModel sm, String versionIdToCopy, String newVersionId) throws Exception {
        this.checkSafeCodeForPythonBlocks(authCtx, sm);
        return super.duplicateVersion(authCtx, sm, versionIdToCopy, newVersionId);
    }

    public String preloadDiagnosis(AuthCtx authCtx, SavedModel savedModel, String versionId, AgentDiagnosisService.DiagnosisPreloadPayload payload) throws IOException {
        return this.agentDiagnosisService.preloadDiagnosis(authCtx, savedModel, versionId, payload);
    }

    private void checkSafeCodeForPythonBlocks(AuthCtx authCtx, SavedModel sm) throws Exception {
        if (sm == null || sm.savedModelType != SavedModel.SavedModelType.TOOLS_USING_AGENT || sm.inlineVersions == null) {
            return;
        }
        for (SavedModel.SavedModelInlineVersion smiv : sm.inlineVersions) {
            if (smiv == null || !this.hasPythonCodeBlocks(smiv.toolsUsingAgentSettings)) continue;
            authCtx.failIfNoSafeCode("write Python code blocks in agents");
        }
    }

    private boolean hasPythonCodeBlocks(SavedModel.ToolsUsingAgentSettings settings) {
        if (settings == null || settings.mode != SavedModel.ToolsUsingAgentMode.BLOCKS_GRAPH || settings.blocks == null) {
            return false;
        }
        for (SavedModel.BlocksGraphBlock block : settings.blocks) {
            if (!(block instanceof SavedModel.PythonCodeBlock)) continue;
            return true;
        }
        return false;
    }

    public void generateDiagnosis(AuthCtx authCtx, SavedModel savedModel, String versionId, String preloadTmpFolderName, OutputStream outputStream) throws IOException {
        this.agentDiagnosisService.generateDiagnosis(authCtx, savedModel, versionId, preloadTmpFolderName, outputStream);
    }

    public String getDiagnosisArchiveName(SavedModel savedModel, String versionId) {
        return this.agentDiagnosisService.getArchiveName(savedModel, versionId);
    }
}

