/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels.agents;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.util.JsonUtils;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CustomAgentDependenciesCollector {
    private static final Map<ParamDesc.Type, ITaggingService.TaggableType> DEFAULT_DEPENDENCIES_MAPPING = ImmutableMap.of((Object)((Object)ParamDesc.Type.DATASET), (Object)((Object)ITaggingService.TaggableType.DATASET), (Object)((Object)ParamDesc.Type.DATASETS), (Object)((Object)ITaggingService.TaggableType.DATASET), (Object)((Object)ParamDesc.Type.MANAGED_FOLDER), (Object)((Object)ITaggingService.TaggableType.MANAGED_FOLDER), (Object)((Object)ParamDesc.Type.SAVED_MODEL), (Object)((Object)ITaggingService.TaggableType.SAVED_MODEL), (Object)((Object)ParamDesc.Type.KNOWLEDGE_BANK), (Object)((Object)ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE));

    public static Map<String, LLMStructuredRef> collectLlmDependencies(List<ParamDesc> params, JsonObject pluginConfig) {
        HashMap<String, LLMStructuredRef> ret = new HashMap<String, LLMStructuredRef>();
        if (params == null || pluginConfig == null) {
            return ret;
        }
        for (ParamDesc param : params) {
            LLMStructuredRef llmRef;
            JsonElement llmJsonParam;
            if (param == null || param.type != ParamDesc.Type.LLM || (llmJsonParam = JsonUtils.getOrNull((JsonElement)pluginConfig, param.name)) == null || (llmRef = CustomAgentDependenciesCollector.parseLLMRefOrNull(llmJsonParam)) == null) continue;
            ret.put(param.name, llmRef);
        }
        return ret;
    }

    public static List<SavedModel.AgentDependency> collect(List<ParamDesc> params, JsonObject pluginConfig) {
        ArrayList<SavedModel.AgentDependency> ret = new ArrayList<SavedModel.AgentDependency>();
        if (params == null || pluginConfig == null) {
            return ret;
        }
        for (ParamDesc param : params) {
            ITaggingService.TaggableType taggableType;
            JsonElement jsonParam;
            if (param == null || param.agentDependency == null || !param.agentDependency.booleanValue() || (jsonParam = JsonUtils.getOrNull((JsonElement)pluginConfig, param.name)) == null) continue;
            if (param.type == ParamDesc.Type.LLM) {
                LLMStructuredRef llmRef = CustomAgentDependenciesCollector.parseLLMRefOrNull(jsonParam);
                if (llmRef == null || llmRef.savedModelSmartId == null) continue;
                ret.add(new SavedModel.AgentDependency(ITaggingService.TaggableType.SAVED_MODEL, llmRef.savedModelSmartId));
                continue;
            }
            List<String> values = CustomAgentDependenciesCollector.parseParamValues(jsonParam);
            if (values.isEmpty() || (taggableType = DEFAULT_DEPENDENCIES_MAPPING.get((Object)param.type)) == null) continue;
            for (String value : values) {
                ret.add(new SavedModel.AgentDependency(taggableType, value));
            }
        }
        return ret;
    }

    private static LLMStructuredRef parseLLMRefOrNull(JsonElement jsonElement) {
        String llmId = jsonElement.getAsString();
        if (StringUtils.isNotBlank((String)llmId)) {
            return LLMStructuredRef.decodeId(llmId);
        }
        return null;
    }

    private static List<String> parseParamValues(JsonElement jsonParam) {
        ArrayList<String> values = new ArrayList<String>();
        if (jsonParam.isJsonArray()) {
            for (JsonElement jsonElement : jsonParam.getAsJsonArray()) {
                CustomAgentDependenciesCollector.addValueAsStringIfNotBlank(values, jsonElement);
            }
        } else {
            CustomAgentDependenciesCollector.addValueAsStringIfNotBlank(values, jsonParam);
        }
        return values;
    }

    private static void addValueAsStringIfNotBlank(List<String> values, JsonElement jsonElement) {
        String valueAsString = jsonElement.getAsString();
        if (StringUtils.isNotBlank((String)valueAsString)) {
            values.add(valueAsString);
        }
    }
}

