/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.reports;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.scheduler.reports.DistillationUnit;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class MessageLookupBuilder {
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private VariablesService variablesService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.scenarios.lookup");

    public MessageLookupBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public VariableLookup buildForVariablesStep(ScenarioRun scenarioRun) throws Exception {
        ReportItem.Outcome outcome;
        Scenario scenario = scenarioRun.getScenario();
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
        VariablesContext variablesContext = this.variablesService.getForProject(scenario.getProjectKey());
        VariableLookup lookup = new VariableLookup();
        lookup.setVariablesContext(variablesContext);
        Map<String, Object> stepRunOutputs = scenarioRun.getStepRunOutputs();
        List<StepRun> stepRuns = this.scenariosService.getStepRunsOfRun(scenarioRun);
        this.addStepVariables(lookup, stepRunOutputs, stepRuns);
        lookup.addVariable("projectKey", scenario.getProjectKey());
        if (StringUtils.isNotBlank((String)generalSettings.studioExternalUrl)) {
            lookup.addVariable("dssURL", generalSettings.studioExternalUrl);
            lookup.addVariable("scenarioRunURL", generalSettings.studioExternalUrl + "/projects/" + scenario.getProjectKey() + "/scenarios/" + scenario.getId() + "/runs/list/" + scenarioRun.getRunId());
        }
        lookup.addVariable("outcome", (outcome = scenarioRun.getCurrentOutcome()) == null ? "N/A" : outcome.name());
        return lookup;
    }

    private void addStepVariables(VariableLookup lookup, Map<String, Object> stepRunOutputs, List<StepRun> stepRuns) {
        HashMap stepResults = Maps.newHashMap();
        HashMap stepOutcomes = Maps.newHashMap();
        for (StepRun previousStepRun : stepRuns) {
            if (StringUtils.isBlank((String)previousStepRun.getStep().getName())) continue;
            if (stepRunOutputs.containsKey(previousStepRun.getRunId())) {
                lookup.addVariable("stepOutput_" + previousStepRun.getStep().getName(), stepRunOutputs.get(previousStepRun.getRunId()));
            }
            if (previousStepRun.getResult() == null) continue;
            stepResults.put(previousStepRun.getStep().getName(), previousStepRun.getResult());
            lookup.addVariable("stepResult_" + previousStepRun.getStep().getName(), previousStepRun.getResult());
            if (previousStepRun.getResult().getOutcome() == null) continue;
            stepOutcomes.put(previousStepRun.getStep().getName(), previousStepRun.getResult().getOutcome().name());
            lookup.addVariable("stepOutcome_" + previousStepRun.getStep().getName(), previousStepRun.getResult().getOutcome().name());
        }
        lookup.addVariable("stepResults", stepResults);
        lookup.addVariable("stepOutcomes", stepOutcomes);
    }

    public VariableLookup build(String projectKey, List<DistillationUnit> distillationUnits, Scenario scenario, ScenarioRun scenarioRun) throws Exception {
        List<StepRun> stepRuns;
        VariablesContext variablesContext;
        GeneralSettingsDAO.GeneralSettings generalSettings;
        try (Transaction t = this.transactionService.beginRead();){
            generalSettings = this.generalSettingsDAO.read();
            variablesContext = this.variablesService.getForProject(projectKey);
            stepRuns = this.scenariosService.getStepRunsOfRun(scenarioRun);
        }
        VariableLookup lookup = new VariableLookup();
        lookup.setVariablesContext(variablesContext);
        Scenario runScenario = scenarioRun.getScenario();
        if (runScenario != null) {
            List<ScenarioReporter> reporters = runScenario.reporters;
            runScenario.reporters = Lists.newArrayList();
            lookup.addVariable("_rawScenarioRun", scenarioRun);
            runScenario.reporters = reporters;
        } else {
            lookup.addVariable("_rawScenarioRun", scenarioRun);
        }
        for (StepRun stepRun : stepRuns) {
            stepRun.withScenarioRun(null);
        }
        lookup.addVariable("_fullStepRuns", stepRuns);
        Map<String, Object> stepRunOutputs = scenarioRun.getStepRunOutputs();
        this.addStepVariables(lookup, stepRunOutputs, stepRuns);
        if (distillationUnits != null) {
            for (DistillationUnit distillationUnit : distillationUnits) {
                distillationUnit.getResult(lookup);
            }
        }
        lookup.addVariable("projectKey", scenario.getProjectKey());
        if (StringUtils.isNotBlank((String)generalSettings.studioExternalUrl)) {
            lookup.addVariable("dssURL", generalSettings.studioExternalUrl);
            lookup.addVariable("scenarioRunURL", generalSettings.studioExternalUrl + "/projects/" + scenario.getProjectKey() + "/scenarios/" + scenario.getId() + "/runs/list/" + scenarioRun.getRunId());
        }
        if (scenarioRun != null) {
            ReportItem.Outcome outcome = scenarioRun.getCurrentOutcome();
            lookup.addVariable("outcome", outcome == null ? "N/A" : outcome.name());
        }
        return lookup;
    }
}

