/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AbstractImpersonableSecretProtectedPythonKernel;
import com.dataiku.dip.io.BasicKernelLink;
import com.dataiku.dip.scheduler.runnables.AbstractPythonDSSRunnable;
import com.dataiku.dip.scheduler.runnables.CustomPythonRunnablesService;
import com.dataiku.dip.scheduler.runnables.DSSRunnableDesc;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.scheduler.runnables.ImpersonablePythonDSSRunnableKernel;
import com.dataiku.dip.scheduler.runnables.LoadedPythonRunnable;
import com.dataiku.dip.scheduler.runnables.PythonRunnableDesc;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class PythonDSSRunnable
extends AbstractPythonDSSRunnable {
    private final JsonObject config;
    @Autowired
    private CustomPythonRunnablesService customPythonRunnablesService;
    private static Logger logger = Logger.getLogger((String)"dip.runnables.python.regular");

    public PythonDSSRunnable(AuthCtx authCtx, String projectKey, LoadedPythonRunnable loaded, JsonObject config) {
        super(authCtx, projectKey, loaded);
        this.config = config;
    }

    @Override
    protected String getCode() throws IOException {
        return this.customPythonRunnablesService.getCode(this.loaded.runnableType);
    }

    @Override
    protected AbstractImpersonableSecretProtectedPythonKernel<BasicKernelLink> getKernel(BasicKernelLink link, APITicketService.Ticket ticket, File tmpDir) throws IOException {
        String resourceFolderPath = this.customPythonRunnablesService.getResourceFolder(this.loaded.runnableType);
        String pythonlibFolderPath = this.customPythonRunnablesService.getLibFolder(this.loaded.runnableType);
        String envName = new CodeEnvSelector().getCodeEnvNameForPlugin(this.loaded.ownerPluginId);
        return new ImpersonablePythonDSSRunnableKernel(link, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_MACRO, ticket, resourceFolderPath, pythonlibFolderPath, tmpDir, ((PythonRunnableDesc)this.loaded.desc).impersonate, this.projectKey, this.authCtx, envName);
    }

    @Override
    protected PluginSettingsResolver.ResolvedSettings getResolvedSettings() throws IOException, DKUSecurityException {
        return this.customPythonRunnablesService.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
    }

    @Override
    public DSSRunnableResult run(File contextDir, APITicketService.Ticket ticket) throws Exception {
        String label = this.loaded.runnableType;
        if (((PythonRunnableDesc)this.loaded.desc).meta != null && StringUtils.isNotBlank((String)((PythonRunnableDesc)this.loaded.desc).meta.label)) {
            label = ((PythonRunnableDesc)this.loaded.desc).meta.label;
        }
        if (!this.authCtx.isAdmin()) {
            this.forceAdminParamsToDefault(this.config, (DSSRunnableDesc)this.loaded.desc);
        }
        logger.info((Object)("Running the macro : " + label));
        return super.run(contextDir, ticket);
    }
}

