/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvPermissionsService;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.integrations.AttachmentService;
import com.dataiku.dip.integrations.mail.MailIntegrationHandler;
import com.dataiku.dip.integrations.mail.MailIntegrationParams;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableConnection;
import com.dataiku.dip.recipes.SelectableCodeEnvContainer;
import com.dataiku.dip.recipes.SelectableConnectionContainer;
import com.dataiku.dip.scheduler.reports.MessageLookupBuilder;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioMeta;
import com.dataiku.dip.scheduler.scenarios.ScenarioParams;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunner;
import com.dataiku.dip.scheduler.steps.CustomPythonStepRunner;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRegistry;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StepBasedScenarioRunner
implements ScenarioRunner {
    public static final ScenarioMeta META = new ScenarioMeta(){

        @Override
        public String getType() {
            return "step_based";
        }

        @Override
        public Class<? extends ScenarioParams> paramsClass() {
            return StepBasedScenarioParams.class;
        }

        @Override
        public ScenarioRunner buildRunner(Scenario scenario) {
            return new StepBasedScenarioRunner(scenario, scenario.getParamsAs(StepBasedScenarioParams.class));
        }

        @Override
        public void checkSaveSecurity(Scenario scenario, Scenario oldScenario, CodeEnvPermissionsService permissionsService, AuthCtx authCtx) throws DKUSecurityException {
            HashSet forbiddenMeta = Sets.newHashSet((Object[])new StepMeta[]{CustomPythonStepRunner.META});
            for (Step step : scenario.getParamsAs(StepBasedScenarioParams.class).getSteps()) {
                StepMeta meta = StepRegistry.getMeta(step);
                if (!forbiddenMeta.contains(meta)) continue;
                authCtx.failIfNoSafeCode("save a code-based scenario");
            }
            for (Step step : scenario.getParamsAs(StepBasedScenarioParams.class).getSteps()) {
                permissionsService.failIfCodeEnvNotUsable(scenario.getProjectKey(), StepRegistry.getMeta(step.getType()), step.getParams(), null, authCtx);
            }
        }

        @Override
        public Scenario prepareForSave(Scenario scenario) {
            StepBasedScenarioParams params = scenario.getParamsAs(StepBasedScenarioParams.class);
            if (params != null) {
                HashSet stepIds = Sets.newHashSet();
                for (Step step : params.steps) {
                    if (!StringUtils.isNotBlank((String)step.getId())) continue;
                    stepIds.add(step.getId());
                }
                StringTransmogrifier transmogrifier = new StringTransmogrifier();
                for (String stepId : stepIds) {
                    transmogrifier.addAlreadyTransmogrified(stepId);
                }
                for (Step step : params.steps) {
                    StepMeta stepMeta = StepRegistry.getMeta(step);
                    if (StringUtils.isBlank((String)step.getId())) {
                        String builtId = stepMeta.buildId(step);
                        step = step.withId(transmogrifier.transmogrify(builtId));
                    }
                    if (StringUtils.isBlank((String)step.getName())) {
                        step = step.withName(stepMeta.buildName(step));
                    }
                    PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
                    GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
                    stepMeta.prepareForSave(step, cryptoService, gs.security);
                }
            }
            return scenario;
        }

        @Override
        public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
            ArrayList components = Lists.newArrayList();
            if (object instanceof Scenario) {
                Scenario scenario = (Scenario)object;
                for (Trigger trigger : scenario.getTriggers()) {
                    components.add(new IPluginifiedHolderMeta.Pluginifiable("trigger", trigger.getType(), trigger));
                }
                for (ScenarioReporter reporter : scenario.getReporters()) {
                    if (!MailIntegrationHandler.SCENARIO_META.getType().equals(reporter.messaging.type)) continue;
                    MailIntegrationParams.MailScenarioIntegrationParams params = (MailIntegrationParams.MailScenarioIntegrationParams)reporter.messaging.configuration;
                    for (AttachmentService.MailScenarioAttachment attachment : params.attachments) {
                        if (attachment.type != AttachmentService.AttachmentType.DATASET) continue;
                        AttachmentService.DatasetExportAttachment exportAttachment = (AttachmentService.DatasetExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), AttachmentService.DatasetExportAttachment.class);
                        PluginUsagesInspector.addExporterComponentToList(components, exportAttachment.exportParams);
                    }
                }
                for (Step step : scenario.getParamsAs(StepBasedScenarioParams.class).getSteps()) {
                    components.add(new IPluginifiedHolderMeta.Pluginifiable("step", step.getType(), step));
                }
            }
            return components;
        }
    };
    private final StepBasedScenarioParams params;
    private final Scenario scenario;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.stepbased");

    StepBasedScenarioRunner(Scenario scenario, StepBasedScenarioParams params) {
        this.scenario = scenario;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ScenarioRun scenarioRun) throws Exception {
        logger.info((Object)("Start scenario " + this.scenario.name));
        ReportItem.ScenarioDone reportItem = (ReportItem.ScenarioDone)new ReportItem.ScenarioDone(new ReportTargetItem.ScenarioItem(this.scenario.getProjectKey(), this.scenario.getId())).withLogin(scenarioRun.getRunAsUser().getIdentifier()).withStart(DateTime.now().getMillis());
        ReportItem.Outcome outcome = ReportItem.Outcome.SUCCESS;
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Running steps", (double)this.params.getSteps().size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            List<Step> steps = this.params.getSteps();
            block16: for (int stepIndex = 0; stepIndex < steps.size(); ++stepIndex) {
                Step step = steps.get(stepIndex);
                state.set((double)stepIndex);
                scenarioRun.withCurrentOutcome(outcome);
                if (!this.shouldStepRun(scenarioRun, step)) {
                    logger.info((Object)("Step " + step.id + " disabled by its run condition"));
                    continue;
                }
                if (step.resetsScenarioStatus()) {
                    logger.info((Object)"Scenario run status reset to SUCCESS");
                    outcome = ReportItem.Outcome.SUCCESS;
                }
                block17: for (int remainingStepRetries = step.getMaxRetriesOnFail(); remainingStepRetries >= 0; --remainingStepRetries) {
                    StepRun stepRun = this.scenariosService.runStep(this.scenario, scenarioRun, step, remainingStepRetries);
                    switch (stepRun.getResult().getOutcome()) {
                        case SUCCESS: {
                            continue block16;
                        }
                        case WARNING: {
                            if (outcome == ReportItem.Outcome.ABORTED || outcome == ReportItem.Outcome.FAILED) continue block16;
                            outcome = ReportItem.Outcome.WARNING;
                            continue block16;
                        }
                        case ABORTED: {
                            outcome = ReportItem.Outcome.ABORTED;
                            continue block16;
                        }
                        case FAILED: {
                            if (remainingStepRetries <= 0) {
                                if (outcome == ReportItem.Outcome.ABORTED) continue block16;
                                outcome = ReportItem.Outcome.FAILED;
                                continue block16;
                            }
                            MockableThread.sleep(1000 * step.getDelayBetweenRetries());
                        }
                        default: {
                            continue block17;
                        }
                    }
                }
            }
            state.set((double)steps.size());
        }
        catch (InterruptedException ex) {
            outcome = ReportItem.Outcome.ABORTED;
            MockableThread.interrupt();
        }
        finally {
            scenarioRun.withResult(reportItem.withEnd(DateTime.now().getMillis()).withOutcome(outcome));
        }
        logger.info((Object)("Done scenario " + this.scenario.name));
    }

    private boolean shouldStepRun(ScenarioRun scenarioRun, Step step) throws Exception {
        ReportItem.Outcome outcome = scenarioRun.getCurrentOutcome();
        if (!step.enabled) {
            logger.info((Object)"Step disabled");
            return false;
        }
        switch (step.getRunConditionType()) {
            case DISABLED: {
                logger.info((Object)"Step disabled");
                return false;
            }
            case RUN_ALWAYS: {
                logger.info((Object)"Step always run");
                return true;
            }
            case RUN_IF_STATUS_MATCH: {
                logger.info((Object)("Step run if " + String.valueOf((Object)outcome) + " in " + JSON.log(step.getRunConditionStatuses())));
                return step.getRunConditionStatuses().contains((Object)outcome);
            }
            case RUN_CONDITIONALLY: {
                logger.info((Object)("Step run if " + step.getRunConditionExpression()));
                if (StringUtils.isBlank((String)step.getRunConditionExpression())) {
                    logger.info((Object)"No run condition expression, assuming false");
                    return false;
                }
                MessageLookupBuilder lookupBuilder = new MessageLookupBuilder();
                VariableLookup lookup = null;
                try (Transaction t = this.transactionService.beginRead();){
                    lookup = lookupBuilder.buildForVariablesStep(scenarioRun);
                }
                lookup.addVariable("outcome", outcome == null ? "N/A" : outcome.name());
                try {
                    String runApproved = lookup.lookupWithSyntaxError(step.getRunConditionExpression());
                    return StringUtils.isNotBlank((String)runApproved) && Boolean.parseBoolean(runApproved);
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to evaluate run condition", (Throwable)e);
                    this.scenariosService.dontRunStep(this.scenario, scenarioRun, step, new Exception("Failed to evaluate run condition", e));
                    return false;
                }
            }
        }
        logger.warn((Object)("Step " + step.id + " has no run condition type, skipping"));
        return false;
    }

    public static class StepBasedScenarioParams
    implements ScenarioParams,
    SelectableCodeEnvContainer,
    SelectableConnectionContainer {
        public List<Step> steps = Lists.newArrayList();

        public List<Step> getSteps() {
            return Lists.newArrayList(this.steps);
        }

        public StepBasedScenarioParams withSteps(List<Step> steps) {
            this.steps = Lists.newArrayList(steps);
            return this;
        }

        public StepBasedScenarioParams withSteps(Step ... steps) {
            this.steps = Lists.newArrayList((Object[])steps);
            return this;
        }

        public void addSteps(Step ... steps) {
            this.steps.addAll(Lists.newArrayList((Object[])steps));
        }

        @Override
        public List<ParamsWithSelectableCodeEnv> collectCodeEnvUsers() {
            ArrayList codeEnvUsers = Lists.newArrayList();
            for (Step step : this.steps) {
                StepParams params = step.getParams();
                if (!(params instanceof ParamsWithSelectableCodeEnv)) continue;
                codeEnvUsers.add((ParamsWithSelectableCodeEnv)((Object)params));
            }
            return codeEnvUsers;
        }

        @Override
        public List<ParamsWithSelectableConnection> collectConnectionUsers() {
            ArrayList connectionUsers = Lists.newArrayList();
            for (Step step : this.steps) {
                StepParams params = step.getParams();
                if (!(params instanceof ParamsWithSelectableConnection)) continue;
                connectionUsers.add((ParamsWithSelectableConnection)((Object)params));
            }
            return connectionUsers;
        }
    }

    static class MockableThread {
        MockableThread() {
        }

        static void sleep(long ms) throws InterruptedException {
            Thread.sleep(ms);
        }

        static void interrupt() {
            Thread.currentThread().interrupt();
        }
    }
}

