/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.kernel.master.BuildUtils;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepParamsWithComputables;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractFlowItemBuildingStepRunner<T extends FlowItemBuildingStepParams>
implements StepRunner {
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected FlowExecutionService2 flowExecutionService;
    @Autowired
    protected ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    protected FlowGraphService graphService;
    protected T params;
    protected Step step;
    protected Scenario scenario;

    protected abstract DKULogger getLogger();

    AbstractFlowItemBuildingStepRunner(Scenario scenario, Step step, T params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    protected JobDef buildJobDef(StepRun stepRun) throws IOException {
        VariablesContext variablesContext = this.variablesService.getForProject(this.scenario.getProjectKey());
        JobDef jobDef = ((FlowItemBuildingStepParams)this.params).buildJobDef(this.scenario.getProjectKey(), variablesContext, this.graphService, this.transactionService);
        this.getLogger().infoV("Build %d flow items", new Object[]{jobDef.outputs.size() + jobDef.reverseStartingPoints.size()});
        this.getLogger().infoV("Built job def: %s", new Object[]{JSON.log((Object)jobDef)});
        jobDef.scenarioRun = stepRun.getScenarioRun();
        jobDef.stepRun = stepRun;
        jobDef.initiationTimestamp = System.currentTimeMillis();
        jobDef.initiator = stepRun.getScenarioRun().getRunAsUser().getIdentifier();
        return jobDef;
    }

    protected ReportItem.StepDone updateStepReportItemWithJobResult(ReportItem.StepDone stepReportItem, ReportItem.JobExecuted jobItem) {
        if (jobItem.getOutcome() == ReportItem.Outcome.WARNING) {
            stepReportItem.withOutcome(((FlowItemBuildingStepParams)this.params).handleWarningsAs);
        } else {
            stepReportItem.withOutcome(jobItem.getOutcome());
        }
        stepReportItem.withWarnings(jobItem.getWarnings());
        return stepReportItem;
    }

    protected EnhancedSerializedJobStatus getSafeJobStatus(EnhancedSerializedJobStatus esjs) {
        if (esjs != null) {
            esjs.stepRun = null;
            if (esjs.baseStatus != null && esjs.baseStatus.def != null) {
                esjs.baseStatus.def.stepRun = null;
                esjs.baseStatus.def.scenarioRun = null;
            }
        }
        return esjs;
    }

    protected BuildJobInfo runBuildJob(JobDef jobDef) throws Exception {
        EnhancedSerializedJobStatus esjs;
        String jobId;
        this.getLogger().infoV("Starting build job %s", new Object[]{jobDef.id});
        try (Transaction t = this.transactionService.beginRead();){
            jobId = this.flowExecutionService.startJob(jobDef, jobDef.stepRun.getScenarioRun().getRunAsUser());
        }
        ReportItem.JobExecuted jobItem = (ReportItem.JobExecuted)new ReportItem.JobExecuted(jobId).withStart(DateTime.now().getMillis());
        this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(jobDef.projectKey, jobDef.id), null, null, jobDef.stepRun.getScenarioRun(), jobDef.stepRun, jobItem);
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook(() -> this.flowExecutionService.abort_NT(jobDef.stepRun.getScenarioRun().getRunAsUser(), this.scenario.getProjectKey(), jobId));){
            esjs = this.flowExecutionService.waitUntilFinished_NT(jobDef.projectKey, jobId);
            this.flowExecutionService.addInitiator(esjs);
        }
        WarningsContext.SerializedWarnings allWarningCounts = new WarningsContext.SerializedWarnings();
        for (SerializedJobActivityStatus sjas : esjs.baseStatus.activities.values()) {
            if (sjas.warnings == null) continue;
            allWarningCounts.mergeCountsFrom(sjas.warnings);
        }
        if (esjs != null && esjs.baseStatus != null) {
            if (esjs.baseStatus.state == JobState.DONE) {
                if (allWarningCounts.totalCount > 0) {
                    jobItem.withOutcome(ReportItem.Outcome.WARNING);
                    jobItem.withWarnings(allWarningCounts);
                } else {
                    jobItem.withOutcome(ReportItem.Outcome.SUCCESS);
                }
            } else if (esjs.baseStatus.state == JobState.FAILED) {
                jobItem.withOutcome(ReportItem.Outcome.FAILED);
                jobItem.withLogTail(esjs.logTail);
                if (CollectionUtils.isNotEmpty(esjs.baseStatus.incompatibilities) && esjs.errorMessage == null) {
                    jobItem.withThrown(new WarningsContext.SerializedThrowable("This job could not be executed because some datasets were already being built."));
                } else {
                    jobItem.withThrown(new WarningsContext.SerializedThrowable(esjs.errorMessage));
                }
            } else if (esjs.baseStatus.state == JobState.ABORTED) {
                jobItem.withOutcome(ReportItem.Outcome.ABORTED);
            }
        }
        jobItem.withEnd(DateTime.now().getMillis());
        this.jobsDatabaseService.tryUpdateFlowObjectEvent(new AnyLoc(jobDef.projectKey, jobItem.jobId), null, null, jobDef.stepRun.getScenarioRun(), jobDef.stepRun, jobItem);
        return new BuildJobInfo(jobItem, esjs);
    }

    public static class FlowItemBuildingStepParams
    extends NonFatalStepParams
    implements StepParams,
    StepParamsWithComputables {
        public List<FlowComputableSpecification> builds = Lists.newArrayList();
        public JobDef.JobType jobType = JobDef.JobType.NON_RECURSIVE_FORCED_BUILD;
        public boolean autoUpdateSchemaBeforeEachRecipeRun = false;
        public boolean stopAtFlowZoneBoundary = false;
        public boolean refreshHiveMetastore = true;
        public ReportItem.Outcome handleWarningsAs = ReportItem.Outcome.WARNING;

        /*
         * Unable to fully structure code
         */
        public JobDef buildJobDef(String scenarioProjectKey, VariablesContext vc, FlowGraphService graphService, TransactionService transactionService) throws IOException {
            jobDef = new JobDef();
            jobDef.initiationTimestamp = System.currentTimeMillis();
            jobDef.projectKey = scenarioProjectKey;
            jobDef.type = this.jobType;
            if (this.isFindOutputCase()) {
                t = transactionService.beginRead();
                try {
                    downstreamComputables = new HashSet<FlowComputable>();
                    for (FlowComputableSpecification dwp : this.builds) {
                        computableLoc = new AnyLoc(dwp.projectKey == null ? scenarioProjectKey : dwp.projectKey, dwp.itemId);
                        downstreamComputables.addAll(graphService.getDownstreamFromComputable(scenarioProjectKey, computableLoc.getSmartName(scenarioProjectKey)));
                    }
                    jobDef.outputs = downstreamComputables.stream().map((Function<FlowComputable, JobDef.JobOutput>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$buildJobDef$0(com.dataiku.dip.dataflow.graph.FlowComputable ), (Lcom/dataiku/dip/dataflow/graph/FlowComputable;)Lcom/dataiku/dip/coremodel/JobDef$JobOutput;)()).collect(Collectors.toList());
                    jobDef.isFindOutputMode = true;
                    if (jobDef.type.equals((Object)JobDef.JobType.FIND_OUTPUTS_RECURSIVE_BUILD)) {
                        jobDef.type = JobDef.JobType.RECURSIVE_BUILD;
                    }
                    if (!jobDef.type.equals((Object)JobDef.JobType.FIND_OUTPUTS_RECURSIVE_FORCED_BUILD)) ** GOTO lbl36
                    jobDef.type = JobDef.JobType.RECURSIVE_FORCED_BUILD;
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            } else if (this.jobType == JobDef.JobType.REVERSE_FORCED_BUILD) {
                for (FlowComputableSpecification dwp : this.builds) {
                    jobDef.reverseStartingPoints.add(dwp.buildReverseStartingPoint(scenarioProjectKey));
                }
            } else {
                for (FlowComputableSpecification dwp : this.builds) {
                    jobDef.outputs.add(dwp.buildOutput(scenarioProjectKey));
                }
            }
lbl36:
            // 5 sources

            jobDef.expandInPlaceOutputsTargetPartition(vc);
            jobDef.triggeredFrom = JobDef.JobTriggerType.SCHEDULER;
            jobDef.autoUpdateSchemaBeforeEachRecipeRun = this.autoUpdateSchemaBeforeEachRecipeRun;
            if (this.jobType == JobDef.JobType.RECURSIVE_BUILD || this.jobType == JobDef.JobType.RECURSIVE_FORCED_BUILD || this.isFindOutputCase()) {
                jobDef.stopAtFlowZoneBoundary = this.stopAtFlowZoneBoundary;
            }
            jobDef.refreshHiveMetastore = this.refreshHiveMetastore;
            t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();
            try {
                BuildUtils.prepareJobDef("Scenario build", jobDef);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            return jobDef;
        }

        public JobDef.JobType getJobType() {
            return this.jobType;
        }

        public List<FlowComputableSpecification> getBuilds() {
            return Lists.newArrayList(this.builds);
        }

        private boolean isFindOutputCase() {
            return this.jobType.equals((Object)JobDef.JobType.FIND_OUTPUTS_RECURSIVE_BUILD) || this.jobType.equals((Object)JobDef.JobType.FIND_OUTPUTS_RECURSIVE_FORCED_BUILD);
        }

        @Override
        public Collection<FlowComputableSpecification> getComputablesSpec() {
            return this.getBuilds();
        }

        private static /* synthetic */ JobDef.JobOutput lambda$buildJobDef$0(FlowComputable e) {
            AnyLoc loc = AnyLoc.resolveFull(e.getFullId());
            return new JobDef.JobOutput(loc.getProjectKey(), loc.getId(), "");
        }

        public static abstract class Builder<T extends FlowItemBuildingStepParams> {
            protected T params = this.instantiateParams();

            protected Builder() {
            }

            protected abstract T instantiateParams();

            public abstract T build();

            public Builder<T> withAutoUpdateSchemaBeforeEachRecipeRun(boolean autoUpdateSchemaBeforeEachRecipeRun) {
                ((FlowItemBuildingStepParams)this.params).autoUpdateSchemaBeforeEachRecipeRun = autoUpdateSchemaBeforeEachRecipeRun;
                return this;
            }

            public Builder<T> withJobType(JobDef.JobType jobType) {
                ((FlowItemBuildingStepParams)this.params).jobType = jobType;
                return this;
            }

            public Builder<T> withRefreshHiveMetastore(boolean refreshHiveMetastore) {
                ((FlowItemBuildingStepParams)this.params).refreshHiveMetastore = refreshHiveMetastore;
                return this;
            }

            public Builder<T> withBuilds(List<FlowComputableSpecification> builds) {
                ((FlowItemBuildingStepParams)this.params).builds = Lists.newArrayList(builds);
                return this;
            }

            public Builder<T> withBuilds(FlowComputableSpecification ... builds) {
                ((FlowItemBuildingStepParams)this.params).builds = Lists.newArrayList((Object[])builds);
                return this;
            }

            public Builder<T> withStopAtFlowZoneBoundary(boolean val) {
                ((FlowItemBuildingStepParams)this.params).stopAtFlowZoneBoundary = val;
                return this;
            }

            public Builder<T> withHandleWarningsAs(ReportItem.Outcome handleWarningsAs) {
                ((FlowItemBuildingStepParams)this.params).handleWarningsAs = handleWarningsAs;
                return this;
            }
        }
    }

    public static class BuildJobInfo {
        public final ReportItem.JobExecuted jobItem;
        public final EnhancedSerializedJobStatus jobStatus;

        public BuildJobInfo(ReportItem.JobExecuted jobItem, EnhancedSerializedJobStatus jobStatus) {
            this.jobItem = jobItem;
            this.jobStatus = jobStatus;
        }
    }
}

