/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.graphicsexport.model.BaseExport;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateBaseExportStepRunner {
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.base.export");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportToManagedFolder(String projectKey, String id, String folderId, BaseExport export, BaseExportService baseExportService, StepRun stepRun, ReportItem reportItem) throws Exception {
        try {
            logger.info((Object)"Start Export");
            File exportFile = baseExportService.exportAndWait((AuthCtx)stepRun.getScenarioRun().getRunAsUser(), export).exportFile;
            logger.info((Object)"Transfer file to managed folder");
            String uploadPath = "/" + exportFile.getName();
            try (FileInputStream fileStream = new FileInputStream(exportFile);){
                this.kernelsManagedFolderService.handleUploadRequest_NT(projectKey, folderId, fileStream, uploadPath, true, stepRun.getScenarioRun().getRunAsUser());
            }
            logger.info((Object)"File successfully exported");
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to export wiki", (Throwable)ex);
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withThrown(ex);
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(projectKey, id), null, null, stepRun.getScenarioRun(), stepRun, reportItem);
            try {
                baseExportService.clean(projectKey, export.exportId);
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to delete temporary export directory.", (Throwable)e);
            }
        }
    }

    public ManagedFolder getManagedFolder(String projectKey, String folderId) throws IOException {
        if (projectKey == null || folderId == null) {
            return null;
        }
        try (Transaction t = this.transactionService.beginRead();){
            ManagedFolder managedFolder = this.managedFoldersService.getOrNull(projectKey, folderId);
            return managedFolder;
        }
    }
}

