/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntimeManager;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.ScenarioCodes;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RestartCodeStudioStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return RestartCodeStudioStepParams.class;
        }

        @Override
        public String getType() {
            return "restart_code_studio";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new RestartCodeStudioStepRunner(scenario, step, step.getParamsAs(RestartCodeStudioStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            RestartCodeStudioStepParams params = step.getParamsAs(RestartCodeStudioStepParams.class);
            return "Restart Code Studio " + params.codeStudioId;
        }

        @Override
        public String buildId(Step step) {
            RestartCodeStudioStepParams stepParams = step.getParamsAs(RestartCodeStudioStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("restart_code_studio");
            if (stepParams != null) {
                sb.append("_");
                sb.append(stepParams.codeStudioId);
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final RestartCodeStudioStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private CodeStudioObjectsService codeStudioObjectsService;
    @Autowired
    private CodeStudioRuntimeManager runtimeManager;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.restartcodestudio");

    RestartCodeStudioStepRunner(Scenario scenario, Step step, RestartCodeStudioStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = this.scenario.getProjectKey();
        if (StringUtils.isBlank((String)this.params.codeStudioId)) {
            throw new CodedException((InfoMessage.MessageCode)ScenarioCodes.ERR_SCENARIO_INVALID_STEP_CONFIG, "Restart Code Studio step: Code Studio identifier not specified in step configuration");
        }
        AnyLoc codeStudioLoc = new AnyLoc(projectKey, this.params.codeStudioId);
        ReportTargetItem.CodeStudioItem target = new ReportTargetItem.CodeStudioItem(projectKey, this.params.codeStudioId);
        ReportItem.RestartCodeStudio reportItem = (ReportItem.RestartCodeStudio)new ReportItem.RestartCodeStudio(target).withStart(System.currentTimeMillis());
        try {
            CodeStudioObject codeStudio;
            logger.info((Object)("Restarting Code Studio " + this.params.codeStudioId));
            try (Transaction t = this.transactionService.beginRead();){
                codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, this.params.codeStudioId);
            }
            reportItem.withRunAs(codeStudio.params.runAs);
            FutureResponse future = this.runtimeManager.restart(stepRun.getScenarioRun().getRunAsUser(), codeStudio);
            logger.info((Object)"Restart in progress, waiting.");
            future = this.futureService.waitForFinalResponse(future);
            CodeStudioRuntimeManager.CodeStudioStartStopResult result = (CodeStudioRuntimeManager.CodeStudioStartStopResult)future.result;
            if (result.messages.fatal || result.messages.error) {
                String errorsStr = result.messages.messages.stream().filter(m -> m.severity == InfoMessage.Severity.ERROR).map(m -> m.message).collect(Collectors.joining("\n"));
                reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withThrown(new Exception("Restart failed : " + errorsStr)).withLogTail(result.futureLog);
            } else if (result.messages.warning) {
                reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.WARNING);
            } else {
                reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            }
        }
        catch (InterruptedException iex) {
            throw iex;
        }
        catch (Exception e) {
            logger.info((Object)"Failed to restart Code Studio", (Throwable)e);
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withThrown(e);
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(codeStudioLoc, null, null, stepRun.getScenarioRun(), stepRun, reportItem);
        }
        stepReportItem.withOutcome(reportItem.getOutcome());
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class RestartCodeStudioStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String codeStudioId;
    }
}

