/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.AppHomepageTile;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dataflow.graphtools.AutoSchemaPropagation;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public class SchemaPropagationStepRunner
implements StepRunner {
    private final Scenario scenario;
    private final SchemaPropagationStepParams params;
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return SchemaPropagationStepParams.class;
        }

        @Override
        public String getType() {
            return "schema_propagation";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new SchemaPropagationStepRunner(scenario, step.getParamsAs(SchemaPropagationStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "Schema Propagation";
        }

        @Override
        public String buildId(Step step) {
            return "schema_propagation";
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private static Logger logger = Logger.getLogger((String)"dip.step.propagate");

    SchemaPropagationStepRunner(Scenario scenario, SchemaPropagationStepParams params) {
        this.scenario = scenario;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        AutoSchemaPropagation propagation = new AutoSchemaPropagation((AuthCtx)stepRun.getScenarioRun().getRunAsUser(), this.scenario.getProjectKey(), (List<AnyLoc>)Lists.newArrayList((Object[])new AnyLoc[]{new AnyLoc(this.scenario.getProjectKey(), this.params.options.datasetName)}), this.params.options.recipeUpdateOptions, this.params.options.excludedRecipes, this.params.options.partitionByDim, this.params.options.partitionByComputable, this.params.options.markAsOkRecipes);
        try {
            InfoMessage.InfoMessages infoMessages = propagation.propagate(Objects.equals((Object)AppHomepageTile.PropagateSchemaTileBehavior.AUTO_WITH_BUILDS, (Object)this.params.options.behavior), false, true);
            if (infoMessages.error || infoMessages.warning) {
                stepReportItem.withOutcome(infoMessages.error ? ReportItem.Outcome.FAILED : ReportItem.Outcome.WARNING);
            } else {
                stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
            }
        }
        catch (InterruptedException iex) {
            throw iex;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to propagate changes", (Throwable)e);
            stepReportItem.withThrown(e).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
        }
    }

    public static class SchemaPropagationStepParams
    extends NonFatalStepParams
    implements StepParams {
        public AppHomepageTile.PropagateSchemaTile options;
    }
}

