/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterMeta;
import com.dataiku.dip.cluster.ClusterRegistry;
import com.dataiku.dip.cluster.ClustersService;
import com.dataiku.dip.cluster.PythonPluginClusterDesc;
import com.dataiku.dip.cluster.PythonPluginClusterHandler;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.custom.UnavailablePluginItemInfo;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepMetaWithPluginifiedHolder;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SetupClusterStepRunner
implements StepRunner {
    public static final StepMeta META = new SetupClusterStepMeta();
    @Autowired
    private ClustersService clustersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private ProjectsService projectsService;
    private final SetupClusterStepParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.setupcluster");

    public SetupClusterStepRunner(SetupClusterStepParams params) {
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        Object clusterName;
        ClusterMeta clusterMeta = ClusterRegistry.getMeta(this.params.clusterType);
        PythonPluginClusterDesc clusterDesc = ((PythonPluginClusterHandler.PythonPluginClusterMeta)clusterMeta).getDesc().desc;
        if (StringUtils.isBlank((String)this.params.variableName)) {
            this.params.variableName = "__current_cluster__";
        }
        if (StringUtils.isBlank((String)(clusterName = this.params.clusterName))) {
            clusterName = StringUtils.isNotBlank((String)clusterDesc.autoClusterNamePrefix) ? clusterDesc.autoClusterNamePrefix + SecretKeyGenerator.generate((int)8) : this.params.clusterType + "_" + SecretKeyGenerator.generate((int)8);
        }
        if (StringUtils.isNotBlank((String)clusterDesc.clusterNamePreparationReplaced) && clusterDesc.clusterNamePreparationReplacement != null) {
            clusterName = ((String)clusterName).replaceAll(clusterDesc.clusterNamePreparationReplaced, clusterDesc.clusterNamePreparationReplacement);
        }
        if (clusterDesc.clusterNamePreparationLowercasing) {
            clusterName = ((String)clusterName).toLowerCase();
        }
        DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
        String projectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
        if (StringUtils.isBlank((String)this.params.clusterType)) {
            throw new Exception("Missing cluster type");
        }
        Cluster cluster = new Cluster();
        cluster.type = this.params.clusterType;
        cluster.name = clusterName;
        cluster.params = this.params.clusterParams;
        cluster.state = Cluster.ClusterState.NONE;
        if (!authCtx.getPermissions().mayCreateClusters()) {
            throw new SecurityException("You may not create clusters");
        }
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            cluster.origin = Cluster.ClusterOrigin.makeScenarioRun(stepRun.getScenarioRun(), !this.params.surviveScenarioRun);
            cluster = this.clustersService.create(authCtx, cluster);
            t.commit("Created cluster " + cluster.id + " for scenario " + stepRun.getScenarioRun().getScenario().getFullId());
        }
        logger.info((Object)"Start the cluster");
        ReportTargetItem.ClusterItem clusterItem = new ReportTargetItem.ClusterItem(cluster.id);
        AnyLoc clusterLoc = new AnyLoc("__DKU_INSTANCE_CLUSTERS__", cluster.id);
        ReportItem.SetUpCluster reportItem = (ReportItem.SetUpCluster)new ReportItem.SetUpCluster(clusterItem).withStart(DateTime.now().getMillis());
        try {
            FutureResponse fr;
            try (Transaction t = this.transactionService.beginRead();){
                fr = this.clustersService.start(authCtx, stepRun.getScenarioRun().getScenario().getProjectKey(), cluster);
            }
            fr = this.futureService.waitForFinalResponse(fr);
            logger.info((Object)"Cluster started, use it for scenario");
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
        }
        catch (InterruptedException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            reportItem.withThrown(ex).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            throw ex;
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(clusterLoc, null, null, stepRun.getScenarioRun(), stepRun, reportItem);
        }
        SetupClusterStepRunner.attachOneClusterToScenarioRun(stepRun.getScenarioRun(), cluster.id, this.params.variableName);
        if (this.params.storeAsProjectVariable) {
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                RelFile variablesFile = new RelFile(new String[]{"projects", projectKey, "variables.json"});
                JsonObject standard = (JsonObject)t.readObjectDefault(variablesFile, JsonObject.class);
                standard.addProperty(this.params.variableName, cluster.id);
                t.writeStringUTF8(variablesFile, JSON.prettyUnescapeHtml((Object)standard));
                t.commit("Save cluster " + cluster.id + " as project variable " + this.params.variableName);
            }
        } else {
            stepRun.getScenarioRun().getVariables().addProperty(this.params.variableName, cluster.id);
        }
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
    }

    public static void attachOneClusterToScenarioRun(ScenarioRun scenarioRun, String clusterId, String variableName) {
        logger.infoV("Store cluster %s in variable %s", new Object[]{clusterId, variableName});
        ArrayList usagesToRemove = Lists.newArrayList();
        for (SimpleKeyValue clusterUsed : scenarioRun.getClustersUsed()) {
            if (!StringUtils.equals((String)variableName, (String)clusterUsed.key)) continue;
            logger.infoV("Variable %s already used to store cluster %s", new Object[]{clusterUsed.key, clusterUsed.value});
            usagesToRemove.add(clusterUsed);
        }
        scenarioRun.removeClustersUsed(usagesToRemove);
        scenarioRun.addClusterUsed(new SimpleKeyValue(variableName, clusterId));
    }

    public static class SetupClusterStepParams
    implements StepParams {
        public String clusterName;
        public String variableName;
        public boolean surviveScenarioRun;
        public boolean storeAsProjectVariable;
        public String clusterId;
        public String clusterType;
        public PythonPluginClusterHandler.PythonPluginClusterParams clusterParams = new PythonPluginClusterHandler.PythonPluginClusterParams();
    }

    public static class SetupClusterStepMeta
    extends StepMetaWithPluginifiedHolder {
        @Override
        public Class<? extends StepParams> paramsClass() {
            return SetupClusterStepParams.class;
        }

        @Override
        public String getType() {
            return "set_up_cluster";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new SetupClusterStepRunner(step.getParamsAs(SetupClusterStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "setup cluster";
        }

        @Override
        public String buildId(Step step) {
            SetupClusterStepParams stepParams = step.getParamsAs(SetupClusterStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("set_up_cluster");
            if (stepParams != null) {
                sb.append("_");
                sb.append(stepParams.clusterType);
                sb.append("_");
                sb.append(stepParams.clusterName);
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            SetupClusterStepParams stepParams = (SetupClusterStepParams)step.params;
            if (null != stepParams && null != stepParams.clusterParams && stepParams.clusterParams instanceof PythonPluginClusterHandler.PythonPluginClusterParams) {
                try {
                    ClusterRegistry.getMeta(stepParams.clusterType);
                }
                catch (UnavailableDSSObjectException ue) {
                    logger.error((Object)"Unavailable DSS object", (Throwable)((Object)ue));
                    return new StepMeta.UnavailableStepInfo(step, UnavailablePluginItemInfo.fromObjectTypeAndType(null, stepParams.clusterType));
                }
            }
            return null;
        }

        @Override
        public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
            ArrayList components = Lists.newArrayList();
            if (object instanceof IPluginifiedHolderMeta.Pluginifiable) {
                Step step = (Step)((IPluginifiedHolderMeta.Pluginifiable)object).object;
                SetupClusterStepParams stepParams = step.getParamsAs(SetupClusterStepParams.class);
                components.add(new IPluginifiedHolderMeta.Pluginifiable("cluster", stepParams.clusterType, stepParams.clusterParams));
            }
            return components;
        }
    }
}

