/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntime;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntimeManager;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StopCodeStudioStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return StopCodeStudioStepParams.class;
        }

        @Override
        public String getType() {
            return "stop_code_studio";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new StopCodeStudioStepRunner(scenario, step, step.getParamsAs(StopCodeStudioStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            StopCodeStudioStepParams params = step.getParamsAs(StopCodeStudioStepParams.class);
            return "Stop " + (String)(params.allCodeStudiosInProject ? "all Code Studios in project" : "Code Studio " + params.codeStudioId);
        }

        @Override
        public String buildId(Step step) {
            StopCodeStudioStepParams stepParams = step.getParamsAs(StopCodeStudioStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("stop_code_studio");
            if (stepParams != null) {
                sb.append("_");
                sb.append(stepParams.codeStudioId == null ? "all" : stepParams.codeStudioId);
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final StopCodeStudioStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private CodeStudioObjectsService codeStudioObjectsService;
    @Autowired
    private CodeStudioRuntimeManager runtimeManager;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.stopcodestudio");

    StopCodeStudioStepRunner(Scenario scenario, Step step, StopCodeStudioStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = this.scenario.getProjectKey();
        try {
            List<CodeStudioObject> codeStudios;
            block22: {
                try (Transaction t = this.transactionService.beginRead();){
                    if (this.params.allCodeStudiosInProject) {
                        codeStudios = this.codeStudioObjectsService.listUnsafe(projectKey);
                        logger.info((Object)("Stopping all Code Studios (" + codeStudios.size() + ") of project " + projectKey));
                        break block22;
                    }
                    if (!StringUtils.isBlank((String)this.params.codeStudioId)) {
                        codeStudios = Collections.singletonList(this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, this.params.codeStudioId));
                        logger.info((Object)("Stopping Code Studio " + this.params.codeStudioId + " of project " + projectKey));
                        break block22;
                    }
                    logger.warn((Object)"No Code Studio targeted in the stop step");
                    throw new Exception("No Code Studio targeted");
                }
            }
            boolean isSuccess = true;
            for (CodeStudioObject codeStudio : codeStudios) {
                ScenarioThread.checkInterrupted();
                DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
                CodeStudioRuntime.CodeStudioPersistedState state = this.runtimeManager.getRunningStateOrNull(authCtx, codeStudio);
                if (state != null && state.state != CodeStudioRuntime.CodeStudioRuntimeState.STOPPING) {
                    logger.info((Object)("Stopping Code Studio " + codeStudio.id + " " + codeStudio.name + " " + (String)(this.params.syncBeforeStop ? "with" + (this.params.forceSync ? " forced " : " ") + "sync" : "without sync")));
                    CodeStudioStopContext stopCtx = new CodeStudioStopContext(projectKey, codeStudio.id, codeStudio.params.runAs);
                    boolean canBeStopped = true;
                    if (this.params.syncBeforeStop) {
                        CodeStudioRuntime runtime = this.runtimeManager.getRuntimeOrNull(authCtx, codeStudio);
                        if (runtime == null) {
                            logger.info((Object)("Code Studio " + codeStudio.id + " " + codeStudio.name + " is not started, skip it"));
                            canBeStopped = false;
                            stopCtx.success(stepRun);
                        } else {
                            List<CodeStudioMeta.SyncZoneInstance> syncZones = runtime.getSyncedZones();
                            if (this.params.forceSync) {
                                logger.info((Object)("Force Code Studio " + codeStudio.id + " sync of " + syncZones.size() + " zone(s) before stop"));
                            } else {
                                List<String> zoneIds = syncZones.stream().map(z -> z.id).collect(Collectors.toList());
                                logger.info((Object)("Check Code Studio " + codeStudio.id + " conflicts in " + syncZones.size() + " zone(s) before stop"));
                                CodeStudioRuntimeManager.CheckConflictsResponse conflicts = this.runtimeManager.checkConflictsFromCodeStudio(authCtx, codeStudio, zoneIds);
                                if (conflicts.values().stream().anyMatch(diff -> diff.added.size() + diff.deleted.size() + diff.modified.size() > 0)) {
                                    logger.warn((Object)("Code Studio " + codeStudio.id + " has conflicts, and won't be stopped"));
                                    canBeStopped = false;
                                    isSuccess = false;
                                    stopCtx.failed(stepRun, null);
                                }
                            }
                            if (canBeStopped) {
                                for (CodeStudioMeta.SyncZoneInstance syncZone : syncZones) {
                                    this.runtimeManager.pullBundleFromCodeStudio(authCtx, syncZone.id, codeStudio, true);
                                }
                            }
                        }
                    }
                    if (!canBeStopped) continue;
                    FutureResponse futureStop = this.runtimeManager.stop(authCtx, codeStudio, null);
                    futureStop = this.futureService.waitForFinalResponse(futureStop);
                    if (((CodeStudioRuntime.CodeStudioUIState)futureStop.result).state != CodeStudioRuntime.CodeStudioRuntimeState.STOPPED) {
                        isSuccess = false;
                        logger.warn((Object)("Code Studio " + codeStudio.id + " failed to stop"));
                        stopCtx.failed(stepRun, null);
                        continue;
                    }
                    stopCtx.success(stepRun);
                    continue;
                }
                logger.info((Object)("Code Studio " + codeStudio.id + " " + codeStudio.name + " is not started, skip it"));
            }
            stepReportItem.withEnd(DateTime.now().getMillis()).withOutcome(isSuccess ? ReportItem.Outcome.SUCCESS : ReportItem.Outcome.FAILED);
        }
        catch (InterruptedException iex) {
            throw iex;
        }
        catch (Exception e) {
            logger.info((Object)"Failed to stop Code Studio(s)", (Throwable)e);
            stepReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withThrown(e);
        }
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class StopCodeStudioStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String codeStudioId = null;
        public boolean allCodeStudiosInProject = true;
        public boolean syncBeforeStop = true;
        public boolean forceSync = false;
    }

    private class CodeStudioStopContext {
        ReportItem.StopCodeStudio reportItem;
        AnyLoc codeStudioLoc;

        public CodeStudioStopContext(String projectKey, String codeStudioId, String runAs) {
            this.codeStudioLoc = new AnyLoc(projectKey, StopCodeStudioStepRunner.this.params.codeStudioId);
            ReportTargetItem.CodeStudioItem reportTargetItem = new ReportTargetItem.CodeStudioItem(projectKey, codeStudioId);
            this.reportItem = (ReportItem.StopCodeStudio)new ReportItem.StopCodeStudio(reportTargetItem).withStart(System.currentTimeMillis());
            this.reportItem.withRunAs(runAs);
        }

        private void ends(ReportItem.Outcome outcome, StepRun stepRun, Throwable ex) {
            this.reportItem.withEnd(DateTime.now().getMillis()).withOutcome(outcome);
            if (ex != null) {
                this.reportItem.withThrown(ex);
            }
            StopCodeStudioStepRunner.this.jobsDatabaseService.tryRegisterFlowObjectEvent(this.codeStudioLoc, null, null, stepRun.getScenarioRun(), stepRun, this.reportItem);
        }

        public void success(StepRun stepRun) {
            this.ends(ReportItem.Outcome.SUCCESS, stepRun, null);
        }

        public void failed(StepRun stepRun, Throwable ex) {
            this.ends(ReportItem.Outcome.FAILED, stepRun, ex);
        }
    }
}

