/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepParamsWithComputables;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SynchronizeHiveStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return SynchronizeHiveStepParams.class;
        }

        @Override
        public String getType() {
            return "sync_hive";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new SynchronizeHiveStepRunner(scenario, step, step.getParamsAs(SynchronizeHiveStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            SynchronizeHiveStepParams params = step.getParamsAs(SynchronizeHiveStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("sync. hive with");
            if (params != null) {
                for (FlowComputableSpecification built : params.syncs) {
                    sb.append(" ");
                    sb.append(built.getItemName());
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            SynchronizeHiveStepParams params = step.getParamsAs(SynchronizeHiveStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("sync_hive");
            if (params != null) {
                for (FlowComputableSpecification built : params.getSyncs()) {
                    sb.append("_");
                    sb.append(built.getPartitionInvariantId());
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private VariablesService variablesService;
    private final SynchronizeHiveStepParams params;
    private final Scenario scenario;
    private final Step step;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.synchronizehive");

    SynchronizeHiveStepRunner(Scenario scenario, Step step, SynchronizeHiveStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String scenarioProjectKey = this.scenario.getProjectKey();
        boolean anyFailure = false;
        try (HiveMetastoreSynchronizer hms = HiveMetastoreSynchronizerFactory.getSynchronizer(stepRun.getScenarioRun().getRunAsUser());){
            for (FlowComputableSpecification sync : this.params.syncs) {
                Dataset dataset;
                ScenarioThread.checkInterrupted();
                String clusterIdOverride = this.params.overrideCluster ? StringUtils.defaultIfBlank((String)this.params.clusterId, (String)"__builtin__") : "";
                try (Transaction t = this.transactionService.beginRead();){
                    DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(sync.projectKey != null ? sync.projectKey : scenarioProjectKey, sync.itemId);
                    dataset = this.datasetAccessService.getMandatory(loc);
                    clusterIdOverride = this.variablesService.getForProject(scenarioProjectKey).expand(clusterIdOverride);
                }
                ReportTargetItem datasetItem = sync.getTargetItem(this.scenario.getProjectKey(), null);
                ReportItem.HiveMetastoreSynchronized reportItem = (ReportItem.HiveMetastoreSynchronized)new ReportItem.HiveMetastoreSynchronized(datasetItem).withStart(DateTime.now().getMillis());
                stepRun.getScenarioRun().clusterIdOverride = clusterIdOverride;
                try {
                    logger.info((Object)("Synchronize dataset " + dataset.getFullName()));
                    InfoMessage.InfoMessages messages = hms.synchronizeOneDataset(dataset, false, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.OTHER, null, true);
                    messages.summarize();
                    ReportItem.Outcome syncOutcome = ReportItem.Outcome.SUCCESS;
                    if (messages.warning) {
                        syncOutcome = ReportItem.Outcome.WARNING;
                    }
                    reportItem.withEnd(DateTime.now().getMillis()).withOutcome(syncOutcome);
                }
                catch (InterruptedException iex) {
                    throw iex;
                }
                catch (Throwable ex) {
                    logger.error((Object)("Failed to sync " + dataset.getFullName()), ex);
                    anyFailure = true;
                    reportItem.withThrown(ex).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                }
                finally {
                    stepRun.getScenarioRun().clusterIdOverride = null;
                    this.jobsDatabaseService.tryRegisterFlowObjectEvent(dataset.getLoc(), null, null, stepRun.getScenarioRun(), stepRun, reportItem);
                }
            }
        }
        logger.info((Object)("Done step " + this.step.name));
        if (anyFailure && this.params.fatalErrors) {
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
        } else if (anyFailure) {
            stepReportItem.withOutcome(ReportItem.Outcome.WARNING);
        } else {
            stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        }
    }

    public static class SynchronizeHiveStepParams
    extends NonFatalStepParams
    implements StepParams,
    StepParamsWithComputables {
        public List<FlowComputableSpecification> syncs = Lists.newArrayList();
        public boolean fatalErrors = false;
        public boolean overrideCluster = false;
        public String clusterId;

        public List<FlowComputableSpecification> getSyncs() {
            return Lists.newArrayList(this.syncs);
        }

        public SynchronizeHiveStepParams withSyncs(List<FlowComputableSpecification> syncs) {
            this.syncs = Lists.newArrayList(syncs);
            return this;
        }

        public SynchronizeHiveStepParams withSyncs(FlowComputableSpecification ... syncs) {
            this.syncs = Lists.newArrayList((Object[])syncs);
            return this;
        }

        @Override
        public Collection<FlowComputableSpecification> getComputablesSpec() {
            return this.getSyncs();
        }
    }
}

