/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.scheduler.triggers.LoadedPythonPluginTrigger;
import com.dataiku.dip.scheduler.triggers.PythonPluginTriggerDesc;
import com.dataiku.dip.scheduler.triggers.PythonPluginTriggerRunner;
import com.dataiku.dip.scheduler.triggers.TriggerRegistry;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class PythonPluginTriggersService
extends CustomPythonElementService<PythonPluginTriggerDesc, LoadedPythonPluginTrigger> {
    @Override
    public String getFolderName() {
        return "python-triggers";
    }

    @Override
    public String getPrefix() {
        return "trigger";
    }

    @Override
    protected String getCodeExtension(LoadedPythonPluginTrigger desc) {
        return ".py";
    }

    @Override
    public Class<PythonPluginTriggerDesc> getDescClass() {
        return PythonPluginTriggerDesc.class;
    }

    @Override
    public Class<LoadedPythonPluginTrigger> getLoadedDescClass() {
        return LoadedPythonPluginTrigger.class;
    }

    @Override
    protected void removeElement(LoadedPythonPluginTrigger desc) {
        TriggerRegistry.deregister(desc.triggerType);
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "pytrigger_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedPythonPluginTrigger load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedPythonPluginTrigger loaded = new LoadedPythonPluginTrigger(elementId, pluginId, elementType, (PythonPluginTriggerDesc)JSON.parseFile((File)file, PythonPluginTriggerDesc.class));
        PythonPluginTriggerRunner.PythonPluginTriggerMeta stepMeta = new PythonPluginTriggerRunner.PythonPluginTriggerMeta(pluginId, loaded, this);
        TriggerRegistry.register(stepMeta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final PythonPluginTriggerDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, PythonPluginTriggersService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }
}

