/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.scheduler.triggers.TriggerMeta;
import com.dataiku.dip.scheduler.triggers.TriggerParams;
import com.dataiku.dip.scheduler.triggers.TriggerRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.IllegalFieldValueException;
import com.dataiku.dss.shadelib.org.joda.time.IllegalInstantException;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.Seconds;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TemporalTriggerRunner
implements TriggerRunner {
    public static final String SERVER_TIMEZONE = "SERVER";
    public static final TriggerMeta META = new TriggerMeta(){

        @Override
        public Class<? extends TriggerParams> paramsClass() {
            return TemporalTriggerParams.class;
        }

        @Override
        public String getType() {
            return "temporal";
        }

        @Override
        public TriggerRunner buildRunner(Scenario scenario, Trigger trigger) {
            return new TemporalTriggerRunner(scenario, trigger, trigger.getParamsAs(TemporalTriggerParams.class));
        }

        @Override
        public boolean delayIfScenarioAlreadyRuns() {
            return false;
        }

        @Override
        public String getDigest(Trigger trigger) {
            return trigger.getParamsAs(TemporalTriggerParams.class).getFrequencyDescription();
        }

        @Override
        public DateTime getExpectedNextRun(Trigger trigger, String stateString) {
            DateTime scheduledStartDate = stateString == null ? null : parser.parseDateTime(stateString);
            return trigger.getParamsAs(TemporalTriggerParams.class).calculateNextFire(DateTime.now(), scheduledStartDate);
        }

        @Override
        public int getForcedTriggerLoopDelay(Trigger trigger, String stateString, boolean loopStarting) {
            try {
                DateTime scheduledStartDate = stateString == null ? null : parser.parseDateTime(stateString);
                DateTime now = nowProvider.now();
                Pair<DateTime, DateTime> slot = trigger.getParamsAs(TemporalTriggerParams.class).nextSlot(now, scheduledStartDate);
                if (slot.first == null) {
                    logger.warnV("(triggerId: %s) No next trigger slot, just polling", new Object[]{trigger.id});
                    return 30;
                }
                return Math.max(0, Seconds.secondsBetween((ReadableInstant)now, (ReadableInstant)((ReadableInstant)slot.first)).getSeconds()) + 1;
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "(triggerId: %s) Unable to compute delay to next execution, using default", new Object[]{trigger.id});
                return 30;
            }
        }
    };
    private static final DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
    private static final DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
    private final TemporalTriggerParams params;
    private final Trigger trigger;
    private final Scenario scenario;
    static NowProvider nowProvider = DateTime::now;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.temporal");

    public TemporalTriggerRunner(Scenario scenario, Trigger trigger, TemporalTriggerParams params) {
        this.trigger = trigger;
        this.params = params;
        this.scenario = scenario;
    }

    @Override
    public TriggerFire run(ScenariosTriggerService triggerService, AuthCtx authCtx) throws Exception {
        DateTime comparableLast;
        DateTime comparableExpected;
        String stateString = triggerService.getTriggerState(this.scenario, this.trigger);
        DateTime scheduledStartDate = stateString == null ? null : parser.parseDateTime(stateString);
        DateTime now = nowProvider.now();
        Pair<DateTime, DateTime> slot = this.params.nextSlot(now, scheduledStartDate);
        if (slot.first == null) {
            return null;
        }
        if (((DateTime)slot.first).isAfter((ReadableInstant)now)) {
            return null;
        }
        if (slot.second != null && ((DateTime)slot.second).isBefore((ReadableInstant)now)) {
            return null;
        }
        DateTime expectedStart = (DateTime)slot.first;
        if (scheduledStartDate != null && ((comparableExpected = expectedStart.withSecondOfMinute(0).withMillisOfSecond(0)).equals((Object)(comparableLast = scheduledStartDate.withSecondOfMinute(0).withMillisOfSecond(0))) || comparableExpected.isBefore((ReadableInstant)comparableLast))) {
            return null;
        }
        String newTriggerState = formatter.print((ReadableInstant)expectedStart);
        TriggerFire triggerFire = new TriggerFire().withProjectKey(this.scenario.getProjectKey()).withScenarioId(this.scenario.getId()).withTrigger(this.trigger);
        triggerFire = triggerFire.withTriggerState(newTriggerState);
        triggerFire = triggerFire.withParam("expectedStart", DKUtils.isoFormatReadableByDateFormat((long)expectedStart.getMillis()));
        return triggerFire;
    }

    public static class TemporalTriggerParams
    implements TriggerParams {
        private static final String DATE_FORMAT = "yyyy-MM-dd";
        private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        public final int repeatFrequency;
        public final Frequency frequency;
        public String startingFrom;
        public final List<DayOfWeek> daysOfWeek = Lists.newArrayList();
        public final MonthlyRunOn monthlyRunOn;
        public final int minute;
        public final int hour;
        public final String timezone;
        public long lastUpdate;

        TemporalTriggerParams(int repeatFrequency, Frequency frequency, DateTime start, int hour, int minute, String timezone, MonthlyRunOn monthlyRunOn, DayOfWeek ... daysOfWeek) {
            this(repeatFrequency, frequency, FORMATTER.print((ReadableInstant)start), hour, minute, timezone, monthlyRunOn, daysOfWeek);
        }

        TemporalTriggerParams(int repeatFrequency, Frequency frequency, String startingFrom, int hour, int minute, String timezone, MonthlyRunOn monthlyRunOn, DayOfWeek ... daysOfWeek) {
            this.repeatFrequency = repeatFrequency;
            this.frequency = frequency;
            this.startingFrom = startingFrom;
            this.daysOfWeek.addAll(Arrays.asList(daysOfWeek));
            this.monthlyRunOn = monthlyRunOn;
            this.hour = hour;
            this.minute = minute;
            this.timezone = timezone;
            this.lastUpdate = DateTime.now().getMillis();
        }

        @Override
        public void notifyUpdate() {
            this.lastUpdate = DateTime.now().getMillis();
        }

        void setLastUpdate(DateTime now) {
            this.lastUpdate = now.getMillis();
        }

        public String getMinutes() {
            return (this.minute < 10 ? "0" : "") + this.minute;
        }

        public String getHoursAndMinutes() {
            return (this.hour < 10 ? "0" : "") + this.hour + ":" + this.getMinutes();
        }

        public String getFrequencyDescription() {
            if (this.frequency != null) {
                switch (this.frequency) {
                    case Monthly: {
                        DateTime startDate = this.getStartDate(null);
                        if (startDate == null) break;
                        return "Every month on the " + startDate.getDayOfMonth() + " at " + this.getHoursAndMinutes();
                    }
                    case Weekly: {
                        ArrayList days = Lists.newArrayList();
                        for (DayOfWeek dayOfWeek : this.daysOfWeek) {
                            if (dayOfWeek == null) continue;
                            days.add(dayOfWeek.name());
                        }
                        return this.daysOfWeek.isEmpty() ? "Never" : "Every " + String.join((CharSequence)", ", days) + " at " + this.getHoursAndMinutes();
                    }
                    case Daily: {
                        return "Every day at " + this.getHoursAndMinutes();
                    }
                    case Hourly: {
                        return "Every hour at :" + this.getMinutes();
                    }
                    case Minutely: {
                        return "Every " + this.repeatFrequency + " minute";
                    }
                }
            }
            return "Never";
        }

        protected int getMargin() {
            return this.frequency != null ? this.frequency.getWaitTime() / 10 : 0;
        }

        private DateTime getDateTimeWithHourHandlesDST(DateTime t, int hour) {
            try {
                return t.withHourOfDay(hour);
            }
            catch (IllegalFieldValueException e) {
                if (e.getCause() instanceof IllegalInstantException) {
                    return t.withHourOfDay(hour + 1);
                }
                throw e;
            }
            catch (IllegalInstantException e) {
                return t.withHourOfDay(hour + 1);
            }
        }

        protected Pair<DateTime, DateTime> nextSlot(DateTime now, DateTime scheduledStartDate) {
            if (this.frequency != null) {
                switch (this.frequency) {
                    case Minutely: {
                        return this.getNextMinutelySlot(now, scheduledStartDate);
                    }
                    case Hourly: {
                        return this.getNextHourlySlot(this.getStartDate(now), now, scheduledStartDate);
                    }
                    case Daily: {
                        return this.getNextDailySlot(this.getStartDate(now), now, scheduledStartDate);
                    }
                    case Weekly: {
                        return this.getNextWeeklySlot(this.getStartDate(now), now, scheduledStartDate);
                    }
                    case Monthly: {
                        if (this.monthlyRunOn == null || MonthlyRunOn.ON_THE_DAY.equals((Object)this.monthlyRunOn)) {
                            return this.getNextMonthlySlot(this.getStartDate(now), now, scheduledStartDate);
                        }
                        if (MonthlyRunOn.LAST_DAY_OF_THE_MONTH.equals((Object)this.monthlyRunOn)) {
                            return this.getLastDayOfMonths(this.getStartDate(now), now, scheduledStartDate);
                        }
                        return this.getNextWeekOnMonthlySlot(this.getStartDate(now), now, scheduledStartDate);
                    }
                }
            }
            return new Pair(null, null);
        }

        private DateTime getStartDate(DateTime now) {
            if (StringUtils.isBlank((CharSequence)this.startingFrom)) {
                return now;
            }
            String start = this.startingFrom;
            if (start.length() > DATE_FORMAT.length()) {
                start = start.substring(0, DATE_FORMAT.length());
            }
            LocalDate dt = ISODateTimeFormat.date().parseLocalDate(start);
            DateTimeZone zone = StringUtils.isNotBlank((CharSequence)this.timezone) && !TemporalTriggerRunner.SERVER_TIMEZONE.equals(this.timezone) ? DateTimeZone.forID((String)this.timezone) : DateTimeZone.getDefault();
            return new DateTime(dt.getYear(), dt.getMonthOfYear(), dt.getDayOfMonth(), 0, 0, 0, 0, zone);
        }

        private Pair<DateTime, DateTime> getNextMinutelySlot(DateTime now, DateTime scheduledStartDate) {
            if (scheduledStartDate == null) {
                return new Pair((Object)now, null);
            }
            if (now.minusMinutes(2 * this.repeatFrequency).isAfter((ReadableInstant)scheduledStartDate)) {
                return new Pair((Object)now, null);
            }
            return new Pair((Object)scheduledStartDate.plusMinutes(this.repeatFrequency), null);
        }

        private Pair<DateTime, DateTime> getNextHourlySlot(DateTime startDate, DateTime now, DateTime scheduledStartDate) {
            DateTime slotStart = this.getDateTimeWithHourHandlesDST(startDate, this.hour).withMinuteOfHour(this.minute);
            int margin = this.getMargin();
            int hourRepeatFrequency = this.getRepeatFrequency();
            while (slotStart.plusSeconds(margin).isBefore((ReadableInstant)now) || this.isScheduledLater(slotStart, scheduledStartDate)) {
                slotStart = TemporalTriggerParams.ensureIncremented(slotStart, slotStart.plusHours(hourRepeatFrequency));
            }
            return new Pair((Object)slotStart, (Object)slotStart.plusSeconds(margin));
        }

        private Pair<DateTime, DateTime> getNextDailySlot(DateTime startDate, DateTime now, DateTime scheduledStartDate) {
            DateTime slotStart = this.getDateTimeWithHourHandlesDST(startDate, this.hour).withMinuteOfHour(this.minute);
            int slotStartHour = slotStart.getHourOfDay();
            boolean crossedDstTransition = false;
            int repeatFrequency = this.getRepeatFrequency();
            while (slotStart.plusSeconds(this.getMargin()).isBefore((ReadableInstant)now) || this.isScheduledLater(slotStart, scheduledStartDate)) {
                slotStart = TemporalTriggerParams.ensureIncremented(slotStart, slotStart.plusDays(repeatFrequency));
                if (crossedDstTransition) {
                    slotStart = slotStart.withHourOfDay(slotStartHour);
                    crossedDstTransition = false;
                    continue;
                }
                if (slotStartHour == slotStart.getHourOfDay()) continue;
                crossedDstTransition = true;
            }
            return new Pair((Object)slotStart, (Object)slotStart.plusSeconds(this.getMargin()));
        }

        private Pair<DateTime, DateTime> getNextWeeklySlot(DateTime startDate, DateTime now, DateTime scheduledStartDate) {
            if (this.daysOfWeek.isEmpty()) {
                return new Pair(null, null);
            }
            ArrayList datetimes = Lists.newArrayList();
            int margin = this.getMargin();
            for (DayOfWeek dayOfWeek : this.daysOfWeek) {
                if (dayOfWeek == null) continue;
                DateTime datetime = this.getDateTimeWithHourHandlesDST(startDate, this.hour).withMinuteOfHour(this.minute).withDayOfWeek(dayOfWeek.toJodaDay());
                int weekRepeatFrequency = this.getRepeatFrequency();
                DateTime updated = new DateTime(this.lastUpdate);
                while (datetime.isBefore((ReadableInstant)updated)) {
                    datetime = TemporalTriggerParams.ensureIncremented(datetime, datetime.plusWeeks(weekRepeatFrequency));
                }
                while (datetime.plusSeconds(margin).isBefore((ReadableInstant)now) || this.isScheduledLater(datetime, scheduledStartDate)) {
                    datetime = TemporalTriggerParams.ensureIncremented(datetime, datetime.plusWeeks(weekRepeatFrequency));
                }
                datetimes.add(datetime);
            }
            datetimes.sort(Comparator.naturalOrder());
            if (datetimes.isEmpty()) {
                return new Pair(null, null);
            }
            DateTime slotStart = (DateTime)datetimes.get(0);
            return new Pair((Object)slotStart, (Object)slotStart.plusSeconds(margin /= datetimes.size()));
        }

        private Pair<DateTime, DateTime> getNextMonthlySlot(DateTime startDate, DateTime now, DateTime scheduledStartDate) {
            DateTime slotStart = this.getDateTimeWithHourHandlesDST(startDate, this.hour).withMinuteOfHour(this.minute);
            int dayOfMonth = startDate.getDayOfMonth();
            slotStart = slotStart.withDayOfMonth(Math.min(dayOfMonth, slotStart.dayOfMonth().getMaximumValue()));
            int margin = this.getMargin();
            int monthRepeatFrequency = this.getRepeatFrequency();
            while (slotStart.plusSeconds(margin).isBefore((ReadableInstant)now) || this.isScheduledLater(slotStart, scheduledStartDate)) {
                DateTime newSlotStart = slotStart.plusMonths(monthRepeatFrequency);
                newSlotStart = newSlotStart.withDayOfMonth(Math.min(dayOfMonth, newSlotStart.dayOfMonth().getMaximumValue()));
                slotStart = TemporalTriggerParams.ensureIncremented(slotStart, newSlotStart);
            }
            return new Pair((Object)slotStart, (Object)slotStart.plusSeconds(margin));
        }

        private Pair<DateTime, DateTime> getNextWeekOnMonthlySlot(DateTime startDate, DateTime now, DateTime scheduledStartDate) {
            int dayOfWeek = startDate.getDayOfWeek();
            DateTime slotStart = this.findDayInSpecifiedWeek(startDate.dayOfMonth().withMinimumValue(), dayOfWeek);
            slotStart = this.getDateTimeWithHourHandlesDST(slotStart, this.hour).withMinuteOfHour(this.minute);
            int margin = this.getMargin();
            int monthRepeatFrequency = this.getRepeatFrequency();
            while (slotStart.plusSeconds(margin).isBefore((ReadableInstant)now) || this.isScheduledLater(slotStart, scheduledStartDate)) {
                DateTime nextMonth = slotStart.plusMonths(monthRepeatFrequency).dayOfMonth().withMinimumValue();
                slotStart = TemporalTriggerParams.ensureIncremented(slotStart, this.findDayInSpecifiedWeek(nextMonth, dayOfWeek));
            }
            return new Pair((Object)slotStart, (Object)slotStart.plusSeconds(margin));
        }

        private DateTime findDayInSpecifiedWeek(DateTime fromMonth, int dayOfWeek) {
            if (MonthlyRunOn.LAST_WEEK.equals((Object)this.monthlyRunOn)) {
                DateTime lastWeek = fromMonth.dayOfMonth().withMaximumValue();
                if (lastWeek.getMonthOfYear() == lastWeek.withDayOfWeek(dayOfWeek).getMonthOfYear()) {
                    return lastWeek.withDayOfWeek(dayOfWeek);
                }
                return fromMonth.dayOfMonth().withMaximumValue().withDayOfWeek(dayOfWeek).minusWeeks(1);
            }
            DateTime weekInMonth = fromMonth.getMonthOfYear() == fromMonth.withDayOfWeek(dayOfWeek).getMonthOfYear() ? fromMonth : fromMonth.plusWeeks(1);
            switch (this.monthlyRunOn) {
                case FIRST_WEEK: {
                    break;
                }
                case SECOND_WEEK: {
                    weekInMonth = weekInMonth.plusWeeks(1);
                    break;
                }
                case THIRD_WEEK: {
                    weekInMonth = weekInMonth.plusWeeks(2);
                    break;
                }
                case FOURTH_WEEK: {
                    weekInMonth = weekInMonth.plusWeeks(3);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid week property.");
                }
            }
            return weekInMonth.withDayOfWeek(dayOfWeek);
        }

        private boolean isScheduledLater(DateTime slotStart, DateTime scheduledStartDate) {
            return scheduledStartDate != null && (scheduledStartDate.isEqual((ReadableInstant)slotStart) || scheduledStartDate.isAfter((ReadableInstant)slotStart));
        }

        protected DateTime calculateNextFire(DateTime now, DateTime scheduledStartDate) {
            return (DateTime)this.nextSlot((DateTime)now, (DateTime)scheduledStartDate).first;
        }

        private int getRepeatFrequency() {
            return this.repeatFrequency > 0 ? this.repeatFrequency : 1;
        }

        private Pair<DateTime, DateTime> getLastDayOfMonths(DateTime startDate, DateTime now, DateTime scheduledStartDate) {
            DateTime slotStart = startDate.dayOfMonth().withMaximumValue();
            slotStart = this.getDateTimeWithHourHandlesDST(slotStart, this.hour).withMinuteOfHour(this.minute);
            int margin = this.getMargin();
            int monthRepeatFrequency = this.getRepeatFrequency();
            while (slotStart.plusSeconds(margin).isBefore((ReadableInstant)now) || this.isScheduledLater(slotStart, scheduledStartDate)) {
                slotStart = TemporalTriggerParams.ensureIncremented(slotStart, slotStart.plusMonths(monthRepeatFrequency).dayOfMonth().withMaximumValue());
            }
            return new Pair((Object)slotStart, (Object)slotStart.plusSeconds(margin));
        }

        private static DateTime ensureIncremented(DateTime currentDate, DateTime newDate) {
            if (newDate.getMillis() <= currentDate.getMillis()) {
                throw new IllegalStateException("Stalled loop: " + String.valueOf(currentDate) + " => " + String.valueOf(newDate));
            }
            return newDate;
        }
    }

    public static interface NowProvider {
        public DateTime now();
    }

    public static enum MonthlyRunOn {
        ON_THE_DAY,
        FIRST_WEEK,
        SECOND_WEEK,
        THIRD_WEEK,
        FOURTH_WEEK,
        LAST_WEEK,
        LAST_DAY_OF_THE_MONTH;

    }

    public static enum DayOfWeek {
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday,
        Sunday;


        public int toJodaDay() {
            return this.ordinal() + 1;
        }
    }

    public static enum Frequency {
        Daily(86400),
        Hourly(3600),
        Minutely(60),
        Weekly(604800),
        Monthly(2678400);

        private final int waitTime;

        private Frequency(int wait) {
            this.waitTime = wait;
        }

        public int getWaitTime() {
            return this.waitTime;
        }
    }
}

