/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.utils;

import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.datasets.DatasetComparisonService;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.scheduler.model.FlowItemsToCompare;
import com.dataiku.dip.scheduler.model.FlowItemsToSwap;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetRenameService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class FlowTestUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.flowTestUtils");

    private FlowTestUtils() {
    }

    public static void validateSwapParams(List<FlowItemsToSwap> swaps, String contextProjectKey) throws IOException {
        for (FlowItemsToSwap swap : swaps) {
            FlowTestUtils.validateSwappedDataset(contextProjectKey, swap.sourceSmartName, "swap source");
            FlowTestUtils.validateSwappedDataset(contextProjectKey, swap.targetSmartName, "swap target");
        }
        FlowTestUtils.validateSwapDuplicates(swaps);
    }

    public static Map<SerializedRecipe, List<FlowItemsToSwap>> swapInputDatasets(DSSAuthCtx authCtx, List<FlowItemsToSwap> swaps, StepRun stepRun, String contextProjectKey) throws CodedException, IOException, DKUSecurityException {
        Map<SerializedRecipe, List<FlowItemsToSwap>> swapsByRecipe = FlowTestUtils.getSwapsByRecipe(swaps, contextProjectKey);
        if (swapsByRecipe.isEmpty() && !swaps.isEmpty()) {
            logger.warnV("The requested swaps are not used by any recipe in project %s", new Object[]{contextProjectKey});
        }
        HashMap<SerializedRecipe, List<FlowItemsToSwap>> swappedDatasets = new HashMap<SerializedRecipe, List<FlowItemsToSwap>>();
        for (Map.Entry<SerializedRecipe, List<FlowItemsToSwap>> entry : swapsByRecipe.entrySet()) {
            SerializedRecipe recipe = entry.getKey();
            for (FlowItemsToSwap dsSwap : entry.getValue()) {
                logger.infoV("Replacing dataset %s with dataset %s as input for recipe %s", new Object[]{dsSwap.sourceSmartName, dsSwap.targetSmartName, recipe.getId()});
                long swapStartTime = DateTime.now().getMillis();
                try {
                    FlowTestUtils.swapRecipeInputs(authCtx, contextProjectKey, recipe, dsSwap.sourceSmartName, dsSwap.targetSmartName);
                    swappedDatasets.computeIfAbsent(recipe, k -> Lists.newArrayList()).add(dsSwap.invert());
                    FlowTestUtils.registerSwapRecipeInputItemsEvent(recipe.getId(), dsSwap, contextProjectKey, stepRun, ReportItem.Outcome.SUCCESS, swapStartTime, null);
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Error while replacing inputs in step %s, reverting to initial state", new Object[]{stepRun.getStep().getName()});
                    FlowTestUtils.registerSwapRecipeInputItemsEvent(recipe.getId(), dsSwap, contextProjectKey, stepRun, ReportItem.Outcome.FAILED, swapStartTime, new WarningsContext.SerializedThrowable((Throwable)e));
                    FlowTestUtils.restoreInitialState(authCtx, stepRun, swappedDatasets);
                    throw e;
                }
            }
        }
        return swappedDatasets;
    }

    private static void validateSwappedDataset(String contextProjectKey, String smartName, String role) {
        SerializedProject sp;
        SerializedDataset serializedDataset;
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        DatasetAccessService datasetAccessService = (DatasetAccessService)SpringUtils.getBean(DatasetAccessService.class);
        ProjectsDAO projectsDAO = (ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class);
        if (StringUtils.isEmpty((String)smartName)) {
            throw new IllegalArgumentException("One of your swap mappings has an unselected item. Please review your step configuration.");
        }
        try (Transaction t = transactionService.retrieveOrBeginRead();){
            serializedDataset = datasetAccessService.getMandatory(AnyLoc.resolveSmart(contextProjectKey, smartName)).serialize();
            sp = projectsDAO.getMandatoryUnsafe(contextProjectKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error while fetching %s dataset %s or project %s".formatted(role, smartName, contextProjectKey), e);
        }
        if (serializedDataset.flowOptions.virtualizable) {
            if (ConnectionUtils.isSQLConnectionType(serializedDataset.type) && sp.settings.flowBuildSettings.mergeSqlPipelines) {
                throw new IllegalArgumentException(String.format("Dataset %s is a virtualizable SQL dataset and SQL pipelines are enabled in the flow. You can either disable the SQL pipelines in your flow or make this dataset not virtualizable.", smartName));
            }
            if (sp.settings.flowBuildSettings.mergeSparkPipelines) {
                throw new IllegalArgumentException(String.format("Dataset %s is a virtualizable dataset and Spark pipelines are enabled in the flow. You can either disable the Spark pipelines in your flow or make this dataset not virtualizable.", smartName));
            }
        }
    }

    private static void validateSwapDuplicates(List<FlowItemsToSwap> swaps) {
        List swapDatasetNames = swaps.stream().map(d -> d.sourceSmartName).collect(Collectors.toList());
        swapDatasetNames.addAll(swaps.stream().map(d -> d.targetSmartName).collect(Collectors.toList()));
        HashSet seen = new HashSet();
        Set duplicates = swapDatasetNames.stream().filter(val -> !seen.add(val)).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            logger.warnV("There are duplicates in the swap list: %s", new Object[]{String.join((CharSequence)", ", duplicates)});
        }
    }

    private static void swapRecipeInputs(AuthCtx authCtx, String contextProjectKey, SerializedRecipe recipe, String sourceDatasetSmartName, String targetDatasetSmartName) throws IOException, CodedException, DKUSecurityException {
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        DatasetRenameService datasetRenameService = (DatasetRenameService)SpringUtils.getBean(DatasetRenameService.class);
        try (RWTransaction rwt = transactionService.beginWriteAsLoggedInUser(authCtx);){
            datasetRenameService.performRenamingForRecipe(DatasetLocUtils.resolveSmart(contextProjectKey, sourceDatasetSmartName), DatasetLocUtils.resolveSmart(contextProjectKey, targetDatasetSmartName), authCtx, new TaggableObjectsDeletionService.ImpactedRecipe(contextProjectKey, recipe.name, recipe.getType()), false);
            rwt.commitV("Replaced dataset %s with dataset: %s", new Object[]{sourceDatasetSmartName, targetDatasetSmartName});
        }
    }

    private static void registerInitialStateRestorationEvent(StepRun stepRun, ReportItem.Outcome outcome, long restorationStartTime, @Nullable WarningsContext.SerializedThrowable thrown) {
        ReportTargetItem.InitialFlowTestStateItem reportTargetItem = new ReportTargetItem.InitialFlowTestStateItem();
        FlowTestUtils.registerEvent(new ReportItem.RestoredFlowTestInitialState(reportTargetItem), stepRun, outcome, restorationStartTime, thrown);
    }

    private static Map<SerializedRecipe, List<FlowItemsToSwap>> getSwapsByRecipe(List<FlowItemsToSwap> swaps, String contextProjectKey) throws IOException {
        List recipes;
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        RecipesDAO recipesDAO = (RecipesDAO)SpringUtils.getBean(RecipesDAO.class);
        try (Transaction t = transactionService.beginRead();){
            recipes = recipesDAO.listUnsafe(contextProjectKey);
        }
        HashMap<SerializedRecipe, List<FlowItemsToSwap>> swapsByRecipe = new HashMap<SerializedRecipe, List<FlowItemsToSwap>>();
        for (SerializedRecipe recipe : recipes) {
            List recipeDatasetInputsIds = recipe.getInputsForRole("main").stream().map(recipeInput -> recipeInput.getLoc(contextProjectKey).getSmartName(contextProjectKey)).collect(Collectors.toList());
            List recipeSwaps = swaps.stream().filter(dsSwap -> recipeDatasetInputsIds.contains(dsSwap.sourceSmartName)).collect(Collectors.toList());
            if (recipeSwaps.isEmpty()) continue;
            swapsByRecipe.put(recipe, recipeSwaps);
        }
        return swapsByRecipe;
    }

    private static void registerSwapRecipeInputItemsEvent(String recipeId, FlowItemsToSwap flowItemsToSwap, String contextProjectKey, StepRun stepRun, ReportItem.Outcome outcome, long swapStartTime, @Nullable WarningsContext.SerializedThrowable thrown) {
        DatasetLocUtils.DatasetLoc sourceLoc = DatasetLocUtils.resolveSmart(contextProjectKey, flowItemsToSwap.sourceSmartName);
        DatasetLocUtils.DatasetLoc targetLoc = DatasetLocUtils.resolveSmart(contextProjectKey, flowItemsToSwap.targetSmartName);
        ReportTargetItem.SwappableRecipeInputsItem reportTargetItem = new ReportTargetItem.SwappableRecipeInputsItem(recipeId, sourceLoc.getId(), contextProjectKey.equals(sourceLoc.getProjectKey()) ? null : sourceLoc.getProjectKey(), targetLoc.getId(), contextProjectKey.equals(targetLoc.getProjectKey()) ? null : targetLoc.getProjectKey());
        FlowTestUtils.registerEvent(new ReportItem.SwappedRecipeInputs(reportTargetItem), stepRun, outcome, swapStartTime, thrown);
    }

    public static void assertValidCompareParams(AuthCtx authCtx, List<FlowItemsToCompare> compares, String contextProjectKey) {
        Preconditions.checkArgument((!compares.isEmpty() ? 1 : 0) != 0, (Object)"No comparisons specified");
        compares.forEach(comparison -> {
            FlowTestUtils.validateComparison(contextProjectKey, comparison.resultSmartName, "comparison result");
            FlowTestUtils.validateComparison(contextProjectKey, comparison.expectedSmartName, "comparison expected");
            FlowTestUtils.validatePartitionsCompatibility(authCtx, contextProjectKey, comparison.resultSmartName, comparison.expectedSmartName, comparison.partitionsSpec);
            if (!comparison.compareAllColumns && comparison.equalityColumns == null) {
                throw new IllegalArgumentException(String.format("Cannot run Flow Test step'. In the comparison of dataset '%s' with dataset '%s' the 'Compare All Columns' flag is disabled, but no equality columns were specified", comparison.resultSmartName, comparison.expectedSmartName));
            }
        });
    }

    public static void compareDatasets(DSSAuthCtx authCtx, List<FlowItemsToCompare> compares, String contextProjectKey, ReportItem.StepDone stepReportItem, StepRun stepRun) throws Exception {
        for (FlowItemsToCompare dsComparison : compares) {
            long comparisonStartTime = DateTime.now().getMillis();
            try {
                boolean builtDatasetEqualsReference = FlowTestUtils.performComparison(authCtx, contextProjectKey, dsComparison, stepReportItem);
                ReportItem.Outcome comparisonOutcome = builtDatasetEqualsReference ? ReportItem.Outcome.SUCCESS : ReportItem.Outcome.FAILED;
                FlowTestUtils.registerComparisonEvent(dsComparison, contextProjectKey, stepRun, comparisonOutcome, comparisonStartTime, null);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Error while comparing datasets, reverting to initial state", new Object[0]);
                FlowTestUtils.registerComparisonEvent(dsComparison, contextProjectKey, stepRun, ReportItem.Outcome.FAILED, comparisonStartTime, new WarningsContext.SerializedThrowable((Throwable)e));
                throw e;
            }
        }
    }

    private static void validateComparison(String contextProjectKey, String smartName, String role) {
        SerializedDataset serializedDataset;
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        DatasetAccessService datasetAccessService = (DatasetAccessService)SpringUtils.getBean(DatasetAccessService.class);
        if (StringUtils.isEmpty((String)smartName)) {
            throw new IllegalArgumentException("One of your comparison mappings has an unselected item. Please review your step configuration.");
        }
        try (Transaction t = transactionService.beginRead();){
            serializedDataset = datasetAccessService.getMandatory(AnyLoc.resolveSmart(contextProjectKey, smartName)).serialize();
        }
        catch (IOException e) {
            throw ErrorContext.iae((String)String.format("Error while fetching %s dataset %s", role, smartName), (Exception)e);
        }
        if (serializedDataset.flowOptions.virtualizable) {
            throw new IllegalArgumentException(String.format("Dataset %s is a virtualizable dataset. Virtualizable datasets cannot be compared.", smartName));
        }
    }

    private static void validatePartitionsCompatibility(AuthCtx authCtx, String contextProjectKey, String smartName1, String smartName2, String partitionsSpec) {
        HashSet<String> partitionIds2;
        HashSet<String> partitionIds1;
        Dataset dataset2;
        Dataset dataset1;
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        DatasetAccessService datasetAccessService = (DatasetAccessService)SpringUtils.getBean(DatasetAccessService.class);
        try (Transaction t = transactionService.beginRead();){
            dataset1 = datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(contextProjectKey, smartName1));
            dataset2 = datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(contextProjectKey, smartName2));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while fetching datasets for partition comparison", e);
        }
        if (dataset1.getPartitioningSchema().isPartitioned() && !dataset2.getPartitioningSchema().isPartitioned()) {
            throw ErrorContext.iaef((String)"Dataset %s is partitioned, but dataset %s is not", (Object)smartName1, (Object[])new Object[]{smartName2});
        }
        if (!dataset1.getPartitioningSchema().isPartitioned() && dataset2.getPartitioningSchema().isPartitioned()) {
            throw ErrorContext.iaef((String)"Dataset %s is not partitioned, but dataset %s is", (Object)smartName1, (Object[])new Object[]{smartName2});
        }
        if (!dataset1.getPartitioningSchema().isPartitioned()) {
            return;
        }
        if (StringUtils.isEmpty((String)partitionsSpec)) {
            throw ErrorContext.iaef((String)"No partitions were specified in the comparison between partitioned datasets %s and %s", (Object)smartName1, (Object[])new Object[]{smartName2});
        }
        try {
            partitionIds1 = new HashSet<String>(FlowTestUtils.listPartitions(authCtx, dataset1));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error while fetching partitions of dataset %s", smartName1), e);
        }
        try {
            partitionIds2 = new HashSet<String>(FlowTestUtils.listPartitions(authCtx, dataset2));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error while fetching partitions of dataset %s", smartName2), e);
        }
        List<String> partitionsSpecIds = Arrays.asList(StringUtils.split((String)partitionsSpec, (String)","));
        if (!partitionIds1.containsAll(partitionsSpecIds)) {
            HashSet<String> missingPartitions = new HashSet<String>(partitionsSpecIds);
            missingPartitions.removeAll(partitionIds1);
            throw ErrorContext.iaef((String)"Partitions of dataset '%s' does not contain the selected partitions '%s'", (Object)smartName1, (Object[])new Object[]{missingPartitions});
        }
        if (!partitionIds2.containsAll(partitionsSpecIds)) {
            HashSet<String> missingPartitions = new HashSet<String>(partitionsSpecIds);
            missingPartitions.removeAll(partitionIds2);
            throw ErrorContext.iaef((String)"Partitions of dataset '%s' does not contain the selected partitions '%s'", (Object)smartName2, (Object[])new Object[]{missingPartitions});
        }
    }

    private static List<String> listPartitions(AuthCtx authCtx, Dataset dataset) throws Exception {
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);){
            List<String> partitionIds = PartitioningUtils.toIds(dh.listPartitions());
            List<String> list = PartitioningUtils.sortIdsList(partitionIds, false);
            return list;
        }
    }

    private static FlowComputableSpecification getFlowComputableSpecification(String contextProjectKey, String smartName, String partitionsSpec) {
        DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart(contextProjectKey, smartName);
        return new FlowComputableSpecification().withItemId(datasetLoc.getId()).withType(FlowComputable.FCType.DATASET).withProjectKey(datasetLoc.getProjectKey()).withPartitionSpec(partitionsSpec);
    }

    private static boolean performComparison(DSSAuthCtx authCtx, String contextProjectKey, FlowItemsToCompare flowItemsToCompare, ReportItem.StepDone stepReportItem) throws Exception {
        DatasetComparisonService datasetComparisonService = (DatasetComparisonService)SpringUtils.getBean(DatasetComparisonService.class);
        FlowComputableSpecification resultSpec = FlowTestUtils.getFlowComputableSpecification(contextProjectKey, flowItemsToCompare.resultSmartName, flowItemsToCompare.partitionsSpec);
        FlowComputableSpecification expectedSpec = FlowTestUtils.getFlowComputableSpecification(contextProjectKey, flowItemsToCompare.expectedSmartName, flowItemsToCompare.partitionsSpec);
        if (!Objects.equals(resultSpec.partitionsSpec, expectedSpec.partitionsSpec)) {
            throw new IllegalArgumentException(String.format("The comparison of datasets must be done on the same partitions. Result dataset partitions : %s ; Expected dataset partitions : %s", resultSpec.partitionsSpec, expectedSpec.partitionsSpec));
        }
        boolean builtDatasetEqualsReference = datasetComparisonService.datasetsAreEqual(authCtx, contextProjectKey, FlowTestUtils.getFlowComputableSpecification(contextProjectKey, flowItemsToCompare.resultSmartName, flowItemsToCompare.partitionsSpec), FlowTestUtils.getFlowComputableSpecification(contextProjectKey, flowItemsToCompare.expectedSmartName, flowItemsToCompare.partitionsSpec), flowItemsToCompare.compareAllColumns ? null : flowItemsToCompare.equalityColumns, flowItemsToCompare.contentComparison);
        if (builtDatasetEqualsReference) {
            return true;
        }
        Object comparisonErrorMessage = String.format("Dataset %s does not match its reference %s", flowItemsToCompare.resultSmartName, flowItemsToCompare.expectedSmartName);
        if (!flowItemsToCompare.compareAllColumns && flowItemsToCompare.equalityColumns != null) {
            comparisonErrorMessage = (String)comparisonErrorMessage + String.format(" on columns %s", flowItemsToCompare.equalityColumns);
        }
        logger.warn(comparisonErrorMessage);
        stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
        return false;
    }

    private static void registerComparisonEvent(FlowItemsToCompare flowItemsToCompare, String contextProjectKey, StepRun stepRun, ReportItem.Outcome outcome, long comparisonStartTime, @Nullable WarningsContext.SerializedThrowable thrown) {
        DatasetLocUtils.DatasetLoc resultLoc = DatasetLocUtils.resolveSmart(contextProjectKey, flowItemsToCompare.resultSmartName);
        DatasetLocUtils.DatasetLoc expectedLoc = DatasetLocUtils.resolveSmart(contextProjectKey, flowItemsToCompare.expectedSmartName);
        ReportTargetItem.ComparableDatasetsItem reportTargetItem = new ReportTargetItem.ComparableDatasetsItem(resultLoc.getId(), contextProjectKey.equals(resultLoc.getProjectKey()) ? null : resultLoc.getProjectKey(), expectedLoc.getId(), contextProjectKey.equals(expectedLoc.getProjectKey()) ? null : expectedLoc.getProjectKey(), flowItemsToCompare.partitionsSpec, flowItemsToCompare.contentComparison, flowItemsToCompare.compareAllColumns, flowItemsToCompare.equalityColumns);
        FlowTestUtils.registerEvent(new ReportItem.ComparedDatasets(reportTargetItem), stepRun, outcome, comparisonStartTime, thrown);
    }

    public static void restoreInitialState(DSSAuthCtx authCtx, StepRun stepRun, Map<SerializedRecipe, List<FlowItemsToSwap>> toSwapBack) throws CodedException, IOException, DKUSecurityException {
        if (toSwapBack.isEmpty()) {
            logger.info((Object)"No swaps have been performed, no need to restore the initial state.");
            return;
        }
        for (Map.Entry<SerializedRecipe, List<FlowItemsToSwap>> entry : toSwapBack.entrySet()) {
            SerializedRecipe recipe = entry.getKey();
            List<FlowItemsToSwap> recipeSwaps = entry.getValue();
            for (FlowItemsToSwap dsSwap : recipeSwaps) {
                logger.infoV("Restoring dataset %s with dataset %s as input for recipe %s", new Object[]{dsSwap.sourceSmartName, dsSwap.targetSmartName, recipe.getId()});
                try {
                    FlowTestUtils.swapRecipeInputs(authCtx, recipe.projectKey, recipe, dsSwap.sourceSmartName, dsSwap.targetSmartName);
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Error while restoring initial state in step %s", new Object[]{stepRun.getStep().getName()});
                    FlowTestUtils.registerInitialStateRestorationEvent(stepRun, ReportItem.Outcome.FAILED, DateTime.now().getMillis(), new WarningsContext.SerializedThrowable((Throwable)e));
                    throw e;
                }
            }
        }
        FlowTestUtils.registerInitialStateRestorationEvent(stepRun, ReportItem.Outcome.SUCCESS, DateTime.now().getMillis(), null);
    }

    private static <T extends ReportItem> void registerEvent(T reportItem, StepRun stepRun, ReportItem.Outcome outcome, long startTime, @Nullable WarningsContext.SerializedThrowable thrown) {
        ReadWriteJobsInternalDB readWriteJobsInternalDB = (ReadWriteJobsInternalDB)SpringUtils.getBean(ReadWriteJobsInternalDB.class);
        reportItem = reportItem.withStart(startTime).withEnd(DateTime.now().getMillis()).withOutcome(outcome).withThrown(thrown);
        readWriteJobsInternalDB.tryRegisterFlowObjectEvent(new AnyLoc(stepRun.getScenarioRun().getScenario().getProjectKey(), stepRun.getScenarioRun().getScenario().id), null, null, stepRun.getScenarioRun(), stepRun, (ReportItem)reportItem);
    }
}

