/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports;

import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.scoring.exports.ScoringExporter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import java.io.IOException;

public class ScoringModelExportThread
extends SimpleFutureThread<ScoringExportResponse> {
    ScoringExporter exporter;
    FuturePayload futurePayload;

    public ScoringModelExportThread(DSSAuthCtx user, String projectKey, ScoringExporter exporter) throws IOException {
        super((AuthCtx)user);
        this.exporter = exporter;
        this.futurePayload = ScoringModelExportThread.buildFuturePayload(projectKey, exporter);
    }

    private static FuturePayload buildFuturePayload(String projectKey, ScoringExporter exporter) throws IOException {
        FuturePayload fp = new FuturePayload();
        fp.action = "ml-scoring-export";
        String fileName = exporter.writer.makeFileName();
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, fileName));
        fp.displayName = "Export scoring from " + projectKey + " to " + fileName;
        fp.displayName = fileName;
        return fp;
    }

    public FuturePayload getPayload() {
        return this.futurePayload;
    }

    @Override
    protected ScoringExportResponse compute() throws Exception {
        ScoringExportResponse response = new ScoringExportResponse();
        response.exportId = this.exporter.export();
        return response;
    }

    public static class ScoringExportResponse {
        public String exportId;
    }
}

