/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml.models.regression;

import com.dataiku.dip.scoring.exports.pmml.XML;
import com.dataiku.dip.scoring.exports.pmml.models.PMMLModel;
import com.dataiku.scoring.models.LinearRegression;
import java.util.ArrayList;
import java.util.List;

public class PMMLRegressionModel
extends PMMLModel {
    @XML.Element
    public List<PMMLLogisticRegressionTable> RegressionTable;
    @XML.Attribute
    public double intercept;
    @XML.Element
    List<PMMLNumericPredictor> NumericPredictor;

    public static class PMMLNumericPredictor {
        @XML.Attribute
        public String name;
        @XML.Attribute
        public double coefficient;
        @XML.Attribute
        public int exponent = 1;

        public PMMLNumericPredictor(String name, double coefficient) {
            this.name = name;
            this.coefficient = coefficient;
        }
    }

    public static class PMMLLogisticRegressionTable
    extends PMMLRegressionModel {
        @XML.Attribute
        String targetCategory;

        public PMMLLogisticRegressionTable(String targetCategory, double intercept, double[] coefs, String[] varNames) {
            this.targetCategory = targetCategory;
            this.intercept = intercept;
            this.NumericPredictor = new ArrayList();
            for (int i = 0; i < coefs.length; ++i) {
                this.NumericPredictor.add(new PMMLNumericPredictor(varNames[i], coefs[i]));
            }
        }

        public PMMLLogisticRegressionTable(String targetCategory) {
            this.targetCategory = targetCategory;
            this.intercept = 0.0;
        }
    }

    public static class PMMLLinearRegressionTable
    extends PMMLRegressionModel {
        public PMMLLinearRegressionTable(String[] col, LinearRegression reg) {
            this.intercept = reg.getIntercept();
            double[] coef = reg.getCoefficients();
            this.NumericPredictor = new ArrayList(col.length);
            for (int i = 0; i < col.length; ++i) {
                this.NumericPredictor.add(new PMMLNumericPredictor(col[i], coef[i]));
            }
        }
    }
}

