/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.datacollections.DataCollectionsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IDataCollectionPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.ConfigurablePublicAPIKey;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataCollectionPermissionsService
implements IDataCollectionPermissionsService {
    @Autowired
    DataCollectionsDAO dataCollectionsDAO;
    @Autowired
    ProjectsService projectsService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.data-collections");

    @Override
    public boolean hasDataCollectionPrivileges(AuthCtx u, DataCollection dataCollection, Privileges.DataCollectionLevelPrivilegeType ... privileges) throws DKUSecurityException {
        for (Privileges.DataCollectionLevelPrivilegeType privilege : privileges) {
            if (this.hasDataCollectionPrivilege(u, dataCollection, privilege)) continue;
            return false;
        }
        return true;
    }

    public boolean filterOnHasDataCollectionPrivileges(AuthCtx u, DataCollection dataCollection, Privileges.DataCollectionLevelPrivilegeType ... privileges) {
        try {
            return this.hasDataCollectionPrivileges(u, dataCollection, privileges);
        }
        catch (DKUSecurityException e) {
            logger.errorV((Throwable)e, "Ignoring data collection [%s] after failing to retrieve permissions", new Object[]{dataCollection.id});
            return false;
        }
    }

    @Override
    public void checkDataCollectionPrivileges(AuthCtx u, DataCollection dataCollection, Privileges.DataCollectionLevelPrivilegeType ... privileges) throws DKUSecurityException {
        if (!this.hasDataCollectionPrivileges(u, dataCollection, privileges)) {
            throw new UnauthorizedException("Action forbidden", "data-collections-authorization-failure").with("requiredPrivileges", StringUtils.join((Object[])privileges));
        }
    }

    @Override
    public void checkMayCreateDataCollections(DSSAuthCtx authCtx) throws UnauthorizedException {
        if (!authCtx.getPermissions().mayCreateDataCollections()) {
            throw new UnauthorizedException("You may not create new data collections", "data-collections-create-denied");
        }
    }

    @Override
    public void checkMayPublishToDataCollections(DSSAuthCtx authCtx) throws UnauthorizedException {
        if (!authCtx.getPermissions().mayPublishToDataCollections()) {
            throw new UnauthorizedException("You may not publish objects to data collections", "data-collections-publish-denied");
        }
    }

    public void checkAllUserGroupCanBeAdded(DataCollection dataCollection) throws DKUSecurityException, IOException {
        GeneralSettingsDAO.GeneralSettings gs = this.generalSettingsDAO.getUnsafe();
        if (gs.security.restrictUsersAndGroupsVisibility && dataCollection.permissions.stream().anyMatch(p -> "$$ALL_USERS$$".equals(p.group))) {
            throw new DKUSecurityException("You cannot add the 'All users' group due to the general settings of your instance.");
        }
    }

    private boolean hasDataCollectionPrivilege(AuthCtx u, DataCollection dataCollection, Privileges.DataCollectionLevelPrivilegeType privilege) throws DKUSecurityException {
        assert (u != null);
        if (dataCollection == null || dataCollection.permissions == null) {
            return false;
        }
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)u).getAsConfigurableAPIKey();
                return cpa.isGlobalAdmin();
            }
            case CONFIGURABLE_API_KEY_PROJECT: {
                return false;
            }
            case GLOBAL_API_KEY_WITH_GROUPS: 
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (u.isAdmin()) {
                    return true;
                }
                if (u.getAssociatedDSSUser() != null) {
                    String dssUser = u.getAssociatedDSSUserMand();
                    for (BasePermissions.PermissionItem pi : dataCollection.permissions) {
                        if (!dssUser.equals(pi.user) || !DataCollectionPermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return true;
                    }
                }
                HashSet<String> groups = new HashSet<String>(u.getGroups());
                groups.add("$$ALL_USERS$$");
                for (String gid : groups) {
                    for (BasePermissions.PermissionItem pi : dataCollection.permissions) {
                        if (!gid.equals(pi.group) || !DataCollectionPermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return true;
                    }
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    public static boolean permissionItemIncludes(BasePermissions.PermissionItem item, Privileges.DataCollectionLevelPrivilegeType privilege) {
        switch (privilege) {
            case ADMIN: {
                return item.admin;
            }
            case WRITE: {
                return item.admin || item.write;
            }
            case READ: {
                return item.admin || item.write || item.read;
            }
        }
        throw new Error("forbidden");
    }

    @Override
    public boolean isObjectContainedInAnyReadableDataCollection(AuthCtx user, String projectKey, ITaggingService.TaggableType objectType, String objectId) throws IOException, DKUSecurityException {
        if (objectType != ITaggingService.TaggableType.DATASET) {
            return false;
        }
        AbstractDataCollectionItemRef.DatasetRef ref = new AbstractDataCollectionItemRef.DatasetRef(projectKey, objectId);
        for (DataCollection dc : this.dataCollectionsDAO.listUnsafe()) {
            if (!dc.contains(ref) || !this.hasDataCollectionPrivilege(user, dc, Privileges.DataCollectionLevelPrivilegeType.READ)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkDataCollectionActuallyContainsItem(DataCollection dataCollection, AbstractDataCollectionItemRef item) throws UnauthorizedException {
        boolean actuallyContainsItem = dataCollection.items.stream().anyMatch(item::refersTo);
        if (!actuallyContainsItem) {
            logger.warn((Object)("Requested item " + String.valueOf(item) + " is not contained in collection " + dataCollection.getId()));
            throw DataCollectionPermissionsService.notAuthorizedItemException(item);
        }
    }

    public void checkItemVisibility(AbstractDataCollectionItemRef itemRef) throws IOException, DKUSecurityException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (itemRef instanceof AbstractDataCollectionItemRef.DatasetRef) {
            AbstractDataCollectionItemRef.DatasetRef datasetRef = (AbstractDataCollectionItemRef.DatasetRef)itemRef;
            if (!this.hasAnyVisibilityOnDataCollectionObject(t.getUser(), datasetRef.projectKey, ITaggingService.TaggableType.DATASET, datasetRef.id)) {
                throw DataCollectionPermissionsService.notAuthorizedItemException(datasetRef);
            }
        }
    }

    public boolean hasAnyVisibilityOnDataCollectionObject(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType type, String objectId) throws IOException, DKUSecurityException {
        return this.projectsService.getDataCollectionObjectVisibility(authCtx, projectKey, type, objectId, true, false) != ProjectsService.ObjectVisibility.NONE;
    }

    public boolean hasAnyVisibilityOnDataCollectionObjectNoThrows(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType type, String objectId) {
        try {
            return this.hasAnyVisibilityOnDataCollectionObject(authCtx, projectKey, type, objectId);
        }
        catch (DKUSecurityException | IOException e) {
            logger.errorV(e, "Failed to retrieve visibility of data collection item [%s.%s.%s]", new Object[]{projectKey, type, objectId});
            return false;
        }
    }

    public static UnauthorizedException notAuthorizedItemException(AbstractDataCollectionItemRef item) {
        return new UnauthorizedException("You are not allowed to read data collection item " + String.valueOf(item), "data-collections-read-item-denied");
    }
}

