/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipReadFS;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.imfs.InMemoryDiff;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;

public class DiagConfigRedactionUtils {
    public static final Pattern configFilesExclude = Pattern.compile("^(configkey\\.json|\\.git)$");
    private static final Set<String> fullyRedactedFiles = Sets.newHashSet((Object[])new String[]{"achievements.json", "general-settings.json", "internal-apikeys.json", "messaging-channels.json", "personal-apikeys.json", "public-apikeys.json", "user-settings.json", "users.json"});
    private static final RelFile LOCALCONFIG_FOLDER = new RelFile(new String[]{FlowJobUtils.LOCALCONFIG_FOLDER_NAME});
    private static final RelFile LOCALCONFIG_ARCHIVE = new RelFile(new String[]{FlowJobUtils.LOCALCONFIG_ARCHIVE_NAME});
    private static final String[] WHITELISTED_CONNECTION_PROPERTIES = new String[]{"type", "name", "maxActivities", "creationTag", "params", "useGlobalProxy"};

    public static void buildJobDiag(File srcJobDir, ReadWriteFS dstJobDirInDiag, AuthCtx authCtx) throws IOException {
        NativeFS srcJobDirFs = NativeFS.from((File)srcJobDir).skipFileTypeCheck(false).atomicWrite(false).rejectSymlinks(true).build();
        InMemoryDiff jobDirWithoutConfig = new InMemoryDiff((ReadOnlyFS)srcJobDirFs);
        if (srcJobDirFs.isFile(LOCALCONFIG_ARCHIVE)) {
            try (ZipReadFS inputZip = srcJobDirFs.readZip(LOCALCONFIG_ARCHIVE);
                 ZipWriteFS outputZip = dstJobDirInDiag.writeZip(LOCALCONFIG_ARCHIVE);){
                ReadOnlyFS localConfigZipInJobDir = inputZip.directoryView(LOCALCONFIG_FOLDER);
                outputZip.makeDirectory(LOCALCONFIG_FOLDER);
                ReadWriteFS localConfigZipInDiag = outputZip.directoryView(LOCALCONFIG_FOLDER);
                DiagConfigRedactionUtils.copyAndRedactLocalConfig(localConfigZipInJobDir, localConfigZipInDiag, authCtx);
            }
            jobDirWithoutConfig.deleteFile(LOCALCONFIG_ARCHIVE);
        }
        if (srcJobDirFs.isDirectory(LOCALCONFIG_FOLDER)) {
            ReadWriteFS localConfigFolderInJobDir = srcJobDirFs.directoryView(LOCALCONFIG_FOLDER);
            dstJobDirInDiag.makeDirectory(LOCALCONFIG_FOLDER);
            ReadWriteFS localConfigFolderInDiag = dstJobDirInDiag.directoryView(LOCALCONFIG_FOLDER);
            DiagConfigRedactionUtils.copyAndRedactLocalConfig((ReadOnlyFS)localConfigFolderInJobDir, localConfigFolderInDiag, authCtx);
            jobDirWithoutConfig.deleteDirectory(LOCALCONFIG_FOLDER);
        }
        DiagConfigRedactionUtils.redactJobDir((ReadWriteFS)jobDirWithoutConfig, authCtx);
        FSUtils.newRecursiveCopy().from((ReadOnlyFS)jobDirWithoutConfig).to(dstJobDirInDiag).run();
    }

    public static void redactJobDir(ReadWriteFS jobDirWithoutConfig, AuthCtx authCtx) throws IOException {
        if (authCtx.isAdmin()) {
            return;
        }
        for (RelFile rf : jobDirWithoutConfig.listRecursive("/")) {
            String[] rfElts = rf.getElements();
            if (!jobDirWithoutConfig.isFile(rf)) continue;
            if (rfElts.length == 4 && "sparkbased-recipe".equals(rfElts[1]) && "remote-run-env-def.json".equals(rfElts[3])) {
                DiagConfigRedactionUtils.redactRemoteRunEnvDef(jobDirWithoutConfig, rf, authCtx);
            }
            if (!"secret.yaml".equals(rf.getLeafName()) && !"k8s-service-account-token.txt".equals(rf.getLeafName()) && !rf.getLeafName().endsWith(".creds") && !rf.getLeafName().endsWith(".creds.crc") && !rf.getLeafName().endsWith(".keytab") && !rf.getLeafName().endsWith(".pem")) continue;
            jobDirWithoutConfig.writeStringUTF8(rf, "REDACTED");
        }
        if (jobDirWithoutConfig.isDirectory("profiles")) {
            jobDirWithoutConfig.deleteDirectory("profiles");
        }
    }

    private static void redactRemoteRunEnvDef(ReadWriteFS jobDirWithoutConfig, RelFile remoteRunEnvDefRf, AuthCtx authCtx) throws IOException {
        JsonObject remoteRunEnvDef = (JsonObject)jobDirWithoutConfig.readObject(remoteRunEnvDefRf, JsonObject.class);
        JsonObject jobExecEnv = remoteRunEnvDef.getAsJsonObject("jobExecEnv");
        if (jobExecEnv == null) {
            return;
        }
        if (jobExecEnv.has("awsCredential")) {
            jobExecEnv.add("awsCredential", (JsonElement)JF.obj().with("REDACTED", "REDACTED").get());
        }
        if (jobExecEnv.has("connections")) {
            Map connectionsMap = (Map)JSON.parse((JsonElement)jobExecEnv.get("connections"), (TypeToken)new TypeToken<Map<String, DSSConnection>>(){});
            jobExecEnv.add("connections", (JsonElement)DiagConfigRedactionUtils.redactConnectionsMap(connectionsMap, authCtx));
        }
        jobDirWithoutConfig.writeObject(remoteRunEnvDefRf, (Object)remoteRunEnvDef);
    }

    private static void copyAndRedactLocalConfig(ReadOnlyFS srcLocalConfig, ReadWriteFS dstLocalConfig, AuthCtx authCtx) throws IOException {
        InMemoryDiff redactedLocalConfig = new InMemoryDiff(srcLocalConfig);
        DiagConfigRedactionUtils.redactLocalConfig((ReadWriteFS)redactedLocalConfig, authCtx);
        FSUtils.newRecursiveCopy().from((ReadOnlyFS)redactedLocalConfig).to(dstLocalConfig).run();
    }

    public static void redactLocalConfig(ReadWriteFS localConfig, AuthCtx authCtx) throws IOException {
        DiagConfigRedactionUtils.deleteExcludedFilesRecursively(localConfig);
        if (authCtx.isAdmin()) {
            return;
        }
        DiagConfigRedactionUtils.redactUserData(localConfig, authCtx);
        DiagConfigRedactionUtils.redactLicense(localConfig);
        DiagConfigRedactionUtils.handleFullyRedactedFiles(localConfig);
        DiagConfigRedactionUtils.redactAllFilesInDirectory(localConfig, "clusters");
        DiagConfigRedactionUtils.redactAllFilesInDirectory(localConfig, "plugins");
        DiagConfigRedactionUtils.redactConnections(localConfig, authCtx);
        DiagConfigRedactionUtils.removeIrrelevantDirectories(localConfig);
        DiagConfigRedactionUtils.redactNodesDirectory(localConfig);
    }

    private static void redactNodesDirectory(ReadWriteFS localConfig) throws IOException {
        if (localConfig.isFile("nodes-directory.json")) {
            JsonObject nodesDirectory = (JsonObject)localConfig.readObject("nodes-directory.json", JsonObject.class);
            if (!nodesDirectory.has("nodes") || !nodesDirectory.get("nodes").isJsonArray()) {
                return;
            }
            JsonArray nodes = nodesDirectory.getAsJsonArray("nodes");
            for (JsonElement node : nodes) {
                if (!node.isJsonObject()) continue;
                JsonObject nodeObj = node.getAsJsonObject();
                if (nodeObj.has("adminAPIKey")) {
                    nodeObj.addProperty("adminAPIKey", "REDACTED");
                }
                if (!nodeObj.has("eventServerAuthKey")) continue;
                nodeObj.addProperty("eventServerAuthKey", "REDACTED");
            }
            localConfig.writeObject("nodes-directory.json", (Object)nodesDirectory);
        }
    }

    private static void removeIrrelevantDirectories(ReadWriteFS localConfig) throws IOException {
        localConfig.deleteFileOrDirectory("project_folders");
        localConfig.deleteFileOrDirectory("code-snippets");
        localConfig.deleteFileOrDirectory("api-deployer");
        localConfig.deleteFileOrDirectory("workspaces");
        localConfig.deleteFileOrDirectory("data-collections");
        localConfig.deleteFileOrDirectory("project-deployer");
        localConfig.deleteFileOrDirectory("code_studio_templates");
    }

    private static void redactLicense(ReadWriteFS localConfig) throws IOException {
        if (localConfig.isFile("license.json")) {
            JsonObject license = (JsonObject)localConfig.readObject("license.json", JsonObject.class);
            license.addProperty("r1Sig", "REDACTED");
            license.addProperty("r1PubSig", "REDACTED");
            license.addProperty("r1Pub", "REDACTED");
            localConfig.writeObject("license.json", (Object)license);
        }
    }

    private static void redactConnections(ReadWriteFS localConfig, AuthCtx authCtx) throws IOException {
        if (localConfig.isFile("connections.json")) {
            ConnectionsDAO.ConnectionsFile cf = (ConnectionsDAO.ConnectionsFile)localConfig.readObject("connections.json", ConnectionsDAO.ConnectionsFile.class);
            JsonObject redacted = new JsonObject();
            redacted.add("connections", (JsonElement)DiagConfigRedactionUtils.redactConnectionsMap(cf.connections, authCtx));
            localConfig.writeObject("connections.json", (Object)redacted);
        }
    }

    private static JsonObject redactConnectionsMap(Map<String, DSSConnection> connections, AuthCtx authCtx) {
        JsonObject redactedMap = new JsonObject();
        for (Map.Entry<String, DSSConnection> e : connections.entrySet()) {
            if (e.getValue().isFreelyUsableBy(authCtx) && e.getValue().detailsReadableBy(authCtx)) {
                JsonObject cleanedConn = JSON.toJsonObject((Object)e.getValue(), (String[])new String[0]);
                cleanedConn.add("detailsReadability", (JsonElement)JF.obj().with("REDACTED", "REDACTED").get());
                JsonArray allowedGroups = new JsonArray();
                allowedGroups.add("REDACTED");
                cleanedConn.add("allowedGroups", (JsonElement)allowedGroups);
                redactedMap.add(e.getKey(), (JsonElement)cleanedConn);
                continue;
            }
            if (e.getValue().isFreelyUsableBy(authCtx)) {
                JsonObject jsonConn = JSON.toJsonObject((Object)e.getValue(), (String[])new String[0]);
                JsonObject cleanedConn = new JsonObject();
                for (String k : WHITELISTED_CONNECTION_PROPERTIES) {
                    cleanedConn.add(k, jsonConn.get(k));
                }
                cleanedConn.add("params", (JsonElement)JF.obj().with("REDACTED", "REDACTED").get());
                redactedMap.add(e.getKey(), (JsonElement)cleanedConn);
                continue;
            }
            redactedMap.add("redacted__" + DigestUtils.md5Hex((String)e.getKey()), (JsonElement)JF.obj().with("REDACTED", "REDACTED").get());
        }
        return redactedMap;
    }

    private static void redactAllFilesInDirectory(ReadWriteFS localConfig, String directory) throws IOException {
        if (localConfig.isDirectory(directory)) {
            for (RelFile rf : localConfig.listRecursive(directory)) {
                if (!localConfig.isFile(rf)) continue;
                localConfig.writeStringUTF8(rf, "{\"REDACTED\":\"REDACTED\"}");
            }
        }
    }

    private static void handleFullyRedactedFiles(ReadWriteFS localConfig) throws IOException {
        for (String fullyRedactedFile : fullyRedactedFiles) {
            if (!localConfig.isFile(fullyRedactedFile)) continue;
            localConfig.writeStringUTF8(fullyRedactedFile, "{\"REDACTED\":\"REDACTED\"}");
        }
    }

    private static void redactUserData(ReadWriteFS localConfig, AuthCtx authCtx) throws IOException {
        if (!localConfig.isDirectory("user-data")) {
            return;
        }
        String user = authCtx.getAssociatedDSSUser();
        for (RelFile rf : localConfig.listFiles("user-data")) {
            boolean belongToUser;
            if (!localConfig.isDirectory(rf) || (belongToUser = user != null && rf.getLeafName().equals(user))) continue;
            localConfig.deleteFileOrDirectory(rf);
        }
    }

    private static void deleteExcludedFilesRecursively(ReadWriteFS localConfig) throws IOException {
        for (RelFile rf : localConfig.listRecursive("/")) {
            if (!configFilesExclude.matcher(rf.getLeafName()).matches()) continue;
            localConfig.deleteFileOrDirectory(rf);
        }
    }
}

