/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.audit;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.ActivityDoneEvent;
import com.dataiku.dip.server.notifications.backend.ActivityStartedEvent;
import com.dataiku.dip.server.notifications.backend.JobDoneEvent;
import com.dataiku.dip.server.notifications.backend.JobStartedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobAuditService {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private PubSubService pubSubService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.audit.jobs");

    @PostConstruct
    public void init() {
        this.pubSubService.subscribe("job-started", (DSSEventListener)new DSSEventListener<JobStartedEvent>(){

            public void on(JobStartedEvent evt) {
                AuditContextBase.setAuthContext((AuthCtx)evt.authCtx);
                try {
                    JobAuditService.this.auditTrailService.generic("flow-job-start").with("jobProjectKey", evt.jobDef.projectKey).with("jobId", evt.jobDef.id).with("jobJekPid", (Number)evt.startInfo.kernelPid).with("jobUser", evt.jobDef.initiator).emit();
                }
                finally {
                    AuditContextBase.reset();
                }
            }
        });
        this.pubSubService.subscribe("job-done", (DSSEventListener)new DSSEventListener<JobDoneEvent>(){

            public void on(JobDoneEvent evt) {
                AuditContextBase.setAuthContext((AuthCtx)evt.authCtx);
                try {
                    JobAuditService.this.auditTrailService.generic("flow-job-done").with("jobProjectKey", evt.jobDef.projectKey).with("jobId", evt.jobDef.id).with("jobUser", evt.jobDef.initiator).with("state", evt.status.state.toString()).emit();
                }
                finally {
                    AuditContextBase.reset();
                }
            }
        });
        this.pubSubService.subscribe("job-activity-started", (DSSEventListener)new DSSEventListener<ActivityStartedEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(ActivityStartedEvent evt) {
                AuditContextBase.setAuthContext((AuthCtx)evt.authCtx);
                try {
                    AnyLoc loc;
                    for (SerializedJobActivityStatus.SerializedTargetDS target : evt.status.targets) {
                        loc = AnyLoc.resolveFull(target.id);
                        JobAuditService.this.auditTrailService.generic("flow-object-build-start").with("objectType", target.type.toString()).with("objectProjectKey", loc.getProjectKey()).with("objectId", loc.getId()).with("jobProjectKey", evt.jobDef.projectKey).with("jobId", evt.jobDef.id).with("jobUser", evt.jobDef.initiator).emit();
                    }
                    for (SerializedJobActivityStatus.SerializedSourceDS source : evt.status.sources) {
                        loc = AnyLoc.resolveFull(source.id);
                        JobAuditService.this.auditTrailService.generic("flow-object-use-as-source").with("objectType", source.type.toString()).with("objectProjectKey", loc.getProjectKey()).with("objectId", loc.getId()).with("jobProjectKey", evt.jobDef.projectKey).with("jobId", evt.jobDef.id).with("jobUser", evt.jobDef.initiator).emit();
                    }
                }
                finally {
                    AuditContextBase.reset();
                }
            }
        });
        this.pubSubService.subscribe("job-activity-done", (DSSEventListener)new DSSEventListener<ActivityDoneEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(ActivityDoneEvent evt) {
                AuditContextBase.setAuthContext((AuthCtx)evt.authCtx);
                try {
                    String type = evt.status.state == ActivityState.DONE ? "flow-object-build-success" : "flow-object-build-failed";
                    for (SerializedJobActivityStatus.SerializedTargetDS target : evt.status.targets) {
                        AnyLoc loc = AnyLoc.resolveFull(target.id);
                        JobAuditService.this.auditTrailService.generic(type).with("objectType", target.type.toString()).with("objectProjectKey", loc.getProjectKey()).with("objectId", loc.getId()).with("jobProjectKey", evt.jobDef.projectKey).with("jobId", evt.jobDef.id).with("jobUser", evt.jobDef.initiator).emit();
                    }
                }
                finally {
                    AuditContextBase.reset();
                }
            }
        });
        logger.debug((Object)"Done init job audit service");
    }
}

