/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.impersonation;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.security.impersonation.GroupImpersonationRule;
import com.dataiku.dip.security.impersonation.GroupImpersonationTarget;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.impersonation.ImpersonationConfig;
import com.dataiku.dip.security.impersonation.UserImpersonationRule;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.codec.digest.DigestUtils;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ImpersonationResolverService
implements IImpersonationResolverService {
    private ImpersonationConfig config;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.impersonation.resolver");

    public synchronized void setImpersonationConfig(ImpersonationConfig config) {
        this.config = config;
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.config.enabled;
    }

    @Override
    public synchronized boolean usesHadoopDelegationTokens() {
        return this.config.useHadoopDelegationTokens;
    }

    @Override
    public synchronized UserImpersonationTarget getTargetUser(String contextProjectKey, AuthCtx authCtx) throws DKUSecurityException {
        String dssUserForImpersonation = authCtx.getDSSUserForImpersonation();
        if (StringUtils.isBlank((String)dssUserForImpersonation)) {
            throw new DKUSecurityException("Auth context: " + String.valueOf(authCtx) + " may not impersonate");
        }
        for (UserImpersonationRule rule : this.config.userRules) {
            UserImpersonationTarget ruleResult = this.evaluateUserRule(contextProjectKey, dssUserForImpersonation, rule);
            if (ruleResult == null) continue;
            ImpersonationResolverService.normalizeAndShortenUsernameIfNeeded(ruleResult);
            return ruleResult;
        }
        throw new DKUSecurityException("No user impersonation rule matched for user " + String.valueOf(authCtx)).withCode((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_MUS_USER_UNMATCHED);
    }

    public synchronized GroupImpersonationTarget getHadoopGroupOrNull(String dssGroup) throws DKUSecurityException {
        for (GroupImpersonationRule rule : this.config.groupRules) {
            GroupImpersonationTarget ruleResult = this.evaluateGroupRule(dssGroup, rule);
            if (ruleResult == null) continue;
            return ruleResult;
        }
        return null;
    }

    public synchronized GroupImpersonationTarget getHadoopGroup(String dssGroup) throws DKUSecurityException {
        GroupImpersonationTarget g = this.getHadoopGroupOrNull(dssGroup);
        if (g == null) {
            throw new DKUSecurityException("No group user impersonation rule matched for DSS group:" + dssGroup);
        }
        return g;
    }

    private UserImpersonationTarget evaluateUserRule(String contextProjectKey, String dssUser, UserImpersonationRule rule) throws DKUSecurityException {
        if (rule.scope == UserImpersonationRule.Scope.PROJECT && !rule.projectKey.equals(contextProjectKey)) {
            return null;
        }
        switch (rule.type) {
            case IDENTITY: {
                return new UserImpersonationTarget(dssUser, dssUser);
            }
            case SINGLE_MAPPING: {
                if (StringUtils.isBlank((String)rule.dssUser)) {
                    logger.warn((Object)"An user rule has no DSS user set");
                    return null;
                }
                if (!rule.dssUser.equals(dssUser)) {
                    return null;
                }
                if (StringUtils.isBlank((String)rule.targetUnix)) {
                    throw new DKUSecurityException("User impersonation rule without UNIX user defined").withCode((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INCOMPLETE_SETUP);
                }
                return new UserImpersonationTarget(rule.targetUnix, rule.targetHadoop);
            }
            case REGEXP_RULE: {
                if (StringUtils.isNotBlank((String)rule.ruleFrom)) {
                    Pattern p = Pattern.compile(rule.ruleFrom);
                    Matcher m = p.matcher(dssUser);
                    if (!m.matches()) break;
                    if (StringUtils.isBlank((String)rule.targetUnix)) {
                        throw new DKUSecurityException("User impersonation rule without UNIX user defined").withCode((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INCOMPLETE_SETUP);
                    }
                    String unixReplaced = m.replaceFirst(rule.targetUnix);
                    String hadoopReplaced = StringUtils.isBlank((String)rule.targetHadoop) ? null : m.replaceFirst(rule.targetHadoop);
                    return new UserImpersonationTarget(unixReplaced, hadoopReplaced);
                }
                logger.warn((Object)"An user rule has no regex set");
            }
        }
        return null;
    }

    private GroupImpersonationTarget evaluateGroupRule(String dssGroup, GroupImpersonationRule rule) throws DKUSecurityException {
        switch (rule.type) {
            case IDENTITY: {
                return new GroupImpersonationTarget(dssGroup, dssGroup);
            }
            case SINGLE_MAPPING: {
                if (StringUtils.isBlank((String)rule.dssGroup)) {
                    logger.warn((Object)"A group rule has no DSS group set");
                    return null;
                }
                if (!rule.dssGroup.equals(dssGroup)) {
                    return null;
                }
                if (StringUtils.isBlank((String)rule.targetUnix)) {
                    throw new DKUSecurityException("User impersonation rule without UNIX group defined").withCode((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INCOMPLETE_SETUP);
                }
                return new GroupImpersonationTarget(rule.targetUnix, rule.targetHadoop);
            }
            case REGEXP_RULE: {
                if (StringUtils.isNotBlank((String)rule.ruleFrom)) {
                    Pattern p = Pattern.compile(rule.ruleFrom);
                    Matcher m = p.matcher(dssGroup);
                    if (!m.matches()) break;
                    if (StringUtils.isBlank((String)rule.targetUnix)) {
                        throw new DKUSecurityException("User impersonation rule without UNIX group defined").withCode((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INCOMPLETE_SETUP);
                    }
                    String unixReplaced = m.replaceFirst(rule.targetUnix);
                    String hadoopReplaced = StringUtils.isBlank((String)rule.targetHadoop) ? null : m.replaceFirst(rule.targetHadoop);
                    return new GroupImpersonationTarget(unixReplaced, hadoopReplaced);
                }
                logger.warn((Object)"A group rule has no regex set");
            }
        }
        return null;
    }

    private static void normalizeAndShortenUsernameIfNeeded(UserImpersonationTarget target) {
        int maxLength = DKUApp.getParams().getIntParam("dku.uif.autocreate.normalizeAndShorten", Integer.valueOf(0));
        if (maxLength > 0) {
            target.unixUser = ImpersonationResolverService.normalizeAndShortenUsername(target.unixUser, maxLength);
            target.hadoopUser = ImpersonationResolverService.normalizeAndShortenUsername(target.hadoopUser, maxLength);
        }
    }

    static String normalizeAndShortenUsername(String username, int maxLength) {
        String normalized = username.replaceAll("[^A-Za-z0-9_]", "_");
        return ImpersonationResolverService.shortenIdentifier(normalized, maxLength);
    }

    static String shortenIdentifier(String identifier, int maxLength) {
        assert (maxLength > 8);
        if (identifier.length() <= maxLength) {
            return identifier;
        }
        String hash = DigestUtils.sha1Hex((byte[])identifier.getBytes(StandardCharsets.UTF_8));
        String partialHash = hash.substring(0, 8);
        assert (partialHash.length() == 8);
        int maxLengthForKeptPart = maxLength - 8;
        assert (maxLengthForKeptPart > 0);
        assert (maxLengthForKeptPart < identifier.length());
        String ret = identifier.substring(0, maxLengthForKeptPart) + partialHash;
        assert (ret.length() == maxLength);
        return ret;
    }
}

