/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.PluginCredentialRequestService;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public interface ICredentialsService {
    public Credential getCredential_AutoTXN(AuthCtx var1, DSSConnection var2) throws IOException;

    public Credential getDecryptedCredential_AutoTXN(AuthCtx var1, DSSConnection var2) throws IOException;

    public Credential getDecryptedCredential_AutoTXN(AuthCtx var1, PluginCredentialRequestService.PluginCredentialRequestInfo var2) throws IOException;

    public static class StoredCredential {
        public CredentialType type = CredentialType.BASIC;
        public String user;
        public String password;
        public String refreshToken;
        public Long lastUpdate;
        public String clientId;
    }

    public static class OAuth2CredentialWithExpiry
    extends OAuth2Credential {
        public final long expiry;

        public OAuth2CredentialWithExpiry(String accessToken, long expiry) {
            super(accessToken);
            this.expiry = expiry;
        }
    }

    public static class OAuth2Credential
    extends Credential {
        public String accessToken;

        public OAuth2Credential(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public void decryptInPlace(PasswordEncryptionService cryptoService) {
            this.accessToken = cryptoService.decryptIfEncrypted(this.accessToken);
        }
    }

    public static class OAuthRefreshTokenCredential
    extends Credential {
        public String refreshToken;
        public Long acquisitionTime;
        public String clientId;

        public OAuthRefreshTokenCredential(String refreshToken, Long acquisitionTime, String clientId) {
            this.refreshToken = refreshToken;
            this.acquisitionTime = acquisitionTime;
            this.clientId = clientId;
        }

        @Override
        public void decryptInPlace(PasswordEncryptionService cryptoService) {
            this.refreshToken = cryptoService.decryptIfEncrypted(this.refreshToken);
        }
    }

    public static class BasicCredential
    extends Credential
    implements BasicCredentialConvertible {
        public String user;
        public String password;

        public BasicCredential() {
        }

        public BasicCredential(String user, String password) {
            if (StringUtils.isNotEmpty((CharSequence)user)) {
                this.user = user;
            }
            if (StringUtils.isNotEmpty((CharSequence)password)) {
                this.password = password;
            }
        }

        @Override
        public void decryptInPlace(PasswordEncryptionService cryptoService) {
            this.password = cryptoService.decryptIfEncrypted(this.password);
        }

        @Override
        public BasicCredential toBasicCredential() {
            return this;
        }
    }

    public static interface BasicCredentialConvertible {
        public BasicCredential toBasicCredential();
    }

    public static class SingleFieldCredential
    extends Credential {
        public String value;

        public SingleFieldCredential(String value) {
            this.value = value;
        }

        @Override
        public void decryptInPlace(PasswordEncryptionService cryptoService) {
            this.value = cryptoService.decryptIfEncrypted(this.value);
        }
    }

    public static enum CredentialType {
        SINGLE_FIELD,
        BASIC,
        AZURE_OAUTH_DEVICECODE,
        OAUTH_REFRESH_TOKEN;

    }

    public static abstract class Credential {
        public abstract void decryptInPlace(PasswordEncryptionService var1);
    }
}

