/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.pam;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.pam.PAMService;
import com.dataiku.dip.security.pam.PamCredentialsAuthenticator;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSPamCredentialsAuthenticator
extends PamCredentialsAuthenticator {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");

    @Autowired
    public DSSPamCredentialsAuthenticator(PAMService pamService, GeneralSettingsDAO gsDAO, PubSubService pubSubService) {
        super(pamService);
        this.pamSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().pamSettings;
        pubSubService.subscribe("general-settings-changed", evt -> {
            try {
                GeneralSettingsDAO.GeneralSettings generalSettings = gsDAO.getUnsafeAutoTXN();
                this.pamSettings = generalSettings.pamSettings;
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }
}

