/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.process;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLHandler;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.process.WrapperIsolatedProcess;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InsecureProcessesLaunchService {
    @Autowired
    private IImpersonationResolverService impersonationService;
    private static final Logger logger = Logger.getLogger((String)"dku.security.process");

    public IsolableProcess launch(AuthCtx authCtx, String contextProjectKey, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, File processRunDir, ProcessBuilder pb) throws DKUSecurityException, IOException, InterruptedException {
        return this.launch(authCtx, contextProjectKey, cgrouppableProcessType, processRunDir, pb, null);
    }

    public IsolableProcess launch(AuthCtx authCtx, String contextProjectKey, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, File processRunDir, ProcessBuilder pb, @Nullable String userToImpersonate) throws DKUSecurityException, IOException, InterruptedException {
        if (this.impersonationService.isEnabled()) {
            if (StringUtils.isBlank((String)userToImpersonate)) {
                userToImpersonate = this.impersonationService.getTargetUser((String)contextProjectKey, (AuthCtx)authCtx).unixUser;
            }
            FilesystemACLHandler aclHandler = new FilesystemACLHandler();
            logger.info((Object)("Setting exclusive access on " + String.valueOf(processRunDir)));
            aclHandler.setExclusiveAndStudioFullAccessOnDirectory(processRunDir, userToImpersonate);
            WrapperIsolatedProcess wip = new WrapperIsolatedProcess(pb.command().get(0), pb, userToImpersonate, processRunDir, processRunDir, cgrouppableProcessType, authCtx, contextProjectKey);
            wip.start();
            return wip;
        }
        RegularProcess rp = new RegularProcess(pb, processRunDir, cgrouppableProcessType, authCtx, contextProjectKey);
        rp.start();
        return rp;
    }

    public Pair<IsolableProcess, Runnable> launchWithIntercomDir(AuthCtx authCtx, String contextProjectKey, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, File processRunDir, ProcessBuilder pb, @Nullable String userToImpersonate) throws DKUSecurityException, IOException, InterruptedException {
        if (this.impersonationService.isEnabled()) {
            if (StringUtils.isBlank((String)userToImpersonate)) {
                userToImpersonate = this.impersonationService.getTargetUser((String)contextProjectKey, (AuthCtx)authCtx).unixUser;
            }
            FilesystemACLHandler aclHandler = new FilesystemACLHandler();
            AutoDelete intercomDir = this.getTemporaryIntercomDirectory(aclHandler, contextProjectKey);
            try {
                logger.info((Object)("Setting exclusive access on process pipes directory " + String.valueOf(intercomDir)));
                aclHandler.setExclusiveAndStudioFullAccessOnDirectory((File)intercomDir, userToImpersonate);
                logger.info((Object)("Granting access on process working directory " + String.valueOf(processRunDir) + " to " + userToImpersonate));
                aclHandler.grantAdditionalFullAccess(processRunDir, userToImpersonate);
                WrapperIsolatedProcess wip = new WrapperIsolatedProcess(pb.command().get(0), pb, userToImpersonate, (File)intercomDir, processRunDir, cgrouppableProcessType, authCtx, contextProjectKey);
                wip.start();
                return new Pair((Object)wip, () -> ((AutoDelete)intercomDir).close());
            }
            catch (Exception e) {
                intercomDir.close();
                throw e;
            }
        }
        RegularProcess rp = new RegularProcess(pb, processRunDir, cgrouppableProcessType, authCtx, contextProjectKey);
        rp.start();
        return new Pair((Object)rp, () -> {});
    }

    private AutoDelete getTemporaryIntercomDirectory(FilesystemACLHandler aclHandler, String prefix) throws IOException {
        File intercomFile = ApplicationConfigurator.getFile((String)"uif-tmp");
        try {
            DKUFileUtils.mkdirs((File)intercomFile);
            aclHandler.ensureWorldTraversableOnly(intercomFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create intercom directory", e);
        }
        return new AutoDelete(Files.createTempDirectory(intercomFile.toPath(), prefix, new FileAttribute[0]).toFile());
    }
}

