/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.semanticmodels;

import com.dataiku.dip.semanticmodels.model.SemanticModelVersion;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;

@UIModel
public class SemanticModel
extends TaggableObjectsService.TaggableObject {
    @JSON.FileTransient
    public String id;
    @JSON.FileTransient
    public String projectKey;
    public String name;
    public String activeVersionId;
    public List<SemanticModelVersion> versions = new ArrayList<SemanticModelVersion>();

    public SemanticModelVersion getVersionByIdOrNull(String versionId) {
        for (SemanticModelVersion version : this.versions) {
            if (!version.id.equals(versionId)) continue;
            return version;
        }
        return null;
    }

    public SemanticModelVersion getVersionByIdMand(String versionId) {
        SemanticModelVersion version = this.getVersionByIdOrNull(versionId);
        if (version == null) {
            throw new IllegalArgumentException("No version with id " + versionId);
        }
        return version;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.SEMANTIC_MODEL;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    public static class SemanticModelListItem
    extends TaggableObjectsService.TaggableListItem {
        public SemanticModelListItem(SemanticModel semanticModel) {
            super(semanticModel);
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.SEMANTIC_MODEL;
        }
    }
}

